/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.comm.transport.httpUrlConnection;

import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.client.HttpCommResponse;
import com.tridium.httpClient.comm.client.ResponseHeaders;
import com.tridium.httpClient.comm.transport.BAbstractHttpTransport;
import com.tridium.httpClient.comm.transport.httpUrlConnection.HttpUrlConnectionRequest;
import com.tridium.httpClient.comm.transport.httpUrlConnection.HttpUrlConnectionUtil;
import com.tridium.httpClient.datatypes.auth.BAbstractHttpAuth;
import com.tridium.httpClient.datatypes.exception.HttpCommRuntimeException;
import com.tridium.httpClient.datatypes.payload.BHttpStreamingConfig;
import com.tridium.httpClient.datatypes.payload.BRequestBody;
import com.tridium.httpClient.util.InputStreamUtil;
import com.tridium.util.PrefixLogUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="streamingConfig", type="BHttpStreamingConfig", defaultValue="new BHttpStreamingConfig()")
public class BUrlConnectionHttpTransport
extends BAbstractHttpTransport<HttpUrlConnectionRequest> {
    @Generated
    public static final Property streamingConfig = BUrlConnectionHttpTransport.newProperty((int)0, (BValue)new BHttpStreamingConfig(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUrlConnectionHttpTransport.class);

    @Generated
    public BHttpStreamingConfig getStreamingConfig() {
        return (BHttpStreamingConfig)this.get(streamingConfig);
    }

    @Generated
    public void setStreamingConfig(BHttpStreamingConfig v) {
        this.set(streamingConfig, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public HttpUrlConnectionRequest createNewRequest(BIHttpCommClient client) {
        return new HttpUrlConnectionRequest(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected HttpCommResponse sendInternal(BIHttpCommClient client, HttpUrlConnectionRequest request, BAbstractHttpAuth authenticator) {
        ResponseHeaders responseHeaders;
        int responseCode;
        Exception exception;
        String fault;
        String result;
        boolean failed;
        block22: {
            failed = false;
            result = "";
            fault = "";
            exception = null;
            responseCode = -1;
            HttpURLConnection conn = request.getConnection();
            result = this.sendWithRetries(conn, client, request.getRequestBody());
            responseHeaders = new ResponseHeaders(conn.getHeaderFields());
            try {
                responseCode = conn.getResponseCode();
            }
            catch (IOException e) {
                exception = e;
            }
            if (responseCode == 401) {
                PrefixLogUtil.logWithPrefix((Logger)TRANSPORT_LOG, (Level)Level.WARNING, (String)"HTTP Url Connection transport currently does not handle authentication challenges", (Object)client);
            }
            if (failed |= !HttpCommResponse.isSuccessResponse(responseCode)) {
                try {
                    result = InputStreamUtil.streamToString(conn.getErrorStream());
                    PrefixLogUtil.logWithPrefix((Logger)TRANSPORT_LOG, (Level)Level.FINE, (String)("Error Stream:" + result), (Object)client);
                }
                catch (IOException e) {
                    fault = e.getMessage();
                }
            }
            conn.disconnect();
            break block22;
            catch (Exception e) {
                try {
                    exception = e;
                    failed = true;
                    responseHeaders = new ResponseHeaders(conn.getHeaderFields());
                }
                catch (Throwable throwable) {
                    responseHeaders = new ResponseHeaders(conn.getHeaderFields());
                    try {
                        responseCode = conn.getResponseCode();
                    }
                    catch (IOException e2) {
                        exception = e2;
                    }
                    if (responseCode == 401) {
                        PrefixLogUtil.logWithPrefix((Logger)TRANSPORT_LOG, (Level)Level.WARNING, (String)"HTTP Url Connection transport currently does not handle authentication challenges", (Object)client);
                    }
                    if (failed |= !HttpCommResponse.isSuccessResponse(responseCode)) {
                        try {
                            result = InputStreamUtil.streamToString(conn.getErrorStream());
                            PrefixLogUtil.logWithPrefix((Logger)TRANSPORT_LOG, (Level)Level.FINE, (String)("Error Stream:" + result), (Object)client);
                        }
                        catch (IOException e3) {
                            fault = e3.getMessage();
                        }
                    }
                    conn.disconnect();
                    throw throwable;
                }
                try {
                    responseCode = conn.getResponseCode();
                }
                catch (IOException e4) {
                    exception = e4;
                }
                if (responseCode == 401) {
                    PrefixLogUtil.logWithPrefix((Logger)TRANSPORT_LOG, (Level)Level.WARNING, (String)"HTTP Url Connection transport currently does not handle authentication challenges", (Object)client);
                }
                if (failed |= !HttpCommResponse.isSuccessResponse(responseCode)) {
                    try {
                        result = InputStreamUtil.streamToString(conn.getErrorStream());
                        PrefixLogUtil.logWithPrefix((Logger)TRANSPORT_LOG, (Level)Level.FINE, (String)("Error Stream:" + result), (Object)client);
                    }
                    catch (IOException e5) {
                        fault = e5.getMessage();
                    }
                }
                conn.disconnect();
            }
        }
        return failed ? HttpCommResponse.makeFailed(result, responseCode, responseHeaders, fault, exception) : HttpCommResponse.makeGood(result, responseCode, responseHeaders);
    }

    private String sendWithRetries(HttpURLConnection conn, BIHttpCommClient client, BRequestBody requestBody) {
        boolean retryOnConnectionFailure = client.getHttpTuningPolicy().getRetryOnConnectionFailure();
        IOException lastFail = null;
        int attempts = 1 + (retryOnConnectionFailure ? 1 : 0);
        for (int attempt = 1; attempt <= attempts; ++attempt) {
            PrefixLogUtil.logWithPrefix((Logger)TRANSPORT_LOG, (Level)Level.FINE, (String)("Attempting connect attempt " + attempt + " of " + attempts), (Object)client);
            try {
                if (HttpUrlConnectionUtil.requiresRequestBody(conn)) {
                    conn.setDoOutput(true);
                    HttpUrlConnectionUtil.setContentLength(conn, this.getStreamingConfig(), requestBody.getSource().length());
                }
                HttpUrlConnectionUtil.printConnDebug(conn, client);
                conn.connect();
                HttpUrlConnectionUtil.addPostData(conn, requestBody);
            }
            catch (IOException e) {
                PrefixLogUtil.logWithPrefix((Logger)TRANSPORT_LOG, (Level)Level.FINE, (String)("Could not connect to " + conn.getURL()), (Throwable)e, (Object)client);
                lastFail = e;
                continue;
            }
            return BUrlConnectionHttpTransport.getResponseFromConnection(conn);
        }
        String retriesUp = "Attempts exceeded (" + attempts + ") accessing " + conn.getURL();
        PrefixLogUtil.logWithPrefix((Logger)TRANSPORT_LOG, (Level)Level.FINE, (String)retriesUp, (Object)client);
        throw new HttpCommRuntimeException(retriesUp, lastFail);
    }

    private static String getResponseFromConnection(HttpURLConnection conn) {
        try {
            return InputStreamUtil.streamToString(conn.getInputStream());
        }
        catch (IOException e) {
            throw new HttpCommRuntimeException("Error reading response", e);
        }
    }
}

