/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.comm.transport;

import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.client.BIHttpCommClientTransport;
import com.tridium.httpClient.comm.client.BIHttpCommClientWrite;
import com.tridium.httpClient.datatypes.BHttpAddress;
import com.tridium.httpClient.datatypes.BHttpTuningPolicy;
import com.tridium.httpClient.datatypes.auth.BAbstractHttpAuth;
import com.tridium.httpClient.datatypes.auth.BAuthorizationHeaderScheme;
import com.tridium.httpClient.datatypes.auth.BTokenAuthScheme;
import com.tridium.httpClient.datatypes.enums.BHttpMode;
import com.tridium.httpClient.datatypes.exception.HttpCommException;
import com.tridium.httpClient.datatypes.options.BHttpHeaders;
import com.tridium.httpClient.datatypes.options.BHttpParameters;
import com.tridium.httpClient.datatypes.payload.BAbstractPayloadSource;
import com.tridium.httpClient.datatypes.payload.BRequestBody;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.httpClient.util.HttpConsumable;
import com.tridium.util.IPrefixLoggable;
import com.tridium.util.PrefixLogUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.httpClient.datatypes.BHttpRequestMethod;

public abstract class HttpRequestInstance
implements IPrefixLoggable,
HttpConsumable {
    private final BIHttpCommClient client;

    protected HttpRequestInstance(BIHttpCommClient client) {
        this.client = client;
    }

    public abstract HttpRequestInstance applyAddress(BHttpAddress var1) throws HttpCommException;

    public abstract HttpRequestInstance applyHeaders(BHttpHeaders var1) throws HttpCommException;

    public abstract HttpRequestInstance applyAuthenticator(BAbstractHttpAuth var1) throws HttpCommException;

    public abstract HttpRequestInstance applyTuningPolicy(BHttpTuningPolicy var1) throws HttpCommException;

    public abstract HttpRequestInstance applyData(BHttpRequestMethod var1, BHttpParameters var2, BRequestBody var3) throws HttpCommException;

    public final HttpRequestInstance apply(BIHttpCommClientTransport transport, BIHttpCommClientWrite write) throws HttpCommException, PrivilegedActionException {
        BHttpParameters params = (BHttpParameters)this.client.getParameters().prepareForSend().as(BHttpParameters.class);
        BAbstractHttpAuth authenticator = transport.getAuthenticator().getConfig();
        BHttpHeaders preparedHeaders = (BHttpHeaders)this.client.getHeaders().prepareForSend().as(BHttpHeaders.class);
        AccessController.doPrivileged(() -> {
            authenticator.appendParameters(params);
            authenticator.appendHeaders(preparedHeaders);
            return null;
        });
        return this.verify(this.client, transport).applyAddress(this.client.getAddress()).applyHeaders(preparedHeaders).applyAuthenticator(authenticator).applyTuningPolicy(this.client.getHttpTuningPolicy()).applyData(this.client.getMethod(), params, this.initPayload(write));
    }

    public BRequestBody initPayload(BIHttpCommClientWrite write) {
        if (write != null) {
            BRequestBody requestBody = write.getRequestBody();
            BAbstractPayloadSource source = requestBody.getSource();
            source.prepareToSend();
            requestBody.getContentTypeHeader().calculate();
            PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, () -> String.format("payload: [%s]", source.identifierForLogs()), (Object)write);
            return requestBody;
        }
        return null;
    }

    public HttpRequestInstance verify(BIHttpCommClient client, BIHttpCommClientTransport transport) throws HttpCommException {
        BAbstractHttpAuth authenticator = transport.getAuthenticator().getConfig();
        if (client.getAddress().getMode() == BHttpMode.insecure && (authenticator instanceof BAuthorizationHeaderScheme || authenticator instanceof BTokenAuthScheme)) {
            throw new HttpCommException(transport.getAuthenticator().getConfig().getType().getTypeName() + " requires HTTPS");
        }
        return this;
    }

    public BIHttpCommClient getClient() {
        return this.client;
    }
}

