/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.comm.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.baja.web.authn.CaseInsensitiveStringKey;

public class ResponseHeaders {
    public static final ResponseHeaders EMPTY = new ResponseHeaders(Collections.emptyMap());
    private final Map<CaseInsensitiveStringKey, List<String>> headers = new HashMap<CaseInsensitiveStringKey, List<String>>();

    public ResponseHeaders(Map<String, List<String>> headerValues) {
        headerValues.forEach((? super K headerName, ? super V values) -> {
            if (headerName != null) {
                CaseInsensitiveStringKey key = new CaseInsensitiveStringKey(headerName);
                this.headers.putIfAbsent(key, new ArrayList());
                if (values != null) {
                    this.headers.get(key).addAll((Collection<String>)values);
                }
            }
        });
    }

    public void forEach(BiConsumer<String, List<String>> consumer) {
        this.headers.forEach((? super K keyWrapper, ? super V value) -> consumer.accept(keyWrapper.getKey(), (List<String>)value));
    }

    public Optional<String> getHeader(String headerName) {
        List<String> headerVals = this.headers.get(new CaseInsensitiveStringKey(headerName));
        return headerVals != null && !headerVals.isEmpty() ? Optional.of(headerVals.get(0)) : Optional.empty();
    }

    public Optional<List<String>> getAllValues(String headerName) {
        List<String> headerVals = this.headers.get(new CaseInsensitiveStringKey(headerName));
        return headerVals != null ? Optional.of(headerVals) : Optional.empty();
    }
}

