/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.comm.client;

import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.client.BIHttpCommClientWrite;
import com.tridium.httpClient.comm.client.HttpCommResponse;
import com.tridium.httpClient.comm.client.IAuthenticationSource;
import com.tridium.httpClient.comm.transport.BAbstractHttpTransport;
import com.tridium.httpClient.comm.transport.BHttpTransport;
import com.tridium.httpClient.comm.transport.HttpRequestInstance;
import com.tridium.httpClient.datatypes.exception.HttpCommException;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.httpClient.util.LicenseUtil;
import com.tridium.util.PrefixLogUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInterface;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public interface BIHttpCommClientTransport
extends BInterface,
IAuthenticationSource {
    @Generated
    public static final Type TYPE = Sys.loadType(BIHttpCommClientTransport.class);

    default public HttpCommResponse send(BIHttpCommClient client) {
        return this.send(client, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public HttpCommResponse send(BIHttpCommClient client, BIHttpCommClientWrite write) {
        HttpCommResponse response;
        BAbstractHttpTransport comm = this.getTransport().getComm();
        try {
            LicenseUtil.licenseCheck();
            Object object = this.getTransport().getSendLock();
            synchronized (object) {
                HttpRequestInstance request;
                try {
                    request = ((HttpRequestInstance)comm.createNewRequest(client)).apply(this, write);
                }
                catch (Exception e) {
                    throw new HttpCommException("Failed to build request", e);
                }
                HttpClientUtils.updateConsumers((BComponent)client, request);
                PrefixLogUtil.logWithPrefix((Logger)BAbstractHttpTransport.TRANSPORT_LOG, (Level)Level.FINE, () -> String.format("Sending request: [%s]", request.identifierForLogs()), (Object)client);
                long start = Clock.millis();
                response = comm.send(client, request, this.getAuthenticator().getConfig());
                response.setDurationMillis(Clock.millis() - start);
            }
        }
        catch (Exception e) {
            response = HttpCommResponse.makeFailed(e);
        }
        if (response.getException() != null) {
            PrefixLogUtil.logWithPrefix((Logger)BAbstractHttpTransport.TRANSPORT_LOG, (Level)Level.SEVERE, (String)"Send Fail", (Throwable)response.getException(), (Object)client);
        }
        HttpClientUtils.updateConsumers((BComponent)client, response);
        return response;
    }

    public BHttpTransport getTransport();

    public void setTransport(BHttpTransport var1);
}

