/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui.certExt;

import com.tridium.crypto.core.cert.CertificateParseException;
import com.tridium.crypto.core.cert.ext.NExtendedKeyUsage;
import com.tridium.crypto.core.cert.ext.NX509Extension;
import com.tridium.platcrypto.ui.certExt.BBaseKeyUsagePane;
import com.tridium.platcrypto.ui.certExt.BICertExtensionParameterPane;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;

@NiagaraType
@NiagaraAction(name="validateCustomText")
public class BExtendedKeyUsagePane
extends BBaseKeyUsagePane<KeyPurposeId>
implements BICertExtensionParameterPane<NExtendedKeyUsage> {
    @Generated
    public static final Action validateCustomText = BExtendedKeyUsagePane.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BExtendedKeyUsagePane.class);
    private static final List<KeyPurposeId> EXT_KEY_USAGE_OIDS = Collections.unmodifiableList(Arrays.asList(KeyPurposeId.id_kp_serverAuth, KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_codeSigning, KeyPurposeId.id_kp_emailProtection, KeyPurposeId.id_kp_timeStamping, KeyPurposeId.id_kp_OCSPSigning, KeyPurposeId.id_kp_smartcardlogon));
    private static final String EXT_NAME = LEX.getText("cert.field.extendedKeyUsage");
    private static final String ADD_CUSTOM_KEY = "cert.extendedKeyUsage.commands.addCustom.displayName";
    private static final String HELP_LEX_KEY = "eku";
    private static final String OID = Extension.extendedKeyUsage.getId();
    private final AtomicInteger customEntryIndex = new AtomicInteger();
    private final BGridPane checkboxPane;
    private final BTextField customField = new BTextField("", 20);
    private final BButton addCustomButton = new BButton((Command)new AddCustomCommand((BWidget)this));
    private final BButton helpButton = new BButton((Command)new HelpCmd((BWidget)this));
    private final BGridPane customEntriesPane = new BGridPane(2);

    @Generated
    public void validateCustomText() {
        this.invoke(validateCustomText, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BExtendedKeyUsagePane() {
        BGridPane layoutPane = new BGridPane(1);
        this.checkboxPane = new BGridPane(1);
        layoutPane.add("checkBoxPane", (BValue)this.checkboxPane);
        BFlowPane customConfigPane = new BFlowPane();
        customConfigPane.add("customTxt", (BValue)this.customField);
        customConfigPane.add("addCustom", (BValue)this.addCustomButton);
        customConfigPane.add("customHelp", (BValue)this.helpButton);
        layoutPane.add("customConfigPane", (BValue)customConfigPane);
        layoutPane.add("customEntriesPane", (BValue)this.customEntriesPane);
        this.setContent((BWidget)layoutPane);
        this.addCustomButton.setEnabled(false);
        this.linkTo((BComponent)this.customField, (Slot)BTextEditor.textModified, (Slot)validateCustomText);
    }

    @Override
    public String getExtensionOid() {
        return OID;
    }

    @Override
    public String getExtensionName() {
        return EXT_NAME;
    }

    @Override
    public String getHelpLexiconKey() {
        return HELP_LEX_KEY;
    }

    @Override
    public void loadFromJson(String json, Map<String, Object> properties) throws CertificateParseException, IOException {
        Map<KeyPurposeId, Integer> checkBoxStates = BExtendedKeyUsagePane.getBaseOids();
        this.applyDefaultsForProfile(checkBoxStates, properties);
        if (!json.isEmpty()) {
            NExtendedKeyUsage keyUsage = (NExtendedKeyUsage)NX509Extension.decodeFromString((String)json);
            Set preSelectedOids = keyUsage.getPurposes();
            preSelectedOids.forEach(preSelectedOid -> {
                if (EXT_KEY_USAGE_OIDS.contains(preSelectedOid)) {
                    int state = (Integer)checkBoxStates.get(preSelectedOid);
                    checkBoxStates.put((KeyPurposeId)preSelectedOid, state | 2);
                } else {
                    this.addCustomEntry(preSelectedOid.getId());
                }
            });
        }
        checkBoxStates.forEach((kp, state) -> {
            String kpName = LEX.getText("cert.field.ExtendedKeyUsage." + kp.getId());
            BCheckBox checkBox = new BCheckBox(kpName, (state & 2) > 0);
            checkBox.setEnabled((state & 1) == 0);
            this.checkboxPane.add(SlotPath.escape((String)kpName), (BValue)checkBox);
        });
    }

    @Override
    public NExtendedKeyUsage toExtension(boolean isCritical) throws IOException {
        HashSet<KeyPurposeId> kps = new HashSet<KeyPurposeId>();
        BCheckBox[] checkBoxes = (BCheckBox[])this.checkboxPane.getChildren(BCheckBox.class);
        for (int i = 0; i < checkBoxes.length; ++i) {
            BCheckBox checkBox = checkBoxes[i];
            if (!checkBox.isSelected()) continue;
            kps.add(EXT_KEY_USAGE_OIDS.get(i));
        }
        BLabel[] customLabels = (BLabel[])this.customEntriesPane.getChildren(BLabel.class);
        Arrays.stream(customLabels).filter(lbl -> !(lbl instanceof BButton)).map(lbl -> KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(lbl.getText()))).forEach(kp -> kps.add((KeyPurposeId)kp));
        return NExtendedKeyUsage.make((boolean)isCritical, kps);
    }

    @Override
    public String toDisplayText(Context cx) {
        BCheckBox[] checkBoxes = (BCheckBox[])this.checkboxPane.getChildren(BCheckBox.class);
        String checkboxValues = Arrays.stream(checkBoxes).filter(checkBox -> checkBox.isSelected()).map(checkBox -> SlotPath.unescape((String)checkBox.getName())).collect(Collectors.joining(", "));
        BLabel[] customLabels = (BLabel[])this.customEntriesPane.getChildren(BLabel.class);
        String customValues = Arrays.stream(customLabels).filter(lbl -> !(lbl instanceof BButton)).map(lbl -> lbl.getText()).collect(Collectors.joining(", "));
        return customValues.isEmpty() ? checkboxValues : (checkboxValues.isEmpty() ? customValues : String.join((CharSequence)", ", checkboxValues, customValues));
    }

    public void doValidateCustomText() {
        String customOid = this.customField.getText();
        this.addCustomButton.setEnabled(BExtendedKeyUsagePane.isValidOid(customOid));
    }

    @Override
    protected void applyDefaultsForClientProfile(Map<KeyPurposeId, Integer> checkBoxStates) {
        BExtendedKeyUsagePane.preselect(checkBoxStates, KeyPurposeId.id_kp_clientAuth);
    }

    @Override
    protected void applyDefaultsForServerProfile(Map<KeyPurposeId, Integer> checkBoxStates) {
        BExtendedKeyUsagePane.preselect(checkBoxStates, KeyPurposeId.id_kp_serverAuth, KeyPurposeId.id_kp_clientAuth);
    }

    @Override
    protected void applyDefaultsForCAProfile(Map<KeyPurposeId, Integer> checkBoxStates) {
    }

    @Override
    protected void applyDefaultsForCodeSigningProfile(Map<KeyPurposeId, Integer> checkBoxStates) {
        BExtendedKeyUsagePane.preselect(checkBoxStates, KeyPurposeId.id_kp_codeSigning);
    }

    private void addCustomEntry(String newOidText) {
        int index = this.customEntryIndex.getAndIncrement();
        this.customEntriesPane.add("lbl" + index, (BValue)new BLabel(newOidText));
        this.customEntriesPane.add("btn" + index, (BValue)new BButton((Command)new RemoveCmd((BWidget)this, index)));
    }

    private static boolean isValidOid(String customOid) {
        try {
            new ASN1ObjectIdentifier(customOid);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static Map<KeyPurposeId, Integer> getBaseOids() {
        return EXT_KEY_USAGE_OIDS.stream().collect(Collectors.toMap(flag -> flag, flag -> 0, (key1, key2) -> key1, LinkedHashMap::new));
    }

    class RemoveCmd
    extends Command {
        final int index;

        public RemoveCmd(BWidget owner, int index) {
            super(owner, BBaseKeyUsagePane.LEX, "NewCertForm.extension.commands.remove");
            this.index = index;
        }

        public CommandArtifact doInvoke() throws Exception {
            BExtendedKeyUsagePane.this.customEntriesPane.remove("lbl" + this.index);
            BExtendedKeyUsagePane.this.customEntriesPane.remove("btn" + this.index);
            return null;
        }
    }

    class HelpCmd
    extends Command {
        public HelpCmd(BWidget owner) {
            super(owner, BBaseKeyUsagePane.LEX, "help");
        }

        public CommandArtifact doInvoke() throws Exception {
            String lexHelpKey = "cert.extendedKeyUsage.commands.addCustom.help";
            BLabel helpLabel = new BLabel(BBaseKeyUsagePane.LEX.getText(lexHelpKey));
            BDialog.open((BWidget)BExtendedKeyUsagePane.this, (String)BBaseKeyUsagePane.LEX.getText(BExtendedKeyUsagePane.ADD_CUSTOM_KEY), (Object)helpLabel, (int)1);
            return null;
        }
    }

    class AddCustomCommand
    extends Command {
        public AddCustomCommand(BWidget owner) {
            super(owner, BBaseKeyUsagePane.LEX.getText(BExtendedKeyUsagePane.ADD_CUSTOM_KEY));
        }

        public CommandArtifact doInvoke() throws Exception {
            String newOidText = BExtendedKeyUsagePane.this.customField.getText();
            if (!newOidText.isEmpty()) {
                BExtendedKeyUsagePane.this.addCustomEntry(newOidText);
                BExtendedKeyUsagePane.this.customField.setText("");
            }
            return null;
        }
    }
}

