/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui.certExt;

import com.tridium.crypto.core.cert.NGeneralName;
import com.tridium.crypto.core.cert.ext.NSubjectAlternativeName;
import com.tridium.platcrypto.ui.certExt.BSubjectAltNamePane;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.gx.BSize;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.commands.HtmlHelpCommand;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.ReasonFlags;

@NiagaraType
public class BCrlDistributionPointPane
extends BGridPane {
    @Generated
    public static final Type TYPE = Sys.loadType(BCrlDistributionPointPane.class);
    public static final List<Integer> REASON_LIST = new ArrayList<Integer>();
    private final List<GeneralName> distributionPointNames = new ArrayList<GeneralName>();
    private final List<GeneralName> crlNames = new ArrayList<GeneralName>();
    private static final Lexicon LEX;
    private static final String REASON_BOX = "rsnBx";
    private static final GeneralName[] EMPTY_GENERAL_NAMES;
    private static final String EDIT_FULL_BASE = "CrlDistributionPoints.commands.editFullNameSan";
    public static final String REASON_BASE = "cert.field.crlDistributionReason.";
    private static final String EDIT_CRL_ISSUER_BASE = "CrlDistributionPoints.commands.editCrlIssuerSan";
    private static final String FULL_NAME;
    private static final String EDIT_FULL_TITLE;
    private static final String REASONS;
    private static final String REASONS_HELP;
    private static final String CRL_ISSUER;
    private static final String CRL_ISSUER_HELP;
    private static final String EDIT_CRL_ISSUER_TITLE;
    private final BLabel fullNameLabel = new BLabel(FULL_NAME);
    private final BTextEditorPane fullNameText = new BTextEditorPane("", 5, 50, false);
    private final BButton editName = new BButton((Command)new EditCommand("CrlDistributionPoints.commands.editFullNameSan", EDIT_FULL_TITLE, this.distributionPointNames, this.fullNameText));
    private final BFlowPane reasonNamePane = new BFlowPane();
    private final BLabel reasonsLabel = new BLabel(REASONS);
    private final BButton reasonsHelp = new BButton((Command)new HtmlHelpCommand((BWidget)this, REASONS, REASONS_HELP, BSize.make((double)300.0, (double)100.0), null));
    private final BGridPane reasonsGrid = new BGridPane(3);
    private final BFlowPane crlIssuerNamePane = new BFlowPane();
    private final BLabel crlIssuerLabel = new BLabel(CRL_ISSUER);
    private final BButton crlIssuerHelp = new BButton((Command)new HtmlHelpCommand((BWidget)this, CRL_ISSUER, CRL_ISSUER_HELP, BSize.make((double)300.0, (double)100.0), null));
    private final BTextEditorPane crlIssuerText = new BTextEditorPane("", 5, 50, false);
    private final BButton editCrlIssuer = new BButton((Command)new EditCommand("CrlDistributionPoints.commands.editCrlIssuerSan", EDIT_CRL_ISSUER_TITLE, this.crlNames, this.crlIssuerText));

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCrlDistributionPointPane(DistributionPoint distributionPoint) {
        super(3);
        this.add(null, (BValue)this.fullNameLabel);
        this.add(null, (BValue)this.fullNameText);
        this.add(null, (BValue)this.editName);
        this.reasonNamePane.add(null, (BValue)this.reasonsLabel);
        this.reasonNamePane.add(null, (BValue)this.reasonsHelp);
        this.add(null, (BValue)this.reasonNamePane);
        for (int i = 0; i < REASON_LIST.size(); ++i) {
            this.reasonsGrid.add(REASON_BOX + i, (BValue)new BCheckBox(LEX.getText(REASON_BASE + i)));
        }
        this.add(null, (BValue)this.reasonsGrid);
        this.add(null, (BValue)new BLabel());
        this.crlIssuerNamePane.add(null, (BValue)this.crlIssuerLabel);
        this.crlIssuerNamePane.add(null, (BValue)this.crlIssuerHelp);
        this.add(null, (BValue)this.crlIssuerNamePane);
        this.add(null, (BValue)this.crlIssuerText);
        this.add(null, (BValue)this.editCrlIssuer);
        if (distributionPoint != null) {
            this.load(distributionPoint);
        }
    }

    private void load(DistributionPoint distributionPoint) {
        GeneralNames crlGeneralName;
        ReasonFlags reasonFlags;
        DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
        if (distributionPointName != null) {
            GeneralName[] distPointNames = ((GeneralNames)distributionPointName.getName()).getNames();
            this.distributionPointNames.addAll(Arrays.asList(distPointNames));
            List<NGeneralName> nGeneralNames = this.distributionPointNames.stream().map(name -> NGeneralName.make((GeneralName)name)).collect(Collectors.toList());
            this.fullNameText.setText(BSubjectAltNamePane.namesToDisplayText(nGeneralNames));
        }
        if ((reasonFlags = distributionPoint.getReasons()) != null) {
            for (int i = 0; i < REASON_LIST.size(); ++i) {
                if ((reasonFlags.intValue() & REASON_LIST.get(i)) == 0) continue;
                BCheckBox checkBox = (BCheckBox)this.reasonsGrid.get(REASON_BOX + i).as(BCheckBox.class);
                checkBox.setSelected(true);
            }
        }
        if ((crlGeneralName = distributionPoint.getCRLIssuer()) != null) {
            this.crlNames.addAll(Arrays.asList(crlGeneralName.getNames()));
            List<NGeneralName> nGeneralNames = this.crlNames.stream().map(name -> NGeneralName.make((GeneralName)name)).collect(Collectors.toList());
            this.crlIssuerText.setText(BSubjectAltNamePane.namesToDisplayText(nGeneralNames));
        }
    }

    public DistributionPoint getPoint() {
        DistributionPointName distributionPointName = null;
        if (!this.distributionPointNames.isEmpty()) {
            distributionPointName = new DistributionPointName(0, (ASN1Encodable)new GeneralNames(this.distributionPointNames.toArray(EMPTY_GENERAL_NAMES)));
        }
        int reasonsValue = 0;
        for (int i = 0; i < REASON_LIST.size(); ++i) {
            BCheckBox reasonBox = (BCheckBox)this.reasonsGrid.get(REASON_BOX + i).as(BCheckBox.class);
            if (!reasonBox.isSelected()) continue;
            reasonsValue += REASON_LIST.get(i).intValue();
        }
        ReasonFlags reasonFlags = reasonsValue > 0 ? new ReasonFlags(reasonsValue) : null;
        GeneralNames crlGeneralNames = null;
        if (!this.crlNames.isEmpty()) {
            crlGeneralNames = new GeneralNames(this.crlNames.toArray(EMPTY_GENERAL_NAMES));
        }
        return new DistributionPoint(distributionPointName, reasonFlags, crlGeneralNames);
    }

    static {
        REASON_LIST.add(128);
        REASON_LIST.add(64);
        REASON_LIST.add(32);
        REASON_LIST.add(16);
        REASON_LIST.add(8);
        REASON_LIST.add(4);
        REASON_LIST.add(2);
        REASON_LIST.add(1);
        REASON_LIST.add(32768);
        LEX = Lexicon.make((String)TYPE.getModule().getModuleName());
        EMPTY_GENERAL_NAMES = new GeneralName[0];
        FULL_NAME = LEX.getText("CrlDistributionPoints.fullName");
        EDIT_FULL_TITLE = LEX.getText("CrlDistributionPoints.commands.editFullNameSan.title");
        REASONS = LEX.getText("CrlDistributionPoints.reasons");
        REASONS_HELP = LEX.getText("CrlDistributionPoints.reasons.help");
        CRL_ISSUER = LEX.getText("CrlDistributionPoints.crlIssuer");
        CRL_ISSUER_HELP = LEX.getText("CrlDistributionPoints.crlIssuer.help");
        EDIT_CRL_ISSUER_TITLE = LEX.getText("CrlDistributionPoints.commands.editCrlIssuerSan.description");
    }

    class EditCommand
    extends Command {
        private final String title;
        private final List<GeneralName> namesList;
        private final BTextEditorPane textPane;

        public EditCommand(String lexiconBase, String title, List<GeneralName> namesList, BTextEditorPane textPane) {
            super((BWidget)BCrlDistributionPointPane.this, LEX, lexiconBase);
            this.title = title;
            this.namesList = namesList;
            this.textPane = textPane;
        }

        public CommandArtifact doInvoke() throws Exception {
            BSubjectAltNamePane panel = new BSubjectAltNamePane();
            panel.load(this.namesList.toArray(EMPTY_GENERAL_NAMES));
            int dialogResult = BDialog.open((BWidget)BCrlDistributionPointPane.this, (String)this.title, (Object)panel, (int)3);
            if (dialogResult == 1) {
                NSubjectAlternativeName san = panel.toExtension(false);
                this.namesList.clear();
                san.getNames().forEach(nGeneralName -> this.namesList.add(nGeneralName.getName()));
                this.textPane.setText(panel.toDisplayText(null));
            }
            return null;
        }
    }
}

