/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui.certExt;

import com.tridium.collection.SimpleBiHashMap;
import com.tridium.crypto.core.cert.ext.NX509Extension;
import com.tridium.json.JSONObject;
import com.tridium.platcrypto.ui.certExt.BICertExtensionParameterPane;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.util.WbUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.commands.WordWrap;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import org.bouncycastle.asn1.x509.Extension;

@NiagaraType
@NiagaraAction(name="typeChanged")
public class BCertificateExtensionParameterFE
extends BWbFieldEditor {
    @Generated
    public static final Action typeChanged = BCertificateExtensionParameterFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateExtensionParameterFE.class);
    public static final String PROP_KEY_PURPOSE = "keyPurpose";
    public static final String PROP_ENFORCE_KEY_PURPOSE = "enforceKeyPurpose";
    private static final String JSON_VALUE = "value";
    private static final int TEXT_COLS = 50;
    private static final Lexicon LEX = Lexicon.make((String)TYPE.getModule().getModuleName());
    private static final SimpleBiHashMap<String, String> NAME_MAP = new SimpleBiHashMap();
    private static final Map<String, Type> FE_TYPE_MAP = new HashMap<String, Type>();
    private static final Logger LOG = Logger.getLogger("platCrypto");
    private String oidThatCreatedSaveValue;
    private NX509Extension saveValue;
    private BICertExtensionParameterPane<?> editPane;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final BListDropDown extensionNames = new BListDropDown();
    private final BButton helpButton = new BButton((Command)new HelpCmd((BWidget)this));
    private final BBooleanFE critical = new BBooleanFE();
    private final BGridPane valuePane = new BGridPane(2);
    private final BTextEditorPane text = new BTextEditorPane("", 5, 50, false);
    private final BButton edit = new BButton((Command)new EditCmd((BWidget)this));

    @Generated
    public void typeChanged() {
        this.invoke(typeChanged, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCertificateExtensionParameterFE() {
        TypeInfo[] suitablePanels = Sys.getRegistry().getConcreteTypes(BICertExtensionParameterPane.TYPE.getTypeInfo());
        Arrays.stream(suitablePanels).filter(typeInfo -> typeInfo.is(BICertExtensionParameterPane.TYPE)).map(typeInfo -> (BICertExtensionParameterPane)typeInfo.getInstance()).forEach(panelInstance -> {
            NAME_MAP.put((Object)panelInstance.getExtensionOid(), (Object)panelInstance.getExtensionName());
            FE_TYPE_MAP.put(panelInstance.getExtensionOid(), panelInstance.getType());
        });
        NAME_MAP.values().forEach(name -> this.extensionNames.getList().addItem(name));
        this.linkTo((BComponent)this.extensionNames, (Slot)BDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.extensionNames, (Slot)BDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.extensionNames, (Slot)BDropDown.valueModified, (Slot)typeChanged);
        this.linkTo((BComponent)this.critical, (Slot)BWbPlugin.setModified, (Slot)setModified);
        String scaleLabel = LEX.getText("certificateExtensionParameter.type");
        String criticalLabel = LEX.getText("certificateExtensionParameter.critical");
        String valLabel = LEX.getText("certificateExtensionParameter.value");
        BFlowPane extensionsPane = new BFlowPane();
        extensionsPane.add("dropdown", (BValue)this.extensionNames);
        extensionsPane.add("helpButton", (BValue)this.helpButton);
        BGridPane grid = new BGridPane(2);
        grid.add("a", (BValue)new BLabel(scaleLabel));
        grid.add("b", (BValue)extensionsPane);
        grid.add("c", (BValue)new BLabel(criticalLabel));
        grid.add("d", (BValue)this.critical);
        grid.add("e", (BValue)new BLabel(valLabel));
        this.valuePane.add("a", (BValue)this.text);
        this.valuePane.add("b", (BValue)this.edit);
        grid.add("f", (BValue)this.valuePane);
        this.setContent((BWidget)grid);
    }

    public void doTypeChanged() throws Exception {
        this.buildProperties();
        String selectedOid = this.getSelectedOid();
        boolean isCritical = ((BIBoolean)this.critical.getCurrentValue()).getBoolean();
        if (!this.oidMatchesSaveValue()) {
            this.setModified();
        }
        this.populate(selectedOid, isCritical);
    }

    protected void doLoadValue(BObject loadVal, Context context) throws Exception {
        this.buildProperties();
        if (loadVal instanceof BString) {
            String value = ((BString)loadVal).getString();
            if (!value.isEmpty()) {
                JSONObject json = new JSONObject(value);
                if (json.has("oid")) {
                    String oid;
                    this.oidThatCreatedSaveValue = oid = json.getString("oid");
                    this.populate(oid, json.getBoolean("isCritical"));
                } else {
                    this.populateWithDefaults();
                }
            } else {
                this.populateWithDefaults();
            }
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (this.isModified()) {
            boolean isCritical = ((BIBoolean)this.critical.saveValue()).getBoolean();
            String toSave = this.saveValue != null && this.oidMatchesSaveValue() ? this.saveValue.encodeToString() : this.editPane.toExtension(isCritical).encodeToString();
            this.saveValue = null;
            JSONObject json = new JSONObject(toSave);
            json.put("isCritical", isCritical);
            return BString.make((String)json.toString());
        }
        return super.doSaveValue(value, cx);
    }

    private void populate(String oid, boolean criticalVal) throws Exception {
        this.critical.loadValue((BObject)BBoolean.make((boolean)criticalVal));
        String extName = (String)NAME_MAP.get((Object)oid);
        boolean supported = extName != null;
        this.extensionNames.setEnabled(supported);
        this.edit.setEnabled(supported);
        if (supported) {
            this.extensionNames.setSelectedItem((Object)extName);
            this.loadEditPanel();
        } else {
            this.extensionNames.setSelectedIndex(-1);
            this.populateText(LEX.getText("certificateExtensionParameter.unsupportedWb"));
        }
    }

    private void populateWithDefaults() throws Exception {
        this.populate(Extension.subjectAlternativeName.getId(), true);
    }

    private void loadEditPanel() throws Exception {
        String extensionType = this.extensionNames.getSelectedItem().toString();
        String oid = (String)NAME_MAP.getByValue((Object)extensionType);
        this.editPane = BCertificateExtensionParameterFE.getEditPane(oid);
        if (this.editPane != null) {
            String valueToLoad = this.getEditorValueToLoad();
            this.editPane.loadFromJson(valueToLoad, this.properties);
            this.populateTextFromExtension();
        }
    }

    private void buildProperties() {
        Property keyPurposeProp;
        Property enforceKeyPurposeProp;
        BComplex profile = this.findSigningProfile();
        if (profile != null && (enforceKeyPurposeProp = profile.getProperty(PROP_ENFORCE_KEY_PURPOSE)) != null && profile.get(enforceKeyPurposeProp).equals((Object)BBoolean.TRUE) && (keyPurposeProp = profile.getProperty(PROP_KEY_PURPOSE)) != null) {
            this.properties.put(PROP_KEY_PURPOSE, profile.get(keyPurposeProp));
        }
    }

    private BComplex findSigningProfile() {
        if (SigningProfileTypeHolder.SIGNING_PROFILE_TYPE != null) {
            BObject obj;
            BObject ancestor = WbUtil.findAncenstorViaWidgetTree((BWidget)this, (Type)SigningProfileTypeHolder.SIGNING_PROFILE_TYPE);
            if (ancestor != null && ancestor.isComplex()) {
                return ancestor.asComplex();
            }
            BWbShell shell = BWbShell.getWbShell((BWidget)this);
            BComponent activeComp = shell.getActiveOrdTarget().getComponent();
            if (activeComp != null && (obj = WbUtil.findAncenstorViaComponentTree((BComponent)activeComp, (Type)SigningProfileTypeHolder.SIGNING_PROFILE_TYPE)) != null) {
                return obj.asComplex();
            }
        }
        return null;
    }

    private String getSelectedOid() {
        String extensionType = this.extensionNames.getSelectedItem().toString();
        return (String)NAME_MAP.getByValue((Object)extensionType);
    }

    private boolean oidMatchesSaveValue() {
        String selectedOid = this.getSelectedOid();
        return this.oidThatCreatedSaveValue != null && this.oidThatCreatedSaveValue.equals(selectedOid);
    }

    private void populateTextFromExtension() {
        try {
            this.populateText(this.editPane.toDisplayText(this.getCurrentContext()));
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error extracting extension text from editor", e);
            this.populateText(LEX.getText("certificateExtensionParameter.displayTextError"));
        }
    }

    private void populateText(String textValue) {
        this.text.setText(this.getSelectedOid().equals(Extension.cRLDistributionPoints.getId()) ? textValue : WordWrap.wrap((String)textValue, (int)50));
    }

    private static BICertExtensionParameterPane<?> getEditPane(String oid) throws Exception {
        return (BICertExtensionParameterPane)FE_TYPE_MAP.get(oid).getInstance();
    }

    private String getEditorValueToLoad() {
        Object value;
        JSONObject json;
        String valueToLoad;
        String currentVal = this.getCurrentValue().toString();
        String string = valueToLoad = this.saveValue != null && this.oidMatchesSaveValue() ? this.saveValue.encodeToString() : currentVal;
        if (!(!this.oidMatchesSaveValue() || valueToLoad.isEmpty() || !(json = new JSONObject(valueToLoad)).has(JSON_VALUE) || (value = json.get(JSON_VALUE)).equals(JSONObject.NULL) || value.equals("") || value instanceof JSONObject && ((JSONObject)value).isEmpty())) {
            return valueToLoad;
        }
        return "";
    }

    private static final class SigningProfileTypeHolder {
        public static final Type SIGNING_PROFILE_TYPE;

        private SigningProfileTypeHolder() {
        }

        static {
            Type type;
            try {
                type = Sys.getType((String)"signingService:SimpleSigningProfile");
            }
            catch (Exception e) {
                type = null;
            }
            SIGNING_PROFILE_TYPE = type;
        }
    }

    class HelpCmd
    extends Command {
        public HelpCmd(BWidget owner) {
            super(owner, LEX, "help");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BCertificateExtensionParameterFE.this.editPane != null) {
                String lexHelpKey = String.format("extension.type.%s.help", BCertificateExtensionParameterFE.this.editPane.getHelpLexiconKey());
                BLabel helpLabel = new BLabel(LEX.getText(lexHelpKey));
                helpLabel.setSize(500.0, 0.0);
                helpLabel.setWordWrapEnabled(true);
                helpLabel.setHalign(BHalign.left);
                BDialog.open((BWidget)BCertificateExtensionParameterFE.this, (String)BCertificateExtensionParameterFE.this.editPane.getExtensionName(), (Object)helpLabel, (int)1);
            }
            return null;
        }
    }

    class EditCmd
    extends Command {
        public EditCmd(BWidget owner) {
            super(owner, LEX, "edit");
        }

        public CommandArtifact doInvoke() throws Exception {
            int dialogResult = BDialog.open((BWidget)BCertificateExtensionParameterFE.this, (String)BCertificateExtensionParameterFE.this.editPane.getExtensionName(), (Object)BCertificateExtensionParameterFE.this.editPane, (int)3);
            if (dialogResult == 1) {
                BCertificateExtensionParameterFE.this.populateTextFromExtension();
                boolean isCritical = ((BIBoolean)BCertificateExtensionParameterFE.this.critical.getCurrentValue()).getBoolean();
                Object extension = BCertificateExtensionParameterFE.this.editPane.toExtension(isCritical);
                if (BCertificateExtensionParameterFE.this.saveValue == null || !extension.toString().equals(BCertificateExtensionParameterFE.this.saveValue.toString())) {
                    BCertificateExtensionParameterFE.this.saveValue = extension;
                    BCertificateExtensionParameterFE.this.oidThatCreatedSaveValue = extension.getOid().getId();
                    BCertificateExtensionParameterFE.this.setModified();
                }
            }
            return null;
        }
    }
}

