/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NHostExemption;
import com.tridium.platcrypto.ui.BCertViewDialog;
import com.tridium.platcrypto.ui.BX509CertificatePane;
import java.util.Properties;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.wizard.BWizardHeader;

@NiagaraType
public class BExemptionViewDialog
extends BCertViewDialog {
    @Generated
    public static final Type TYPE = Sys.loadType(BExemptionViewDialog.class);
    private NHostExemption hostExemption;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static void show(BWidget owner, NHostExemption hostExemption) throws Exception {
        BExemptionViewDialog dialog = new BExemptionViewDialog(owner, hostExemption);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
    }

    protected BExemptionViewDialog(BWidget parent, NHostExemption hostExemption) throws Exception {
        super(parent, lex.getText("exempt.view.dialog.title"));
        this.hostExemption = hostExemption;
        this.cert = hostExemption.getCertificate();
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    @Override
    protected BWidget buildHeader() {
        return new BWizardHeader(logo, this.cert.getSubject(), lex.getText("exempt.view.dialog.info", new Object[]{this.cert.getSubject()}));
    }

    @Override
    protected BWidget buildProperties() {
        Properties before = new Properties();
        before.setProperty("exempt.field.host", this.hostExemption.getHost());
        if (this.hostExemption.getApproved()) {
            if (this.hostExemption.isTransient()) {
                before.setProperty("exempt.field.approved", lex.getText("exempt.field.approved.transient"));
            } else {
                before.setProperty("exempt.field.approved", lex.getText("exempt.field.approved.true"));
            }
        } else {
            before.setProperty("exempt.field.approved", lex.getText("exempt.field.approved.false"));
        }
        before.setProperty("exempt.field.created", this.hostExemption.getCreated().toString());
        BX509CertificatePane certPane = new BX509CertificatePane(this.cert, before, null);
        return certPane;
    }

    protected void appendProperties(BGridPane grid) {
    }
}

