/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.CertValidationResult;
import com.tridium.platcrypto.ui.BCertViewDialog;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.wizard.BWizardHeader;

@NiagaraType
@NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BExemptionPromptDialog
extends BCertViewDialog {
    @Generated
    public static final Action cancelButtonPressed = BExemptionPromptDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BExemptionPromptDialog.class);
    protected static BImage logo = BImage.make((String)lex.get("cert.warning.x32.icon", "module://icons/x32/warning.png"));
    protected boolean hostNameMismatch = false;
    protected boolean unknownIdentity = false;
    protected boolean certExpired = false;
    protected BButton cancelButton;
    protected boolean closeResult = false;

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static boolean show(BWidget owner, CertValidationResult result) throws Exception {
        BExemptionPromptDialog dialog = new BExemptionPromptDialog(owner, result);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BExemptionPromptDialog(BWidget parent, CertValidationResult result) throws Exception {
        super(parent, lex.getText("exempt.prompt.dialog.title"));
        this.cert = result.getNewCert();
        this.hostNameMismatch = !result.isHostnameVerified();
        this.unknownIdentity = !result.isValidCertChain();
        this.certExpired = result.isCertExpired();
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    @Override
    protected BWidget buildHeader() {
        return new BWizardHeader(logo, this.cert.getSubject(), lex.getText("exempt.prompt.dialog.info", new Object[]{this.cert.getSubject()}));
    }

    @Override
    protected BWidget buildContent() throws Exception {
        BEdgePane edgePane = new BEdgePane();
        edgePane.setTop(this.buildInfo());
        edgePane.setCenter(super.buildContent());
        return edgePane;
    }

    private BWidget buildInfo() {
        StringBuilder info = new StringBuilder();
        info.append(lex.getText("exempt.prompt.dialog.msg.untrusted")).append(":").append("\n");
        if (this.hostNameMismatch) {
            info.append("\n    - ").append(lex.getText("exempt.prompt.dialog.msg.mismatch"));
        }
        if (this.unknownIdentity) {
            info.append("\n    - ").append(lex.getText("exempt.prompt.dialog.msg.identity"));
        }
        if (this.certExpired) {
            info.append("\n    - ").append(lex.getText("exempt.prompt.dialog.msg.expired"));
        }
        BLabel label = new BLabel(info.toString(), BHalign.left);
        StyleUtils.addStyleClass((IStylable)label, (String)"strong");
        return new BBorderPane((BWidget)label, 10.0, 10.0, 5.0, 10.0);
    }

    @Override
    protected BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(lex.getText("exempt.prompt.dialog.accept"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        this.cancelButton = new BButton(lex.getText("exempt.prompt.dialog.reject"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.cancelButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    @Override
    public void doOkButtonPressed(BWidgetEvent event) {
        this.closeResult = true;
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.closeResult = false;
        this.close();
    }

    public boolean getResult() {
        return this.closeResult;
    }
}

