/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.CertValidationResult;
import com.tridium.crypto.core.cert.NHostExemption;
import com.tridium.platcrypto.ui.BCertViewDialog;
import com.tridium.platcrypto.ui.BX509CertificateChangedPane;
import com.tridium.platcrypto.ui.BX509ExtensionChangedPane;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509Certificate;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.wizard.BWizardHeader;

@NiagaraType
@NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BExemptionChangedDialog
extends BCertViewDialog {
    @Generated
    public static final Action cancelButtonPressed = BExemptionChangedDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BExemptionChangedDialog.class);
    protected static BImage logo = BImage.make((String)lex.get("cert.warning.x32.icon", "module://icons/x32/warning.png"));
    protected boolean hostNameMismatch = false;
    protected boolean unknownIdentity = false;
    protected IX509Certificate oldCert;
    protected BButton cancelButton;
    protected boolean closeResult = false;

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static boolean show(BWidget owner, CertValidationResult result) throws Exception {
        BExemptionChangedDialog dialog = new BExemptionChangedDialog(owner, result);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    public static boolean show(BWidget owner, NHostExemption exemption) throws Exception {
        BExemptionChangedDialog dialog = new BExemptionChangedDialog(owner, exemption);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BExemptionChangedDialog(BWidget parent, CertValidationResult result) throws Exception {
        super(parent, lex.getText("exempt.changed.dialog.title"));
        this.oldCert = result.getOrigCert();
        this.cert = result.getNewCert();
        this.hostNameMismatch = !result.isHostnameVerified();
        this.unknownIdentity = !result.isValidCertChain();
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    private BExemptionChangedDialog(BWidget parent, NHostExemption exemption) throws Exception {
        super(parent, lex.getText("exempt.changed.dialog.title"));
        this.oldCert = exemption.getCertificate();
        this.cert = exemption.getChanged();
        this.hostNameMismatch = false;
        this.unknownIdentity = false;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    @Override
    protected BWidget buildHeader() {
        return new BWizardHeader(logo, this.oldCert.getSubject() + " / " + this.cert.getSubject(), lex.getText("exempt.changed.dialog.info", new Object[]{this.cert.getSubject()}));
    }

    @Override
    protected BWidget buildContent() throws Exception {
        BEdgePane edgePane = new BEdgePane();
        edgePane.setCenter(super.buildContent());
        return edgePane;
    }

    @Override
    protected BWidget buildProperties() {
        BX509CertificateChangedPane certPane = new BX509CertificateChangedPane(this.oldCert, this.cert);
        return certPane;
    }

    @Override
    protected BWidget buildExtensions() throws Exception {
        BX509ExtensionChangedPane extensionPane = new BX509ExtensionChangedPane(this.oldCert.getExtensions(), this.cert.getExtensions());
        return extensionPane;
    }

    @Override
    protected BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(lex.getText("exempt.prompt.dialog.accept"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        this.cancelButton = new BButton(lex.getText("exempt.prompt.dialog.reject"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.cancelButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    @Override
    public void doOkButtonPressed(BWidgetEvent event) {
        this.closeResult = true;
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.closeResult = false;
        this.close();
    }

    public boolean getResult() {
        return this.closeResult;
    }
}

