/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.util.FriendlyPemReader;
import com.tridium.json.JSONObject;
import com.tridium.platcrypto.ui.BCertificateExtension;
import com.tridium.platcrypto.ui.BCertificateFormatHelper;
import com.tridium.platcrypto.ui.BCertificateSigningRequest;
import com.tridium.platcrypto.ui.BCertificateSigningRequestManager;
import com.tridium.platcrypto.ui.BCertsTable;
import com.tridium.platcrypto.ui.BPasswordField;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.workbench.web.browser.BWebBrowser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.file.BAbstractFile;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.license.Feature;
import javax.baja.license.FeatureLicenseExpiredException;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509Extension;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.platCrypto.certs.BPEMCertificateHandler;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.text.TextController;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;

@NiagaraType(agent={@AgentOn(types={"platCrypto:CertificateSignerMultipleSelectionTool"})})
@NiagaraActions(value={@NiagaraAction(name="updateCertificateNames", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="saveAsTypeValueModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="saveAsExtValueModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public final class BCertificateSignerMultipleSelection
extends BWbView {
    @Generated
    public static final Action updateCertificateNames = BCertificateSignerMultipleSelection.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action saveAsTypeValueModified = BCertificateSignerMultipleSelection.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action saveAsExtValueModified = BCertificateSignerMultipleSelection.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateSignerMultipleSelection.class);
    private static final BImage FOLDER_ICON = BImage.make((String)"module://icons/x16/folder.png");
    private static final BImage QUESTION_MARK_ICON = BImage.make((String)"module://icons/x16/questionMark.png");
    private static final Lexicon LEXICON = Lexicon.make((String)"platCrypto");
    private static final Logger LOG = Logger.getLogger("platCrypto");
    private boolean featureHasNotBeenLicensed;
    private boolean featureLicenseHasExpired;
    private IKeyStore keyStore;
    private final BComponent emptyRequestList = new BComponent();
    private BTextDropDown ca;
    private BPasswordField caPassword;
    private BTextField certificateNameFormat;
    private BTextDropDown saveAsType;
    private BTextDropDown saveAsExt;
    private BGridPane messageGridPane;
    private BEdgePane mainEdgePane;
    private BPane chooserPane;
    private BPane headingPane;
    private static final String FILENAME_FORMAT_HELP_CONT = "A format string is used to create the certificate filename(s) generated for certificate signing requests. The format string is specified as normal text with embedded scripts denoted by % character pairs. An appropriate filename extension (e.g. *.pem) will be appended when the files are saved.<p>Valid scripts for filename formatting:<ul><li><b>%csrFile%</b>, filename of the original csr selected.</li><li><b>%subject%</b>, subject attribute of the csr.</li><li><b>%altSubject%</b>, the first subject alternative name of the csr.</li></ul><p>The default filename format is %csrFile%. Examples of other options are:<ul><li><b>%csrFile%_%subject%</b></li><li><b>%csrFile%_%altSubject%</b></li><li><b>%csrFile%.pem</b></li></ul><p>Additional information can be found in the class documentation for BFormat.";
    private Map<String, BICertificateFormatHandler> certificateFormatHandlerMap;
    private BCertificateSigningRequestManager certificateSigningRequestManager;
    private static final BCertificateFormatHelper formatComponent = new BCertificateFormatHelper();
    private final Set<Warning> warnings = EnumSet.noneOf(Warning.class);

    @Generated
    public void updateCertificateNames(BWidgetEvent parameter) {
        this.invoke(updateCertificateNames, (BValue)parameter, null);
    }

    @Generated
    public void saveAsTypeValueModified(BWidgetEvent parameter) {
        this.invoke(saveAsTypeValueModified, (BValue)parameter, null);
    }

    @Generated
    public void saveAsExtValueModified(BWidgetEvent parameter) {
        this.invoke(saveAsExtValueModified, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCertificateSignerMultipleSelection() throws Exception {
        this(null, null);
    }

    public BCertificateSignerMultipleSelection(IKeyStore keyStore, Map<String, BICertificateFormatHandler> certificateFormatHandlerMap) throws Exception {
        try {
            Feature feature = Sys.getLicenseManager().getFeature("tridium", "bulkCertSigner");
            feature.check();
            this.keyStore = keyStore;
            if (certificateFormatHandlerMap != null) {
                this.certificateFormatHandlerMap = Collections.unmodifiableMap(certificateFormatHandlerMap);
            }
            this.assignPropertyValues();
            this.mainEdgePane = new BEdgePane();
            this.chooserPane = this.makeChooserPane();
            this.headingPane = this.makeHeadingPane();
            this.mainEdgePane.setTop((BWidget)this.chooserPane);
            this.certificateSigningRequestManager = new BCertificateSigningRequestManager(this);
            this.mainEdgePane.setCenter((BWidget)this.certificateSigningRequestManager);
            this.setContent((BWidget)this.mainEdgePane);
        }
        catch (FeatureLicenseExpiredException flee) {
            this.featureLicenseHasExpired = true;
        }
        catch (FeatureNotLicensedException fnle) {
            this.featureHasNotBeenLicensed = true;
        }
    }

    public void started() throws Exception {
        if (this.featureHasNotBeenLicensed) {
            BDialog.warning((BWidget)this, (String)LEXICON.getText("bulk.cert.signer.tool.not.licensed.title"), (Object)LEXICON.getText("bulk.cert.signer.tool.not.licensed"));
        } else if (this.featureLicenseHasExpired) {
            BDialog.warning((BWidget)this, (String)LEXICON.getText("bulk.cert.signer.tool.license.expired.title"), (Object)LEXICON.getText("bulk.cert.signer.tool.license.expired"));
        } else {
            this.selectCertificateSigningRequestOrds((BWidget)this);
        }
    }

    private void assignPropertyValues() throws Exception {
        if (this.keyStore == null) {
            this.keyStore = CertManagerFactory.getInstance().getKeyStore();
        }
        if (this.certificateFormatHandlerMap == null) {
            this.certificateFormatHandlerMap = new HashMap<String, BICertificateFormatHandler>();
            Set certFormatHandlers = BICertificateFormatHandler.getCertificateFormatHandlers();
            for (BICertificateFormatHandler certFormatHandler : certFormatHandlers) {
                this.certificateFormatHandlerMap.put(certFormatHandler.getCertificateFormatName(null), certFormatHandler);
            }
        }
    }

    private void selectCertificateSigningRequestOrds(BWidget owner) throws Exception {
        BFileChooser chooser = BFileChooser.makeOpen((BWidget)owner);
        chooser.addFilter((IFileFilter)new ExtFileFilter(LEXICON.getText("csr.extension.info"), "csr"));
        chooser.setTitle(LEXICON.getText("cert.signer.csr.select"));
        chooser.setCurrentDirectory(BOrd.make((String)("file:/" + BCertsTable.getCertsDirectoryPath())));
        BOrd[] certificateSigningRequestOrds = chooser.show(true);
        if (certificateSigningRequestOrds.length > 0) {
            BComponent requestList = BCertificateSignerMultipleSelection.makeRequestList(certificateSigningRequestOrds);
            this.certificateSigningRequestManager.loadValue((BObject)requestList);
            this.mainEdgePane.setTop((BWidget)this.headingPane);
            this.refreshCertificateNames();
            this.refreshSaveAsExtensions();
        } else {
            this.certificateSigningRequestManager.loadValue((BObject)this.emptyRequestList);
            this.mainEdgePane.setTop((BWidget)this.chooserPane);
        }
    }

    private static BComponent makeRequestList(BOrd[] certificateSigningRequestOrds) throws Exception {
        BComponent requestList = new BComponent();
        for (BOrd ord : certificateSigningRequestOrds) {
            BAbstractFile csrFile = (BAbstractFile)ord.get();
            if (csrFile == null) continue;
            try (InputStreamReader inputStreamReader = new InputStreamReader(csrFile.getInputStream());
                 FriendlyPemReader friendlyPemReader = new FriendlyPemReader((Reader)inputStreamReader);
                 PEMParser pemParser = new PEMParser((Reader)friendlyPemReader);){
                Object obj = pemParser.readObject();
                if (obj == null || !(obj instanceof PKCS10CertificationRequest)) continue;
                PKCS10CertificationRequest tcsr = (PKCS10CertificationRequest)obj;
                JcaPKCS10CertificationRequest jcaCsr = new JcaPKCS10CertificationRequest(tcsr.getEncoded());
                NPKCS10CertificationRequest certificationRequest = NPKCS10CertificationRequest.make((JcaPKCS10CertificationRequest)jcaCsr);
                BCertificateSigningRequest certificateSigningRequest = new BCertificateSigningRequest(csrFile, certificationRequest);
                requestList.add(null, (BValue)certificateSigningRequest);
            }
        }
        return requestList;
    }

    private BPane makeHeadingPane() throws Exception {
        BGridPane certificateAuthorityPane = new BGridPane(4);
        certificateAuthorityPane.setColumnGap(8.0);
        certificateAuthorityPane.add(null, (BValue)new BLabel(LEXICON.getText("bulk.cert.signer.tool.ca.alias.label")));
        this.ca = new BTextDropDown(this.getCaAliases(), 30, false);
        certificateAuthorityPane.add(null, (BValue)this.ca);
        certificateAuthorityPane.add(null, (BValue)new BLabel(LEXICON.getText("bulk.cert.signer.tool.ca.password.label")));
        this.caPassword = new BPasswordField("", 20);
        certificateAuthorityPane.add(null, (BValue)this.caPassword);
        BGridPane saveAsPane = new BGridPane(7);
        saveAsPane.setColumnGap(8.0);
        BButton filenameFormatHelpButton = new BButton((Command)new FilenameFormatHelpCommand((BWidget)this));
        filenameFormatHelpButton.setButtonStyle(BButtonStyle.toolBar);
        saveAsPane.add(null, (BValue)new BLabel(LEXICON.getText("bulk.cert.signer.tool.save.as.type.label")));
        this.saveAsType = new BTextDropDown(new ArrayList<String>(this.certificateFormatHandlerMap.keySet()), 8, false);
        saveAsPane.add(null, (BValue)this.saveAsType);
        saveAsPane.add(null, (BValue)new BLabel(LEXICON.getText("bulk.cert.signer.tool.save.as.ext.label")));
        this.saveAsExt = new BTextDropDown(BCertificateSignerMultipleSelection.buildSaveAsExtEditor(), new BList());
        saveAsPane.add(null, (BValue)this.saveAsExt);
        saveAsPane.add(null, (BValue)new BLabel(LEXICON.getText("bulk.cert.signer.tool.file.format.label")));
        this.certificateNameFormat = new BTextField("", 30);
        saveAsPane.add(null, (BValue)this.certificateNameFormat);
        saveAsPane.add(null, (BValue)filenameFormatHelpButton);
        this.saveAsType.setText(BPEMCertificateHandler.INSTANCE.getCertificateFormatName(null));
        this.saveAsExt.setText(BPEMCertificateHandler.INSTANCE.getDefaultFileExtension());
        this.certificateNameFormat.setText(LEXICON.getText("bulk.cert.signer.tool.file.format.default"));
        this.linkTo((BComponent)this.saveAsType, (Slot)BDropDown.valueModified, (Slot)saveAsTypeValueModified);
        this.linkTo((BComponent)this.saveAsExt, (Slot)BDropDown.valueModified, (Slot)saveAsExtValueModified);
        this.linkTo((BComponent)this.certificateNameFormat, (Slot)BWidget.focusEvent, (Slot)updateCertificateNames);
        this.linkTo((BComponent)this.certificateNameFormat, (Slot)BWidget.keyEvent, (Slot)updateCertificateNames);
        this.messageGridPane = new BGridPane(1);
        for (Warning warning : Warning.values()) {
            BLabel message = new BLabel(warning.message);
            message.setForeground(warning.brush);
            message.setImage(warning.image);
            this.messageGridPane.add(warning.name, (BValue)message);
            message.setVisible(false);
        }
        BBorderPane messagePane = new BBorderPane((BWidget)this.messageGridPane, 4.0, 0.0, 0.0, 0.0);
        BGridPane headingGridPane = new BGridPane(1);
        headingGridPane.add(null, (BValue)new BBorderPane((BWidget)certificateAuthorityPane, 0.0, 0.0, 4.0, 0.0));
        headingGridPane.add(null, (BValue)new BBorderPane((BWidget)saveAsPane, 4.0, 0.0, 0.0, 0.0));
        headingGridPane.add(null, (BValue)messagePane);
        BEdgePane edgePane = new BEdgePane();
        edgePane.setLeft((BWidget)new BBorderPane((BWidget)headingGridPane, 16.0, 0.0, 4.0, 0.0));
        return new BBorderPane((BWidget)edgePane, 0.0, 0.0, 8.0, 0.0);
    }

    private BPane makeChooserPane() throws Exception {
        BGridPane chooserGridPane = new BGridPane(2);
        BButton selectButton = new BButton((Command)new SelectCertificateSigningRequestsCommand((BWidget)this));
        selectButton.setButtonStyle(BButtonStyle.toolBar);
        chooserGridPane.add(null, (BValue)new BLabel(LEXICON.getText("bulk.cert.signer.tool.select.csrs.label")));
        chooserGridPane.add(null, (BValue)selectButton);
        BEdgePane edgePane = new BEdgePane();
        edgePane.setLeft((BWidget)new BBorderPane((BWidget)chooserGridPane, 16.0, 0.0, 16.0, 0.0));
        return new BBorderPane((BWidget)edgePane, 0.0, 0.0, 8.0, 0.0);
    }

    public void doUpdateCertificateNames(BWidgetEvent event) throws Exception {
        switch (event.getId()) {
            case 1005: {
                this.refreshCertificateNames();
                break;
            }
            case 402: {
                if (((BKeyEvent)event).getKeyCode() != 10) break;
                this.refreshCertificateNames();
                break;
            }
        }
    }

    public void doSaveAsTypeValueModified(BWidgetEvent event) throws Exception {
        if (event.getId() == 1) {
            this.refreshSaveAsExtensions();
        }
    }

    public void doSaveAsExtValueModified(BWidgetEvent event) throws Exception {
        BCertificateSigningRequest[] certificateSigningRequests;
        if (this.certificateSigningRequestManager == null || this.certificateSigningRequestManager.getModel() == null || this.certificateSigningRequestManager.getModel().getTarget() == null) {
            return;
        }
        for (BCertificateSigningRequest certificateSigningRequest : certificateSigningRequests = (BCertificateSigningRequest[])this.certificateSigningRequestManager.getModel().getTarget().getChildren(BCertificateSigningRequest.class)) {
            StringBuilder newFileName = new StringBuilder(certificateSigningRequest.getFilename());
            int extIndex = newFileName.lastIndexOf(".");
            if (extIndex > 0) {
                newFileName.delete(extIndex, newFileName.length());
            }
            if (!this.saveAsExt.getText().isEmpty()) {
                newFileName.append('.').append(this.saveAsExt.getText());
            }
            certificateSigningRequest.setFilename(newFileName.toString());
        }
        this.setDuplicateFilenames(certificateSigningRequests);
        this.certificateSigningRequestManager.getModel().getTable().reload();
    }

    private List<String> getCaAliases() throws Exception {
        return Collections.list(this.keyStore.aliases()).stream().filter(alias -> this.isAliasKeyEntryAndCACertificate((String)alias)).collect(Collectors.toList());
    }

    private boolean isAliasKeyEntryAndCACertificate(String alias) {
        try {
            return this.keyStore.isKeyEntry(alias) && CertUtils.isCACertificate((X509Certificate)this.keyStore.getCertificate(alias));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Exception occurred while validating alias", e);
            return false;
        }
    }

    private static BTextField buildSaveAsExtEditor() {
        BTextField textField = new BTextField();
        textField.setVisibleColumns(8);
        textField.setEditable(true);
        textField.setController((TextController)new ExtTextController());
        return textField;
    }

    private void refreshCertificateNames() throws Exception {
        BCertificateSigningRequest[] certificateSigningRequests;
        if (this.certificateSigningRequestManager == null || this.certificateSigningRequestManager.getModel() == null || this.certificateSigningRequestManager.getModel().getTarget() == null) {
            return;
        }
        String formatText = this.certificateNameFormat.getText();
        if (formatText.chars().filter(ch -> ch == 37).count() % 2L != 0L) {
            return;
        }
        for (BCertificateSigningRequest certificateSigningRequest : certificateSigningRequests = (BCertificateSigningRequest[])this.certificateSigningRequestManager.getModel().getTarget().getChildren(BCertificateSigningRequest.class)) {
            formatComponent.setSubject(certificateSigningRequest.getSubject());
            formatComponent.setCsrFile(certificateSigningRequest.getCertificationRequestFileName());
            formatComponent.setAltSubject(BCertificateSignerMultipleSelection.getAltSubject(certificateSigningRequest));
            StringBuilder result = new StringBuilder(BFormat.format((String)formatText, (Object)((Object)formatComponent)));
            if (result.indexOf("%") >= 0 || result.indexOf("ERROR") >= 0 || result.indexOf("%err:") >= 0) continue;
            if (!this.saveAsExt.getText().isEmpty()) {
                result.append('.').append(this.saveAsExt.getText());
            }
            certificateSigningRequest.setFilename(result.toString());
        }
        this.setDuplicateFilenames(certificateSigningRequests);
        this.certificateSigningRequestManager.getModel().getTable().reload();
    }

    void setDuplicateFilenames(BCertificateSigningRequest[] certificateSigningRequests) {
        HashSet uniqueFilenames = new HashSet();
        Set duplicateFileNames = Arrays.stream(certificateSigningRequests).filter(certificateSigningRequest -> !uniqueFilenames.add(certificateSigningRequest.getFilename())).map(BCertificateSigningRequest::getFilename).collect(Collectors.toSet());
        BCertificateSigningRequest[] bCertificateSigningRequestArray = certificateSigningRequests;
        int n = bCertificateSigningRequestArray.length;
        for (int i = 0; i < n; ++i) {
            BCertificateSigningRequest certificateSigningRequest2;
            boolean duplicateFilename = duplicateFileNames.contains((certificateSigningRequest2 = bCertificateSigningRequestArray[i]).getFilename());
            certificateSigningRequest2.setStatus(duplicateFilename ? Warning.DUPLICATE_FILENAME.status : BStatus.ok);
        }
        this.setWarning(Warning.DUPLICATE_FILENAME, !duplicateFileNames.isEmpty());
        ((BWidget)this.messageGridPane.get(Warning.DUPLICATE_FILENAME.name)).setVisible(!duplicateFileNames.isEmpty());
    }

    private void refreshSaveAsExtensions() {
        BList list = this.saveAsExt.getList();
        list.getModel().removeAllItems();
        BICertificateFormatHandler certificateFormatHandler = this.certificateFormatHandlerMap.get(this.saveAsType.getText());
        for (String item : certificateFormatHandler.getSupportedFileExtensions()) {
            list.addItem((Object)item);
        }
        this.saveAsExt.setText(certificateFormatHandler.getDefaultFileExtension());
    }

    private static String getAltSubject(BCertificateSigningRequest certificateSigningRequest) throws Exception {
        String altSubject = "";
        for (BCertificateExtension certificateExtension : (BCertificateExtension[])certificateSigningRequest.getExtensions().getChildren(BCertificateExtension.class)) {
            IX509Extension nx509Extension = certificateExtension.getNx509Extension();
            if (!"2.5.29.17".equals(nx509Extension.getOid().getId())) continue;
            altSubject = new JSONObject(nx509Extension.getJSON()).toString(2);
        }
        return altSubject;
    }

    private static String filenameFormatHelpHtml(String description) {
        return String.format("<html><head><link rel='stylesheet' href='module://bajaui/doc/style.css' type='text/css'/></head><body>%s</body></html>", description);
    }

    IKeyStore getKeyStore() {
        return this.keyStore;
    }

    Map<String, BICertificateFormatHandler> getCertificateFormatHandlerMap() {
        return Collections.unmodifiableMap(this.certificateFormatHandlerMap);
    }

    String getSaveAsTypeText() {
        return this.saveAsType.getText();
    }

    String getCaText() {
        return this.ca.getText();
    }

    String getCaPasswordText() {
        return this.caPassword.getText();
    }

    boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    boolean setWarning(Warning warning, boolean isActive) {
        return isActive ? this.warnings.add(warning) : this.warnings.remove((Object)warning);
    }

    private static class ExtTextController
    extends TextController {
        private static final String INVALID_CHARACTERS = "\\/:*?'\"<>|";

        private ExtTextController() {
        }

        public void keyTyped(BKeyEvent event) {
            char key = event.getKeyChar();
            if (INVALID_CHARACTERS.indexOf(key) >= 0) {
                return;
            }
            super.keyTyped(event);
        }
    }

    private static enum Warning {
        DUPLICATE_FILENAME("duplicateFilename", BCertificateSignerMultipleSelection.access$400().getText("bulk.cert.signer.tool.heading.message.duplicate.filenames"), BStatus.down, BImage.make((BOrd)BOrd.make((String)"module://icons/x16/warning.png")), BBrush.makeSolid((BColor)BColor.goldenrod));

        public final String name;
        public final String message;
        public final BStatus status;
        public final BImage image;
        public final BBrush brush;

        private Warning(String name, String message, BStatus status, BImage image, BBrush brush) {
            this.name = name;
            this.message = message;
            this.status = status;
            this.image = image;
            this.brush = brush;
        }
    }

    private class FilenameFormatHelpCommand
    extends Command {
        public FilenameFormatHelpCommand(BWidget owner) {
            super(owner, null);
        }

        public BImage getIcon() {
            return QUESTION_MARK_ICON;
        }

        public CommandArtifact doInvoke() {
            try {
                BWebBrowser browser = new BWebBrowser();
                browser.load((BObject)BString.make((String)BCertificateSignerMultipleSelection.filenameFormatHelpHtml(BCertificateSignerMultipleSelection.FILENAME_FORMAT_HELP_CONT)), BCertificateSignerMultipleSelection.this.getCurrentContext());
                BConstrainedPane dialogContent = new BConstrainedPane((BWidget)browser);
                dialogContent.setMinSize(500.0, 400.0);
                dialogContent.setMaxSize(500.0, 400.0);
                BDialog.open((BWidget)this.getOwner(), (String)LEXICON.getText("bulk.cert.signer.tool.file.format.help.title"), (Object)dialogContent, (int)1);
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    private class SelectCertificateSigningRequestsCommand
    extends Command {
        public SelectCertificateSigningRequestsCommand(BWidget owner) {
            super(owner, null);
        }

        public BImage getIcon() {
            return FOLDER_ICON;
        }

        public CommandArtifact doInvoke() {
            try {
                BCertificateSignerMultipleSelection.this.selectCertificateSigningRequestOrds(this.getOwner());
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }
}

