/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NSigningParameters;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.util.FriendlyPemReader;
import com.tridium.platcrypto.ui.BCertsTable;
import com.tridium.platcrypto.ui.BCryptoDialog;
import com.tridium.platcrypto.ui.BPasswordField;
import com.tridium.platcrypto.ui.BX509ExtensionPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.fieldeditors.BAbsTimeFE;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509Certificate;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.nre.security.IX509Extension;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.platCrypto.certs.BPEMCertificateHandler;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;

@NiagaraType
@NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BCertificateSignerDialog
extends BCryptoDialog {
    @Generated
    public static final Action cancelButtonPressed = BCertificateSignerDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateSignerDialog.class);
    static Lexicon lex = Lexicon.make((String)"platCrypto");
    static final BImage logo = BImage.make((String)lex.get("cert.green.x32.icon", "module://icons/x32/lock.png"));
    private static final BImage open = BImage.make((BIcon)BIcon.std((String)"open.png"));
    private static final Logger log = Logger.getLogger("platCrypto");
    ICryptoManager mgr;
    IKeyStore store;
    private BTextField csrFileText;
    BButton openBtn;
    private BLabel subject = new BLabel("");
    private BLabel subjectDN = new BLabel("");
    private BLabel keyAlg = new BLabel("");
    private BLabel keySize = new BLabel("");
    private BLabel sigAlg = new BLabel("");
    private BLabel sigSize = new BLabel("");
    private BLabel verified = new BLabel("");
    BGridPane csrPane;
    BEdgePane csrPropPane;
    BEdgePane extensionsPane;
    private BAbsTimeFE notBeforeFE;
    private BAbsTimeFE notAfterFE;
    private BX509ExtensionPane extensionPane;
    private BTextDropDown ca;
    private BPasswordField caPassword;
    private BTextDropDown saveAsType;
    private Map<String, BICertificateFormatHandler> certFormatHandlerMap;
    NPKCS10CertificationRequest csr;
    String baseFileName = null;
    private BAbsTime notBefore = BAbsTime.now();
    private BAbsTime notAfter = BAbsTime.make((long)(Clock.millis() + 63072000000L));
    private BButton okButton;
    protected BButton cancelButton;
    private boolean wizardMode = false;
    private NX509Certificate[] certChain = null;

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static void show(BWidget parent) throws Exception {
        BCertificateSignerDialog dialog = new BCertificateSignerDialog(parent);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
    }

    public BCertificateSignerDialog() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public BCertificateSignerDialog(BWidget parent) throws Exception {
        this(parent, lex.getText("cert.signer.dialog.title"));
    }

    public BCertificateSignerDialog(BWidget parent, String title) throws Exception {
        super(parent, title);
        this.mgr = CertManagerFactory.getInstance();
        this.store = this.mgr.getKeyStore();
        this.certFormatHandlerMap = new HashMap<String, BICertificateFormatHandler>();
        Set certFormatHandlers = BICertificateFormatHandler.getCertificateFormatHandlers();
        for (BICertificateFormatHandler certFormatHandler : certFormatHandlers) {
            this.certFormatHandlerMap.put(certFormatHandler.getCertificateFormatName(null), certFormatHandler);
        }
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    @Override
    protected BWidget buildHeader() {
        return new BWizardHeader(logo, lex.getText("cert.signer.dialog.title"), lex.getText("cert.signer.dialog.info"));
    }

    @Override
    protected BWidget buildBody() {
        BGridPane body = new BGridPane(1);
        body.setStretchColumn(0);
        body.setColumnAlign(BHalign.fill);
        BEdgePane csrSelectPane = new BEdgePane();
        csrSelectPane.setTop((BWidget)new BLabel(lex.getText("cert.signer.dialog.selectcsr") + ":", BHalign.left));
        BGridPane csrSelect = new BGridPane(2);
        this.csrFileText = new BTextField("", 60, false);
        csrSelect.add(null, (BValue)this.csrFileText);
        this.openBtn = new BButton((Command)new OpenCsrCommand());
        this.openBtn.setButtonStyle(BButtonStyle.toolBar);
        csrSelect.add(null, (BValue)this.openBtn);
        csrSelectPane.setCenter((BWidget)csrSelect);
        body.add(null, (BValue)csrSelectPane);
        this.csrPane = new BGridPane(1);
        this.csrPane.setVisible(false);
        this.csrPane.setStretchColumn(0);
        this.csrPane.setColumnAlign(BHalign.fill);
        this.csrPane.setRowGap(7.0);
        this.csrPropPane = new BEdgePane();
        BEdgePane csrLabel = new BEdgePane();
        csrLabel.setLeft((BWidget)new BLabel(lex.getText("cert.dialog.properties") + ":"));
        this.csrPropPane.setTop((BWidget)csrLabel);
        BGridPane csrGrid = new BGridPane(2);
        csrGrid.setStretchColumn(1);
        csrGrid.setColorRows(true);
        StyleUtils.addStyleClass((IStylable)csrGrid, (String)"scrolled");
        csrGrid.setColumnAlign(BHalign.left);
        BCertificateSignerDialog.addPaddedLabelRow(csrGrid, "cert.field.subject", this.subject);
        BCertificateSignerDialog.addPaddedLabelRow(csrGrid, "cert.field.subjectDn", this.subjectDN);
        BCertificateSignerDialog.addPaddedLabelRow(csrGrid, "cert.field.keyAlgorithm", this.keyAlg);
        BCertificateSignerDialog.addPaddedLabelRow(csrGrid, "cert.field.keySize", this.keySize);
        BCertificateSignerDialog.addPaddedLabelRow(csrGrid, "cert.field.signatureAlgorithm", this.sigAlg);
        BCertificateSignerDialog.addPaddedLabelRow(csrGrid, "cert.field.signatureSize", this.sigSize);
        BCertificateSignerDialog.addPaddedLabelRow(csrGrid, "cert.field.verify", this.verified);
        BScrollPane scroll = new BScrollPane((BWidget)csrGrid);
        BConstrainedPane csrPanel = new BConstrainedPane((BWidget)scroll, 500.0, 150.0);
        this.csrPropPane.setCenter((BWidget)csrPanel);
        this.csrPane.add(null, (BValue)this.csrPropPane);
        this.extensionsPane = new BEdgePane();
        this.extensionsPane.setVisible(false);
        BEdgePane extensionsLabel = new BEdgePane();
        extensionsLabel.setLeft((BWidget)new BLabel(lex.getText("cert.dialog.extensions") + ":"));
        this.extensionsPane.setTop((BWidget)extensionsLabel);
        this.extensionPane = new BX509ExtensionPane();
        scroll = new BScrollPane((BWidget)this.extensionPane);
        BConstrainedPane extensionsPanel = new BConstrainedPane((BWidget)scroll, 500.0, 150.0);
        this.extensionsPane.setCenter((BWidget)extensionsPanel);
        this.csrPane.add(null, (BValue)this.extensionsPane);
        body.add(null, (BValue)this.csrPane);
        BEdgePane rowPane = new BEdgePane();
        BGridPane tuple = new BGridPane(2);
        tuple.setRowGap(7.0);
        this.notBeforeFE = new BAbsTimeFE(this.notBefore);
        BCertificateSignerDialog.addLabelRow(tuple, "cert.field.notBefore", (BValue)this.notBeforeFE);
        this.notAfterFE = new BAbsTimeFE(this.notAfter);
        BCertificateSignerDialog.addLabelRow(tuple, "cert.field.notAfter", (BValue)this.notAfterFE);
        this.ca = new BTextDropDown(this.getCaAliases(), 30, false);
        BCertificateSignerDialog.addLabelRow(tuple, "cert.signer.dialog.caalias", (BValue)this.ca);
        this.caPassword = new BPasswordField("", 20);
        BCertificateSignerDialog.addLabelRow(tuple, "cert.signer.dialog.capassword", (BValue)this.caPassword);
        this.saveAsType = new BTextDropDown(new ArrayList<String>(this.certFormatHandlerMap.keySet()), 8, false);
        BCertificateSignerDialog.addLabelRow(tuple, "cert.signer.dialog.saveAs", (BValue)this.saveAsType);
        this.saveAsType.setText(BPEMCertificateHandler.INSTANCE.getCertificateFormatName(null));
        rowPane.setLeft((BWidget)tuple);
        body.add(null, (BValue)rowPane);
        body.setRowGap(7.0);
        return body;
    }

    private static void addLabelRow(BGridPane pane, String lexKey, BValue value) {
        BCertificateSignerDialog.addRow(pane, (BWidget)new BLabel(lex.getText(lexKey) + ":"), value);
    }

    private static void addPaddedLabelRow(BGridPane pane, String lexKey, BLabel label) {
        BCertificateSignerDialog.addRow(pane, BCertificateSignerDialog.createPaddedLabel(lex.getText(lexKey)), (BValue)BCertificateSignerDialog.createPaddedLabel(label));
    }

    private static void addRow(BGridPane pane, BWidget label, BValue value) {
        pane.add(null, (BValue)label);
        pane.add(null, value);
    }

    @Override
    protected BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.cancelButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    private List<String> getCaAliases() {
        ArrayList<String> caList = new ArrayList<String>();
        try {
            Enumeration aliases = this.store.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate cert;
                String alias = (String)aliases.nextElement();
                if (!this.store.isKeyEntry(alias) || !CertUtils.isCACertificate((X509Certificate)(cert = this.store.getCertificate(alias)))) continue;
                caList.add(alias);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception occurred while obtaining CA aliases", e);
        }
        return caList;
    }

    public void initializeForCertificateWizard(NPKCS10CertificationRequest csr, String caCertAlias, String password, String serverCertAlias) throws Exception {
        this.wizardMode = true;
        this.csr = csr;
        this.openBtn.setEnabled(false);
        this.ca.setEnabled(false);
        this.ca.setText(caCertAlias);
        this.caPassword.setEnabled(false);
        this.caPassword.setText(password);
        this.csrFileText.setText(serverCertAlias);
        this.baseFileName = BajaFileUtil.getBase((String)serverCertAlias);
        this.subject.setText(csr.getSubject());
        this.subjectDN.setText(csr.getSubjectDN().toString());
        this.keyAlg.setText(csr.getKeyAlgorithm());
        this.keySize.setText(csr.getKeySize() + "");
        this.sigAlg.setText(csr.getSignatureAlgorithm());
        this.sigSize.setText(csr.getSignatureSize() + "");
        this.verified.setText(csr.verify() + "");
        this.csrPane.setVisible(true);
        this.extensionPane.setExtensions(csr.getExtensions(), true);
        if (this.extensionPane.getExtensionCount() > 0) {
            this.extensionsPane.setVisible(true);
        } else {
            this.extensionsPane.setVisible(false);
        }
        this.setBoundsCenteredOnOwner();
    }

    public NX509Certificate[] getCertChain() {
        return this.certChain;
    }

    @Override
    public void doOkButtonPressed(BWidgetEvent event) {
        try {
            String caAlias = this.ca.getText();
            String password = this.caPassword.getText();
            X509Certificate caCert = this.store.getCertificate(caAlias);
            PrivateKey privateKey = (PrivateKey)this.store.getKey(caAlias, password.toCharArray());
            NX509CertificateEntry ca = NX509CertificateEntry.make(null, (X509Certificate[])new X509Certificate[]{caCert}, (PrivateKey)privateKey);
            Date notBefore = new Date(((BAbsTime)this.notBeforeFE.saveValue()).getMillis());
            Date notAfter = new Date(((BAbsTime)this.notAfterFE.saveValue()).getMillis());
            NSigningParameters params = NSigningParameters.make((Date)notBefore, (Date)notAfter);
            for (int i = 0; i < this.extensionPane.getExtensionCount(); ++i) {
                if (!this.extensionPane.isSelected(i)) continue;
                IX509Extension ext = this.extensionPane.getExtension(i);
                params.addExtension(ext);
            }
            NX509Certificate cert = CertUtils.signCertificate((NPKCS10CertificationRequest)this.csr, (IX509CertificateEntry)ca, (NSigningParameters)params);
            X509Certificate[] caChain = this.store.getCertificateChain(caAlias);
            this.certChain = new NX509Certificate[caChain.length + 1];
            this.certChain[0] = cert;
            for (int i = 0; i < caChain.length; ++i) {
                this.certChain[i + 1] = NX509Certificate.make((X509Certificate)caChain[i]);
            }
            if (this.wizardMode) {
                this.close();
                return;
            }
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            BICertificateFormatHandler selectedHandler = this.certFormatHandlerMap.get(this.saveAsType.getText());
            chooser.addFilter((IFileFilter)new ExtFileFilter(selectedHandler.getCertificateFormatFileTypeName(null), String.join((CharSequence)",", selectedHandler.getSupportedFileExtensions())));
            chooser.setTitle(lex.getText("cert.signer.save.title"));
            chooser.setDefaultFileName(this.baseFileName + "." + selectedHandler.getDefaultFileExtension());
            chooser.setCurrentDirectory(BOrd.make((String)("file:/" + BCertsTable.getCertsDirectoryPath())));
            BOrd ord = chooser.show();
            if (ord == null) {
                return;
            }
            BAbstractFile pemFile = (BAbstractFile)ord.get();
            if (pemFile != null) {
                selectedHandler.writeCertToFile((IX509Certificate[])this.certChain, pemFile);
            }
            this.close();
        }
        catch (UnrecoverableKeyException e) {
            this.badPassword();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception occurred while processing OpenCsrCommand", e);
            this.close();
        }
    }

    private void badPassword() {
        this.caPassword.getModel().setText("");
        BDialog.error((BWidget)this, (String)lex.getText("cert.signer.dialog.password.error.title"), (Object)lex.getText("cert.signer.dialog.password.error.message"));
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    protected class OpenCsrCommand
    extends Command {
        public OpenCsrCommand() {
            super((BWidget)BCertificateSignerDialog.this, null, open, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() {
            block15: {
                try {
                    BFileChooser chooser = BFileChooser.makeOpen((BWidget)this.getOwner());
                    chooser.addFilter((IFileFilter)new ExtFileFilter(lex.getText("csr.extension.info"), "csr"));
                    chooser.setTitle(lex.getText("cert.signer.csr.select"));
                    chooser.setCurrentDirectory(BOrd.make((String)("file:/" + BCertsTable.getCertsDirectoryPath())));
                    BOrd[] ordArray = chooser.show(false);
                    if (ordArray.length == 0) {
                        return null;
                    }
                    BOrd ord = ordArray[0];
                    BAbstractFile csrFile = (BAbstractFile)ord.get();
                    if (csrFile == null) break block15;
                    InputStreamReader isr = new InputStreamReader(csrFile.getInputStream());
                    FriendlyPemReader fpr = new FriendlyPemReader((Reader)isr);
                    PEMParser pr = new PEMParser((Reader)fpr);
                    try {
                        Object obj = pr.readObject();
                        if (obj != null) {
                            if (obj instanceof PKCS10CertificationRequest) {
                                PKCS10CertificationRequest tcsr = (PKCS10CertificationRequest)obj;
                                JcaPKCS10CertificationRequest jcaCsr = new JcaPKCS10CertificationRequest(tcsr.getEncoded());
                                BCertificateSignerDialog.this.csr = NPKCS10CertificationRequest.make((JcaPKCS10CertificationRequest)jcaCsr);
                                BCertificateSignerDialog.this.csrFileText.setText(csrFile.toPathString());
                                BCertificateSignerDialog.this.baseFileName = BajaFileUtil.getBase((String)csrFile.getFileName());
                                BCertificateSignerDialog.this.subject.setText(BCertificateSignerDialog.this.csr.getSubject());
                                BCertificateSignerDialog.this.subjectDN.setText(BCertificateSignerDialog.this.csr.getSubjectDN().toString());
                                BCertificateSignerDialog.this.keyAlg.setText(BCertificateSignerDialog.this.csr.getKeyAlgorithm());
                                BCertificateSignerDialog.this.keySize.setText(BCertificateSignerDialog.this.csr.getKeySize() + "");
                                BCertificateSignerDialog.this.sigAlg.setText(BCertificateSignerDialog.this.csr.getSignatureAlgorithm());
                                BCertificateSignerDialog.this.sigSize.setText(BCertificateSignerDialog.this.csr.getSignatureSize() + "");
                                BCertificateSignerDialog.this.verified.setText(BCertificateSignerDialog.this.csr.verify() + "");
                                BCertificateSignerDialog.this.csrPane.setVisible(true);
                                BCertificateSignerDialog.this.extensionPane.setExtensions(BCertificateSignerDialog.this.csr.getExtensions(), true);
                                if (BCertificateSignerDialog.this.extensionPane.getExtensionCount() > 0) {
                                    BCertificateSignerDialog.this.extensionsPane.setVisible(true);
                                } else {
                                    BCertificateSignerDialog.this.extensionsPane.setVisible(false);
                                }
                                BCertificateSignerDialog.this.setBoundsCenteredOnOwner();
                            } else {
                                BDialog.warning((BWidget)this.getOwner(), (String)lex.getText("csr.selection.error.title"), (Object)lex.getText("csr.selection.error.msg", new Object[]{csrFile.getFileName()}));
                            }
                        }
                    }
                    finally {
                        try {
                            pr.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    CommandUtil.error((Command)this, (Throwable)e);
                }
            }
            return null;
        }
    }
}

