/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.ext.NX509Extension;
import com.tridium.json.JSONObject;
import com.tridium.platcrypto.ui.BCertificateExtensionFolder;
import java.util.Base64;
import java.util.regex.Pattern;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509Extension;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="include", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="identifier", type="BString", defaultValue="", flags=1), @NiagaraProperty(name="critical", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="data", type="BString", defaultValue="", flags=1), @NiagaraProperty(name="oid", type="BString", defaultValue="", flags=1), @NiagaraProperty(name="octets", type="BString", defaultValue="", flags=1)})
public final class BCertificateExtension
extends BComponent {
    @Generated
    public static final Property include = BCertificateExtension.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property identifier = BCertificateExtension.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property critical = BCertificateExtension.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property data = BCertificateExtension.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property oid = BCertificateExtension.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property octets = BCertificateExtension.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateExtension.class);
    private IX509Extension ix509Extension;
    public static final Pattern EXTENSION_DATA_SPLIT_PATTERN = Pattern.compile("::");

    @Generated
    public boolean getInclude() {
        return this.getBoolean(include);
    }

    @Generated
    public void setInclude(boolean v) {
        this.setBoolean(include, v, null);
    }

    @Generated
    public String getIdentifier() {
        return this.getString(identifier);
    }

    @Generated
    public void setIdentifier(String v) {
        this.setString(identifier, v, null);
    }

    @Generated
    public boolean getCritical() {
        return this.getBoolean(critical);
    }

    @Generated
    public void setCritical(boolean v) {
        this.setBoolean(critical, v, null);
    }

    @Generated
    public String getData() {
        return this.getString(data);
    }

    @Generated
    public void setData(String v) {
        this.setString(data, v, null);
    }

    @Generated
    public String getOid() {
        return this.getString(oid);
    }

    @Generated
    public void setOid(String v) {
        this.setString(oid, v, null);
    }

    @Generated
    public String getOctets() {
        return this.getString(octets);
    }

    @Generated
    public void setOctets(String v) {
        this.setString(octets, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCertificateExtension() {
    }

    public BCertificateExtension(IX509Extension ix509Extension) throws Exception {
        this.ix509Extension = ix509Extension;
        this.setIdentifier(ix509Extension.getIdentifier());
        this.setCritical(ix509Extension.isCritical());
        this.setData(String.join((CharSequence)EXTENSION_DATA_SPLIT_PATTERN.pattern(), new JSONObject(ix509Extension.getJSON()).toString(2)));
        String oid = ix509Extension.getOid().getId();
        this.setOid(oid);
        byte[] octets = ix509Extension.getExtension().getExtnValue().getOctets();
        this.setOctets(Base64.getEncoder().encodeToString(octets));
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BCertificateExtensionFolder.TYPE);
    }

    public IX509Extension getNx509Extension() throws Exception {
        if (this.ix509Extension == null) {
            ASN1ObjectIdentifier asn1ObjectIdentifier = new ASN1ObjectIdentifier(this.getOid()).intern();
            byte[] octets = Base64.getDecoder().decode(this.getOctets());
            Extension extension = new Extension(asn1ObjectIdentifier, this.getCritical(), octets);
            this.ix509Extension = NX509Extension.make((Extension)extension);
        }
        return this.ix509Extension;
    }
}

