/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon.wb;

import com.tridium.crypto.core.cert.TridiumHostnameVerifier;
import com.tridium.crypto.core.io.CoreClientTrustManager;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.daemon.wb.BDaemonSecureScheme;
import com.tridium.platcrypto.ui.WbExemptionApprover;
import com.tridium.platcrypto.util.BSslSessionInfo;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.util.BSessionInfo;
import java.net.ConnectException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.net.HttpConnection;
import javax.baja.net.HttpsConnection;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@NiagaraType
public class BDaemonSecureSession
extends BDaemonSession {
    @Generated
    public static final Type TYPE = Sys.loadType(BDaemonSecureSession.class);
    public static final String PLATFORM_SSL_ORD = "platformssl";
    private static final BIcon secureBadgeConnected = BIcon.std((String)"badges/lock.png");
    private static final BIcon secureBadgeDisconnected = BIcon.std((String)"badges/lockDisconnected.png");
    private SocketFactory socketFactory;
    private Socket lastSocket = null;
    private final Object SOCKET_FACTORY_LOCK = new Object();
    private final BOrd ordInHost;
    private final BOrd absOrd;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BDaemonSession makeNewSession(BHost host, int port) {
        return BDaemonSecureSession.make(host, port);
    }

    public static BDaemonSession makeIgnoringCache(BHost host, int port) {
        StringBuilder nameBuilder = new StringBuilder("noCache:");
        nameBuilder.append(PLATFORM_SSL_ORD);
        if (port != 5011) {
            nameBuilder.append(":").append(port);
        }
        return new BDaemonSecureSession(nameBuilder.toString(), host, port, BOrd.make((String)""));
    }

    public static BDaemonSession make(BHost host, int port) {
        BDaemonSession session;
        StringBuilder nameBuilder = new StringBuilder(PLATFORM_SSL_ORD);
        if (port != 5011) {
            nameBuilder.append(":").append(port);
        }
        if (!((session = (BDaemonSession)host.getNavChild(nameBuilder.toString())) instanceof BDaemonSecureSession)) {
            BOrd ordInHost = BOrd.make((OrdQuery)new BDaemonSecureScheme.DaemonQuery(port));
            session = new BDaemonSecureSession(nameBuilder.toString(), host, port, ordInHost);
            host.addNavChild((BINavNode)session);
        }
        return session;
    }

    protected BDaemonSecureSession(String name, BHost host, int port, BOrd ordInHost) {
        super(name, host, port, ordInHost, LexiconText.make((String)"platCrypto", (String)"daemon.secure.session"));
        this.ordInHost = ordInHost;
        this.absOrd = BOrd.make((BOrd)host.getAbsoluteOrd(), (BOrd)this.ordInHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpConnection createNewConnection(String pMethod, long contentLength, int timeout, int connectionFlags, String uri) {
        try {
            Object object = this.SOCKET_FACTORY_LOCK;
            synchronized (object) {
                if (this.socketFactory == null) {
                    this.socketFactory = HttpsConnection.getDefaultSocketFactory();
                }
                HttpsConnection conn = new HttpsConnection(this.getHost(), this.getPort(), uri, this.socketFactory);
                return this.initConnection((HttpConnection)conn, pMethod, contentLength, timeout, connectionFlags);
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.WARNING, "Exception occurred while creating new HttpsConnection", e);
            } else {
                log.warning("Exception occurred while creating new HttpsConnection (" + e + ")");
            }
            return null;
        }
    }

    protected void setDefaultAgent() {
        this.getAgentList().remove("platform:DaemonSessionAgent");
        this.getAgentList().toTop("platformssl:DaemonSecureSessionAgent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSSLSocketFactory(SSLSocketFactory socketFactory) {
        Object object = this.SOCKET_FACTORY_LOCK;
        synchronized (object) {
            this.socketFactory = socketFactory;
        }
    }

    protected SslContextFactory getWebSocketSslContextFactory() {
        try {
            return AccessController.doPrivileged(() -> {
                ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
                CoreCryptoManager ccm = CoreCryptoManager.get((ISecurityInfoProvider)provider);
                SslContextFactory.Client factory = ccm.getSslContextFactory(ClientTlsParameters.DEFAULT);
                factory.setEndpointIdentificationAlgorithm(null);
                factory.setHostnameVerifier((HostnameVerifier)new TridiumHostnameVerifier(ccm.getExemptionStore()));
                SSLContext sslContext = SSLContext.getInstance((String)CryptoSupport.TYPES.get("tlsv1"));
                TrustManager[] tm = new X509TrustManager[]{CoreClientTrustManager.make((ISecurityInfoProvider)provider, WbExemptionApprover::new)};
                sslContext.init(null, tm, null);
                factory.setSslContext(sslContext);
                return factory;
            });
        }
        catch (PrivilegedActionException pae) {
            log.warning("Error creating websocket SSL context factory: " + pae.getCause().getMessage());
            return null;
        }
    }

    protected boolean useTlsWebSockets() {
        return true;
    }

    protected int connect(HttpConnection conn) throws ConnectException {
        int rc = super.connect(conn);
        this.lastSocket = conn.getSocket();
        return rc;
    }

    public BSessionInfo getSessionInfo() {
        BHost host = this.getHost();
        if (host != null) {
            String userName = null;
            if (this.getCredentials() instanceof BIUserCredentials) {
                userName = ((BIUserCredentials)this.getCredentials()).getUsername();
            }
            return BSslSessionInfo.make((String)host.getHostname(), (BAbsTime)this.getLastConnectedAbsTime(), (Socket)this.lastSocket, (String)userName, (String)host.getHostname(), (boolean)this.getHostProperties().isFips());
        }
        return null;
    }

    public boolean shouldDowngrade(BPlatformSSLSettings newSettings) {
        return !newSettings.getSslEnabled();
    }

    public boolean isSecure() {
        return true;
    }

    protected String getLexiconPrefix() {
        return "DaemonSecureSession.";
    }

    protected int getDefaultPort() {
        return 5011;
    }

    public BIcon getIcon() {
        return BIcon.make((BIcon)super.getIcon(), (BIcon)(this.isConnected() ? secureBadgeConnected : secureBadgeDisconnected));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect(boolean clearCredentials) {
        super.disconnect(clearCredentials);
        Object object = this.SOCKET_FACTORY_LOCK;
        synchronized (object) {
            this.socketFactory = null;
        }
    }

    public BOrd getNavOrd() {
        return this.getAbsoluteOrd();
    }

    public BOrd getOrdInHost() {
        return this.ordInHost;
    }

    public BOrd getAbsoluteOrd() {
        return this.absOrd;
    }
}

