/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon.wb;

import com.tridium.authn.AuthenticationClient;
import com.tridium.platcrypto.daemon.wb.BDaemonSecureSession;
import com.tridium.platform.daemon.BDaemonScheme;
import com.tridium.platform.daemon.BDaemonSession;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="platformssl")
@NiagaraSingleton
public class BDaemonSecureScheme
extends BOrdScheme {
    @Generated
    public static final BDaemonSecureScheme INSTANCE = new BDaemonSecureScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BDaemonSecureScheme.class);
    public static final int DEFAULT_PORT = 5011;

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BDaemonSecureScheme() {
        super("platformssl");
    }

    public OrdQuery parse(String queryBody) {
        return new DaemonQuery(queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        return this.resolve(base, query, null);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query, AuthenticationClient client) throws SyntaxException, UnresolvedException {
        if (!(base.get() instanceof BHost)) {
            throw new InvalidOrdBaseException();
        }
        BHost host = (BHost)base.get();
        BDaemonScheme.DaemonQuery daemonQuery = (BDaemonScheme.DaemonQuery)query;
        int port = daemonQuery == null ? 5011 : daemonQuery.getPort();
        BDaemonSession session = null;
        try {
            session = BDaemonSecureSession.make(host, port);
            if (client != null) {
                session.setAuthenticationClient(client);
            }
            session.connect();
        }
        catch (AuthenticationException e) {
            if (session != null) {
                session.disconnect();
            }
            throw e;
        }
        catch (Exception e) {
            throw new UnresolvedException(query.toString(), (Throwable)e);
        }
        return new OrdTarget(base, (BObject)session);
    }

    public static class DaemonQuery
    extends BDaemonScheme.DaemonQuery
    implements OrdQuery {
        DaemonQuery(String body) {
            super(body);
        }

        DaemonQuery(int port) {
            super(port);
        }

        public String getScheme() {
            return "platformssl";
        }

        public String toString() {
            return "platformssl:" + this.getBody();
        }

        public int getDefaultPort() {
            return 5011;
        }
    }
}

