/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import java.util.BitSet;
import java.util.HashMap;
import javax.baja.naming.BOrd;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.treetable.DynamicTreeTableModel;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTagDictionary;
import javax.baja.workbench.mgr.MgrTemplate;
import javax.baja.workbench.mgr.tag.BTagFilterEnum;

public class MgrState {
    static HashMap<String, MgrState> cache = new HashMap();
    String tagNamespace;
    BOrd lastSaveOrd;
    boolean isLearnMode;
    static boolean isTagMode;
    static boolean isTemplateMode;
    BitSet modelColumns;
    BitSet learnColumns;
    BitSet tagColumns;
    BitSet templateColumns;
    BTagFilterEnum tagFilterEnum;

    public static String toKey(BAbstractManager manager) {
        return manager.getType().toString();
    }

    public static MgrState getCached(String key) {
        return cache.get(key);
    }

    public static void cache(String key, MgrState state) {
        cache.put(key, state);
    }

    public void restore(BAbstractManager manager) {
        this.restoreForType(manager);
        if (manager.getWbShell() != null) {
            BOrd restoreOrd = manager.getWbShell().getActiveOrd();
            if (this.lastSaveOrd != null && this.lastSaveOrd.equals((Object)restoreOrd)) {
                this.restoreForOrd(manager);
            }
        }
    }

    protected void restoreForType(BAbstractManager manager) {
        MgrController controller = manager.getController();
        MgrLearn learn = manager.getLearn();
        MgrTagDictionary tagDictionary = manager.getMgrTagDictionary();
        MgrTemplate mgrTemplate = manager.getMgrTemplate();
        this.restoreColumns(manager.getModel().getTable().dynamicModel, this.modelColumns);
        if (learn != null) {
            controller.learnMode.setSelected(this.isLearnMode);
            this.restoreColumns(learn.getTable().dynamicModel, this.learnColumns);
        }
        if (tagDictionary != null) {
            tagDictionary.setNamespace(this.tagNamespace);
            controller.tagMode.setSelected(isTagMode);
            tagDictionary.setTagFilter(this.tagFilterEnum);
        }
        if (mgrTemplate != null) {
            controller.templateMode.setSelected(isTemplateMode);
            this.restoreColumns(mgrTemplate.getTable().dynamicModel, this.templateColumns);
        }
    }

    protected void restoreForOrd(BAbstractManager manager) {
    }

    public void save(BAbstractManager manager) {
        this.lastSaveOrd = manager.getWbShell().getActiveOrd();
        this.saveForType(manager);
        this.saveForOrd(manager);
    }

    protected void saveForType(BAbstractManager manager) {
        MgrController controller = manager.getController();
        MgrLearn learn = manager.getLearn();
        MgrModel model = manager.getModel();
        MgrTagDictionary tagDictionary = manager.getMgrTagDictionary();
        MgrTemplate mgrTemplate = manager.getMgrTemplate();
        this.modelColumns = this.saveColumns(model.getTable().dynamicModel);
        if (learn != null) {
            isTagMode = controller.tagMode.isSelected();
            this.isLearnMode = controller.learnMode.isSelected();
            this.learnColumns = this.saveColumns(learn.getTable().dynamicModel);
        }
        if (tagDictionary != null) {
            isTagMode = controller.tagMode.isSelected();
            this.tagNamespace = tagDictionary.getNamespace();
            this.tagFilterEnum = tagDictionary.getTagFilter();
        }
        if (mgrTemplate != null && (isTemplateMode = controller.templateMode.isSelected())) {
            this.templateColumns = this.saveColumns(mgrTemplate.getTable().dynamicModel);
        }
    }

    protected void saveForOrd(BAbstractManager manager) {
    }

    BitSet saveColumns(DynamicTableModel model) {
        BitSet map = new BitSet();
        for (int i = 0; i < model.getRootColumnCount(); ++i) {
            if (model.showColumn(i)) {
                map.set(i);
                continue;
            }
            map.clear(i);
        }
        return map;
    }

    void restoreColumns(DynamicTableModel model, BitSet map) {
        if (map == null) {
            return;
        }
        for (int i = 0; i < model.getRootColumnCount(); ++i) {
            model.setShowColumn(i, map.get(i));
        }
    }

    BitSet saveColumns(DynamicTreeTableModel model) {
        BitSet map = new BitSet();
        for (int i = 0; i < model.getRootColumnCount(); ++i) {
            if (model.showColumn(i)) {
                map.set(i);
                continue;
            }
            map.clear(i);
        }
        return map;
    }

    void restoreColumns(DynamicTreeTableModel model, BitSet map) {
        if (map == null) {
            return;
        }
        for (int i = 0; i < model.getRootColumnCount(); ++i) {
            model.setShowColumn(i, map.get(i));
        }
    }
}

