/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.util.BTitlePane;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrSupport;
import javax.baja.workbench.mgr.MgrTypeInfo;

public abstract class MgrLearn
extends MgrSupport {
    BLearnTable table;
    BWidget jobBar;
    BJob job;
    MgrColumn[] cols;
    Object[] roots = new Object[0];
    boolean jobComplete;

    public MgrLearn(BAbstractManager manager) {
        super(manager);
    }

    @Override
    public void init() {
        this.updateColumns();
    }

    public final BLearnTable getTable() {
        return this.table;
    }

    public final BWidget getJobBar() {
        return this.jobBar;
    }

    public final MgrColumn[] getColumns() {
        if (this.cols == null) {
            // empty if block
        }
        return (MgrColumn[])this.cols.clone();
    }

    public void updateTable() {
        this.table.getSelection().deselectAll();
        if (this.hasDynamicColumns()) {
            this.updateColumns();
            this.table.updateColumns();
        }
        this.table.treeTableModel.updateTreeTable(true);
    }

    void updateColumns() {
        this.cols = (MgrColumn[])this.makeColumns().clone();
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i].init(this.manager);
        }
    }

    public final int getRootCount() {
        return this.roots.length;
    }

    public final Object getRoot(int index) {
        return this.roots[index];
    }

    public final Object[] getRoots() {
        return (Object[])this.roots.clone();
    }

    public final void updateRoots(Object[] roots) {
        this.roots = (Object[])roots.clone();
        this.updateTable();
    }

    public BWidget makePane() {
        String title = this.makeTableTitle();
        this.table = this.makeTable();
        this.jobBar = this.makeJobBar();
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)BTitlePane.makePane((String)title, (BTable)this.table));
        if (this.jobBar != null) {
            if (this.jobBar instanceof BJobBar) {
                this.manager.attach((BJobBar)this.jobBar);
                BBorderPane jobPane = new BBorderPane(this.jobBar, BBorder.none, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
                jobPane.setFill(Theme.widget().getWindowBackground());
                jobPane = new BBorderPane((BWidget)jobPane, BBorder.none, BInsets.DEFAULT);
                pane.setTop((BWidget)new BBorderPane((BWidget)jobPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0)));
            } else {
                pane.setTop((BWidget)new BBorderPane(this.jobBar, 0.0, 0.0, 5.0, 0.0));
            }
        }
        return pane;
    }

    public String makeTableTitle() {
        return this.manager.lexDiscoveryObjects;
    }

    protected BLearnTable makeTable() {
        return new BLearnTable(this);
    }

    protected BWidget makeJobBar() {
        return new BJobBar();
    }

    protected boolean hasDynamicColumns() {
        return false;
    }

    protected abstract MgrColumn[] makeColumns();

    public boolean isDepthExpandable(int depth) {
        return false;
    }

    public boolean isGroup(Object discovery) {
        return false;
    }

    public boolean hasChildren(Object discovery) {
        return true;
    }

    public Object[] getChildren(Object discovery) {
        return new Object[0];
    }

    public BImage getIcon(Object discovery) {
        return null;
    }

    public BComponent getExisting(Object discovery) {
        ComponentTableModel model = this.getManager().getModel().getTable().getComponentModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            BComponent comp = model.getComponentAt(i);
            if (!this.isExisting(discovery, comp)) continue;
            return comp;
        }
        return null;
    }

    public boolean isExisting(Object discovery, BComponent component) {
        return false;
    }

    public BJob getJob() {
        return this.job;
    }

    public void setJob(BJob job) {
        this.job = job;
        this.jobComplete = false;
        if (this.jobBar instanceof BJobBar) {
            this.getManager().registerForComponentEvents((BComponent)job);
            ((BJobBar)this.jobBar).load(job);
        }
        if (job != null && job.getJobState().isComplete() && !this.jobComplete) {
            this.jobComplete = true;
            if (this.getManager() != null && this.getManager().isRegisteredForComponentEvents((BComponent)job)) {
                this.getManager().registerForComponentEvents((BComponent)job, Integer.MAX_VALUE);
            }
            this.jobComplete(job);
        }
    }

    public void setJob(BOrd jobOrd) throws Exception {
        BComponent base = (BComponent)this.getManager().getCurrentValue();
        base.getComponentSpace().sync();
        BJob job = (BJob)jobOrd.get((BObject)base);
        this.setJob(job);
    }

    public void jobComplete(BJob job) {
    }

    public boolean isMatchable(Object discovery, BComponent database) {
        try {
            MgrTypeInfo[] types = this.toTypes(discovery);
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].isMatchable(database)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public abstract MgrTypeInfo[] toTypes(Object var1) throws Exception;

    public abstract void toRow(Object var1, MgrEditRow var2) throws Exception;
}

