/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench;

import com.tridium.nre.security.SecurityInitializer;
import com.tridium.workbench.shell.BErrorPanel;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BNiagaraWbLocatorBar;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.WbCommands;
import com.tridium.workbench.shell.WbMain;
import com.tridium.workbench.sidebars.BNavSideBar;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebBrowserView;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BRootScheme;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.RegistryException;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.menu.BIMenuBar;
import javax.baja.ui.options.BUserOptions;
import javax.baja.ui.toolbar.BIToolBar;
import javax.baja.web.js.BIJavaScript;
import javax.baja.workbench.BWbLocatorBar;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.BWbStatusBar;
import javax.baja.workbench.sidebar.BIWbSideBar;
import javax.baja.workbench.sidebar.BWbSideBar;
import javax.baja.workbench.tool.BWbTool;
import javax.baja.workbench.view.BWbView;

@NiagaraType
public class BWbProfile
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BWbProfile.class);
    BNiagaraWbShell shell;
    private static final String[] DEV_VIEWS = new String[]{"bql:CollectionView", "bajaui:CollectionView"};
    private static final Map<String, Boolean> devViewsEnabled = new HashMap<String, Boolean>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BWbProfile make(BWbShell shell, Type type) {
        try {
            Class cls = type.getTypeClass();
            Constructor ctor = cls.getConstructor(BWbShell.class);
            return (BWbProfile)((Object)ctor.newInstance(new Object[]{shell}));
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Cannot call B" + type.getTypeName() + "(WbShell)", (Throwable)e);
        }
    }

    public BWbProfile(BWbShell shell) {
        this.shell = (BNiagaraWbShell)shell;
    }

    public BWbProfile() {
    }

    public final BWbShell getShell() {
        return this.shell;
    }

    public BIMenuBar makeMenuBar() {
        return this.shell.commands.makeMenuBar();
    }

    public BIToolBar makeToolBar() {
        return this.shell.commands.makeToolBar();
    }

    public BWbLocatorBar makeLocatorBar() {
        return new BNiagaraWbLocatorBar(this.shell);
    }

    public BWbStatusBar makeStatusBar() {
        return new BWbStatusBar(this.shell);
    }

    public BWidget makeErrorDisplay(BWbShell shell, String msg, BOrd ord, Throwable ex) {
        return new BErrorPanel(shell, msg, ord, ex);
    }

    public String getAppName() {
        return null;
    }

    public String[] getAppNames() {
        if (this.getAppName() != null) {
            return new String[]{this.getAppName()};
        }
        return new String[0];
    }

    public boolean hasView(BObject target, AgentInfo agentInfo) {
        return true;
    }

    public AgentList getAgents(BObject target) {
        AgentList list = target.getAgents();
        for (String string : DEV_VIEWS) {
            if (devViewsEnabled.get(string).booleanValue()) continue;
            list.remove(string);
        }
        if (BWebBrowser.BROWSING_DISABLED) {
            for (String string : list.list()) {
                if (!string.getAgentType().is(BIJavaScript.TYPE) && !string.getAgentType().is(BWebBrowserView.TYPE)) continue;
                list.toBottom((AgentInfo)string);
            }
        }
        return list;
    }

    public BWbView customizeView(BWbView view) {
        return view;
    }

    public boolean hasSideBar() {
        return true;
    }

    public boolean hasSideBar(TypeInfo typeInfo) {
        try {
            String[] appNames = this.getAppNames();
            if (typeInfo.getAgentInfo().getAppName() == null) {
                return true;
            }
            for (int i = 0; i < appNames.length; ++i) {
                if (!appNames[i].equals(typeInfo.getAgentInfo().getAppName())) continue;
                return true;
            }
            return false;
        }
        catch (RegistryException e) {
            return this.getAppName() == null;
        }
    }

    public BIWbSideBar[] getDefaultSideBars() {
        return new BIWbSideBar[]{new BNavSideBar()};
    }

    public boolean hasTools() {
        return true;
    }

    public boolean hasTool(TypeInfo typeInfo) {
        return true;
    }

    public BWidget getQuickSearch(BWbView view) {
        return this.shell.commands.getQuickSearch(view);
    }

    public boolean hasQuickSearch(AgentInfo quickSearchInfo, BWbView view) {
        return true;
    }

    public BImage getFrameIcon() {
        if (SecurityInitializer.getInstance().isFips()) {
            BIcon wbFipsIcon = BIcon.make((BIcon)BIcon.make((String)WbMain.brandIcon), (BIcon)BIcon.make((String)WbMain.brandFIPSBadge));
            return BImage.make((BIcon)wbFipsIcon);
        }
        return BImage.make((String)WbMain.brandIcon);
    }

    public String getFrameTitle() {
        if (SecurityInitializer.getInstance().isFips()) {
            return WbMain.brandTitle + " " + WbMain.FIPS_TITLE_SUFFIX;
        }
        return WbMain.brandTitle;
    }

    public boolean hasUserOptions(TypeInfo typeInfo) {
        return true;
    }

    public BOrd getStartOrd() {
        return WbCommands.getAboutOrd();
    }

    public BOrd getOpenOrd(BISession session, BOrd def) {
        return def;
    }

    public BOrd getHomeOrd() {
        return this.shell.commands.getHomeOrd();
    }

    public BOrd getNavRootOrd() {
        return BRootScheme.ORD;
    }

    public boolean canHyperlink(BOrd ord) {
        return true;
    }

    public static void main(String[] args) {
        BWbProfile p = new BNiagaraWbFrame(WbMain.defaultProfileType).getProfile();
        System.out.println("MenuBar");
        BIMenu[] menus = p.makeMenuBar().getMenus();
        for (int i = 0; i < menus.length; ++i) {
            System.out.println("  " + menus[i].asWidget().getName());
            BWbProfile.dumpMenu(menus[i], "  ");
        }
        System.out.println("ToolBar");
        BComponent[] toolBar = p.makeToolBar().asWidget().getChildComponents();
        for (int i = 0; i < toolBar.length; ++i) {
            if (toolBar[i] instanceof BSeparator) {
                System.out.println("  ---");
                continue;
            }
            System.out.println("  " + toolBar[i].getName());
        }
        System.out.println("SideBars");
        TypeInfo[] sideBars = BWbSideBar.getInstalled();
        for (int i = 0; i < sideBars.length; ++i) {
            System.out.println("  " + sideBars[i]);
        }
        System.out.println("Tools");
        TypeInfo[] tools = BWbTool.getInstalled();
        for (int i = 0; i < tools.length; ++i) {
            System.out.println("  " + tools[i]);
        }
        System.out.println("UserOptions");
        TypeInfo[] options = Sys.getRegistry().getConcreteTypes(BUserOptions.TYPE.getTypeInfo());
        for (int i = 0; i < options.length; ++i) {
            System.out.println("  " + options[i]);
        }
    }

    static void dumpMenu(BIMenu menu, String indent) {
        String itemIndent = indent + "  ";
        System.out.println(indent + "{");
        BComponent[] items = menu.asWidget().getChildComponents();
        for (int i = 0; i < items.length; ++i) {
            BComponent item = items[i];
            if (item instanceof BSeparator) {
                System.out.println(itemIndent + "---");
                continue;
            }
            if (items[i] instanceof BSubMenuItem) {
                System.out.println(itemIndent + item.getName());
                BWbProfile.dumpMenu((BIMenu)((BSubMenuItem)items[i]).getMenu(), itemIndent);
                continue;
            }
            if (items[i] instanceof BMenuItem) {
                BMenuItem menuItem = (BMenuItem)item;
                if (menuItem.getCommand() instanceof WbCommands.ToolCommand || menuItem.getCommand() instanceof WbCommands.SideBarCommand) continue;
                System.out.println(itemIndent + item.getName());
                continue;
            }
            System.out.println(itemIndent + item.getName() + " [" + item.getType() + "]");
        }
        System.out.println(indent + "}");
    }

    static {
        for (String s : DEV_VIEWS) {
            devViewsEnabled.put(s, AccessController.doPrivileged(() -> Boolean.getBoolean("profile.enableDevView." + s)));
        }
    }
}

