/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.workbench.shell.BErrorPanel;
import com.tridium.workbench.web.browser.BWebWidget;
import com.tridium.workbench.web.browser.BrowserUtil;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.baja.agent.AgentInfo;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.space.BSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;
import javax.baja.workbench.view.BWbViewBinding;

public final class WebWidgetUtil {
    private static final String hyperlinkCacheKey = "hyperlinkViewCache";
    private static final Set<BWebWidget> localhostCache = new HashSet<BWebWidget>();

    private WebWidgetUtil() {
    }

    public static BWebWidget getCacheableWebWidget(BWbView wbView, BISession sess, BOrd ord, AgentInfo agent, BSpace space) {
        BWebWidget ww;
        FoxSession session;
        BFoxClientConnection connection;
        if (sess == null) {
            sess = BLocalHost.INSTANCE;
        }
        Set cache = localhostCache;
        if (sess instanceof BFoxSession && (connection = ((BFoxSession)sess).getConnection()) != null && (session = connection.session()) != null) {
            cache = (Set)session.getFromCache(hyperlinkCacheKey, key -> new ClosableHashSet());
        }
        if ((ww = (BWebWidget)cache.stream().filter(w -> w == wbView || BWbShell.getWbShell(w) == null && !w.isClaimed()).findFirst().orElse(null)) != null && Boolean.FALSE.equals(ww.fw(406, ord, agent, space, null))) {
            cache.remove(ww);
            ww.close();
            ww = null;
        }
        if (ww == null) {
            if (agent != null) {
                ww = new BWebWidget(agent, ord);
                cache.add(ww);
            } else {
                ww = new BWebWidget();
                cache.add(ww);
            }
            ww.setCloseOnStop(false);
        }
        if (ww.getParent() != null) {
            Property p = ww.getPropertyInParent();
            ww.getParent().set(p, p.getDefaultValue());
        }
        return ww;
    }

    public static void replaceWithCacheableWebWidget(BWbView wbView, BWebWidget webWidget) {
        if (!webWidget.getTypeInfoFromJs().isPresent()) {
            return;
        }
        BWebWidget cacheableWebWidget = WebWidgetUtil.getCacheableWebWidget(wbView);
        BWidget content = cacheableWebWidget.getContent();
        if (content instanceof BErrorPanel) {
            return;
        }
        cacheableWebWidget.removeAll();
        cacheableWebWidget.copyFrom((BComplex)webWidget);
        cacheableWebWidget.setContent(content);
        for (Property prop : webWidget.getDynamicPropertiesArray()) {
            String name = prop.getName();
            int flags = webWidget.getFlags((Slot)prop);
            BFacets facets = webWidget.getSlotFacets((Slot)prop);
            BValue v = webWidget.get(prop);
            webWidget.remove(name);
            cacheableWebWidget.add(name, v, flags, (Context)facets);
        }
        if (webWidget.getParent() != null) {
            Property p = webWidget.getPropertyInParent();
            webWidget.getParent().set(p, (BValue)cacheableWebWidget);
        }
    }

    public static BWebWidget getUxPxWidget(BWbView view) {
        OrdTarget viewTarget = view.getWbShell().getActiveOrdTarget();
        BWebWidget webWidget = WebWidgetUtil.getCacheableWebWidget(view, viewTarget.getSpace().getSession(), viewTarget.getOrd(), null, viewTarget.getSpace());
        if (webWidget.getCurrentValue() != null) {
            webWidget.removeAll();
            webWidget.loadValue(null);
        }
        webWidget.add("hideCommandBar", (BValue)BBoolean.TRUE, 0x40000000);
        webWidget.setJs(BOrd.make((String)"view:bajaui:UxPxWidget"));
        BWbViewBinding binding = new BWbViewBinding();
        binding.setOrd(viewTarget.getOrd());
        webWidget.add(null, (BValue)binding);
        return webWidget;
    }

    public static void clearCache(BWebWidget ww) {
        FoxSession session;
        BFoxClientConnection connection;
        BISession sess;
        OrdTarget target;
        ww.setCloseOnStop(true);
        BWbShell shell = BrowserUtil.findWbShell((BComplex)ww);
        if (shell != null && (target = shell.getActiveOrdTarget()) != null && target.getSpace() != null && (sess = target.getSpace().getSession()) instanceof BFoxSession && (connection = ((BFoxSession)sess).getConnection()) != null && (session = connection.session()) != null) {
            Optional opt = session.getFromCache(hyperlinkCacheKey);
            opt.ifPresent(cache -> cache.remove(ww));
        }
        localhostCache.remove(ww);
    }

    public static BWebWidget getCacheableWebWidget(BWbView wbView) {
        OrdTarget viewTarget = wbView.getWbShell().getActiveOrdTarget();
        BWebWidget webWidget = WebWidgetUtil.getCacheableWebWidget(wbView, viewTarget.getSpace().getSession(), viewTarget.getOrd(), null, viewTarget.getSpace());
        if (webWidget.getCurrentValue() != null) {
            webWidget.removeAll();
            webWidget.loadValue(null);
        }
        webWidget.setClaimed(true);
        return webWidget;
    }

    private static class ClosableHashSet<E>
    extends HashSet<E>
    implements AutoCloseable {
        private ClosableHashSet() {
        }

        @Override
        public void close() {
            this.forEach(e -> {
                if (e instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)e).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

