/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.workbench.web.browser.BWebBrowser;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.util.Lexicon;

public class RemoteDebugCommand
extends Command {
    private static final Logger log = Logger.getLogger("webBrowser");
    private static Lexicon LEX = Lexicon.make((String)"workbench");

    public RemoteDebugCommand(BWebBrowser webBrowser) {
        super((BWidget)webBrowser, LEX, "webDevelopmentTools.commands.remoteDebug");
    }

    public CommandArtifact doInvoke() {
        BWebBrowser browser = (BWebBrowser)this.getOwner();
        String debugUrl = browser.getDebugUrl();
        if (debugUrl != null) {
            Clipboard.getDefault().setContents(TransferEnvelope.make((String)debugUrl));
            this.showStatus(debugUrl);
        }
        return null;
    }

    private void showStatus(String debugUrl) {
        BWidgetShell shell;
        if (log.isLoggable(Level.FINE)) {
            log.fine("*** Started debugging WebView! To debug, open Chrome and load url:");
            log.fine(debugUrl);
        }
        if ((shell = this.getOwner().getShell()) != null) {
            shell.showStatus(LEX.getText("webDevelopmentTools.commands.remoteDebug.showStatusText"));
        }
    }
}

