/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;

@NiagaraType
public class BUrlTextField
extends BTextField {
    @Generated
    public static final Type TYPE = Sys.loadType(BUrlTextField.class);
    private static final BIcon ICON = BIcon.std((String)"hyperlink.png");
    public static final Lexicon LEXICON = Lexicon.make((String)"workbench");
    private static final Logger LOGGER = Logger.getLogger("workbench");
    private final String url;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUrlTextField(String url, int urlVisibleColumn) {
        super(url, urlVisibleColumn, false);
        this.url = url;
    }

    public void mouseEntered(BMouseEvent event) {
        this.setMouseCursor(MouseCursor.hand);
    }

    public void mouseExited(BMouseEvent event) {
        this.setMouseCursor(MouseCursor.normal);
    }

    public void mouseDragged(BMouseEvent event) {
    }

    public void mousePressed(BMouseEvent event) {
        Desktop platform;
        if (Desktop.isDesktopSupported() && (platform = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                platform.browse(new URI(this.url));
            }
            catch (URISyntaxException e) {
                String failureText = LEXICON.getText("urlTextField.error.invalidSyntax", new Object[]{e.getInput()});
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.SEVERE, failureText, e);
                } else {
                    LOGGER.log(Level.SEVERE, failureText + ". " + e.getMessage());
                }
                BDialog.error((BWidget)this, (Object)failureText);
            }
            catch (IOException e) {
                String failureText = LEXICON.getText("urlTextField.error.defaultBrowserFailed");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.SEVERE, failureText, e);
                } else {
                    LOGGER.log(Level.SEVERE, failureText + ": " + e.getMessage());
                }
                BDialog.error((BWidget)this, (Object)failureText);
            }
        }
    }

    public String getStyleSelector() {
        return "hyperlink";
    }

    public BIcon getIcon() {
        return ICON;
    }
}

