/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class PropertyManager {
    private File file;
    private String name;
    private Properties props = new Properties();

    public PropertyManager(File file, String name) {
        this.file = file;
        this.name = name;
    }

    public void loadProperties() {
        try (FileInputStream in = new FileInputStream(this.file);){
            this.props.load(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveProperties() {
        try (FileOutputStream out = new FileOutputStream(this.file);){
            this.props.store(out, this.name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String get(String key, String def) {
        String value = this.props.getProperty(key);
        if (value != null) {
            return value;
        }
        this.props.put(key, def);
        return def;
    }

    public int geti(String key, int def) {
        return Integer.parseInt(this.get(key, String.valueOf(def)));
    }

    public double getd(String key, double def) {
        return Double.parseDouble(this.get(key, String.valueOf(def)));
    }

    public boolean getb(String key, boolean def) {
        return Boolean.valueOf(this.get(key, String.valueOf(def)));
    }

    public void set(String key, String value) {
        this.props.put(key, value);
    }

    public void seti(String key, int value) {
        this.props.put(key, String.valueOf(value));
    }

    public void setd(String key, double value) {
        this.props.put(key, String.valueOf(value));
    }

    public void setb(String key, boolean value) {
        this.props.put(key, String.valueOf(value));
    }
}

