/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.sys.tag.ComponentRelations;
import com.tridium.sys.tag.ComponentTags;
import com.tridium.util.CompUtil;
import com.tridium.workbench.util.BEditTagManager;
import com.tridium.workbench.util.TagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.gx.IRectGeom;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BMarker;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tag.Tags;
import javax.baja.tag.util.ImpliedTags;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.table.BTable;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrTagDictionary;
import javax.baja.workbench.mgr.tag.BTagDictionaryPane;
import javax.baja.workbench.mgr.tag.BTagFilterEnum;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="add"), @NiagaraAction(name="remove"), @NiagaraAction(name="save"), @NiagaraAction(name="cancel"), @NiagaraAction(name="updateCommands"), @NiagaraAction(name="tagsModified")})
public class BEditTagDialog
extends BDialog {
    @Generated
    public static final Action add = BEditTagDialog.newAction((int)0, null);
    @Generated
    public static final Action remove = BEditTagDialog.newAction((int)0, null);
    @Generated
    public static final Action save = BEditTagDialog.newAction((int)0, null);
    @Generated
    public static final Action cancel = BEditTagDialog.newAction((int)0, null);
    @Generated
    public static final Action updateCommands = BEditTagDialog.newAction((int)0, null);
    @Generated
    public static final Action tagsModified = BEditTagDialog.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BEditTagDialog.class);
    public static int TAG_GROUP_FLAGS = 16385;
    public static int TAG_GROUP_TAG_FLAGS = 16384;
    public static Id TAG_GROUP_RELATION = Id.newId((String)"n:tagGroup");
    public static final String TAG_GROUP_FACET = "tg__";
    public static final String TAG_GROUP_TAG_FACET = "tgt__";
    public static final BFacets TAG_GROUP_TAG_FACETS = BFacets.make((String)"tgt__", (boolean)true);
    public static final BFacets TAG_GROUP_FACETS = BFacets.make((String)"tg__", (boolean)true);
    private static final BImage addIcon = BImage.make((String)"module://icons/x16/add.png");
    private static final Lexicon lex = Lexicon.make((String)"workbench");
    private static IRectGeom lastBounds;
    private static String lastTagNamespace;
    private static String lastSearch;
    private BButton btnSave;
    private BButton btnAdd;
    private BButton btnRemove;
    private BWbShell shell;
    private MgrTagDictionary mgr;
    private BEditTagManager tagManager;
    private BTagDictionaryPane tagDictionaryPane;
    private BTabbedPane tabbedPane;
    private boolean isBatchEdit;
    private BComponent target;
    private boolean hasUnhiddenTag = false;
    private int results = 2;
    public BComponent directTags;
    public BComponent impliedTags;
    BWbFieldEditor directEditor;
    private static final Logger logger;

    @Generated
    public void add() {
        this.invoke(add, null, null);
    }

    @Generated
    public void remove() {
        this.invoke(remove, null, null);
    }

    @Generated
    public void save() {
        this.invoke(save, null, null);
    }

    @Generated
    public void cancel() {
        this.invoke(cancel, null, null);
    }

    @Generated
    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    @Generated
    public void tagsModified() {
        this.invoke(tagsModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static void open(BWbShell shell, String title, BComponent base) {
        String who = base.getDisplayName(null);
        if (who != null && !who.isEmpty()) {
            title = title + ": " + who;
        }
        BEditTagDialog tagDialog = new BEditTagDialog(shell, title, base);
        if (tagDialog.mgr == null) {
            return;
        }
        if (lastBounds == null) {
            tagDialog.setBoundsCenteredOnOwner();
        } else {
            tagDialog.setScreenBounds(lastBounds.x(), lastBounds.y(), lastBounds.width(), lastBounds.height());
        }
        if (lastTagNamespace != null) {
            tagDialog.setNamespace(lastTagNamespace);
        }
        if (lastSearch != null) {
            tagDialog.setTagSearch(lastSearch);
        }
        tagDialog.open();
    }

    public static BComponent open(BWbShell shell, String title, BComponent base, boolean isBatchEdit) {
        BEditTagDialog tagDialog = new BEditTagDialog(shell, title, base, isBatchEdit);
        if (tagDialog.mgr == null) {
            return null;
        }
        if (lastBounds == null) {
            tagDialog.setBoundsCenteredOnOwner();
        } else {
            tagDialog.setScreenBounds(lastBounds.x(), lastBounds.y(), lastBounds.width(), lastBounds.height());
        }
        if (lastTagNamespace != null) {
            tagDialog.setNamespace(lastTagNamespace);
        }
        if (lastSearch != null) {
            tagDialog.setTagSearch(lastSearch);
        }
        tagDialog.open();
        if (tagDialog.getResult() == 1) {
            BComponent tags = new BComponent();
            try {
                BComponent directTags = tagDialog.getDirectTags();
                for (Property property : directTags.getProperties()) {
                    int flags;
                    BRelation value;
                    String name = property.getName();
                    if (BEditTagDialog.isTagGroupRelationTag(directTags, property)) {
                        value = BEditTagDialog.makeTagGroupRelation(directTags, property);
                        flags = 0;
                    } else {
                        value = directTags.get(property);
                        flags = 16384;
                    }
                    tags.add(name, (BValue)value, flags);
                }
                return tags;
            }
            catch (Exception e) {
                BDialog.error((BWidget)shell, (String)"Error", (Object)"Failed", (Throwable)e);
            }
        }
        return null;
    }

    public BEditTagDialog() {
        throw new IllegalStateException();
    }

    public BEditTagDialog(BWbShell shell, String title, BComponent base) {
        this(shell, title, base, false);
    }

    public BEditTagDialog(BWbShell shell, String title, BComponent base, boolean isBatchEdit) {
        super((BWidget)shell, title, true);
        this.shell = shell;
        this.target = base;
        this.isBatchEdit = isBatchEdit;
        this.tagManager = new BEditTagManager((BWidget)this, base);
        this.mgr = this.tagManager.getMgrTagDictionary();
        if (this.mgr == null) {
            BDialog.error((BWidget)shell, (Object)lex.getText("editTagDialog.noTagService.error.message"));
            return;
        }
        if (this.mgr instanceof BEditTagManager.MgrNoServiceTagDictionary) {
            boolean isStation = this.target.getComponentSpace().getRootComponent() instanceof BStation;
            if (isStation) {
                BDialog.error((BWidget)shell, (Object)lex.getText("editTagDialog.noTagService.error.message"));
                this.mgr = null;
                return;
            }
            this.setTitle(title + " " + lex.getText("editTagDialog.template.offline.title"));
        }
        TagDictionaryService service = this.mgr.getTagDictionaryService();
        Iterator dictionaries = null;
        if (service != null) {
            dictionaries = service.getTagDictionaries().iterator();
        }
        if (dictionaries == null || !dictionaries.hasNext()) {
            BDialog.error((BWidget)shell, (Object)lex.getText("editTagDialog.noTagDictionaries.error.message"));
            this.mgr = null;
            return;
        }
        this.initComponentTags();
        this.directEditor = BWbFieldEditor.makeFor((BObject)this.directTags);
        this.directEditor.loadValue((BObject)this.directTags);
        this.tabbedPane = new BTabbedPane();
        this.tabbedPane.addPane("Direct Tags", (BWidget)this.directEditor);
        if (this.impliedTags != null) {
            BWbFieldEditor impliedEditor = BWbFieldEditor.makeFor((BObject)this.impliedTags);
            impliedEditor.loadValue((BObject)this.impliedTags);
            this.tabbedPane.addPane("Implied Tags", (BWidget)impliedEditor);
        }
        this.tabbedPane.setShowSingleTab(false);
        this.tagDictionaryPane = (BTagDictionaryPane)this.mgr.makePane();
        this.tagDictionaryPane.setTagEditComp(this.target);
        this.tagDictionaryPane.setTagFilter(BTagFilterEnum.showAll);
        this.tagDictionaryPane.setTagsRootExpanded(true);
        this.tagDictionaryPane.doUpdateDictionary();
        this.tagDictionaryPane.setVisible(true);
        BSplitPane dataPane = new BSplitPane();
        dataPane.setOrientation(BOrientation.vertical);
        dataPane.setWidget1((BWidget)this.tagDictionaryPane);
        dataPane.setWidget2((BWidget)this.tabbedPane);
        BEdgePane rootPane = new BEdgePane();
        rootPane.setCenter((BWidget)dataPane);
        rootPane.setBottom((BWidget)this.buildButtonPane());
        this.setContent((BWidget)rootPane);
        this.linkTo((BComponent)this.directEditor, (Slot)BWbFieldEditor.pluginModified, (Slot)tagsModified);
        this.linkTo((BComponent)this.tabbedPane, (Slot)BTabbedPane.selectionModified, (Slot)updateCommands);
        try {
            if (this.tagDictionaryPane != null && this.tagDictionaryPane.getTable() != null) {
                this.linkTo((BComponent)this.tagDictionaryPane.getTable(), (Slot)BTable.selectionModified, (Slot)updateCommands);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.doUpdateCommands();
    }

    private void setNamespace(String namespace) {
        this.tagDictionaryPane.setNamespace(namespace);
    }

    private void setTagSearch(String lastFilter) {
        this.tagDictionaryPane.setTagSearch(lastFilter);
    }

    private void initComponentTags() {
        try {
            BComponent rootComponent = new BComponent();
            this.hasUnhiddenTag = false;
            this.directTags = new BComponent();
            if (this.isBatchEdit) {
                rootComponent.add("addTags", (BValue)this.directTags);
                return;
            }
            rootComponent.add("direct", (BValue)this.directTags);
            this.impliedTags = new BComponent();
            rootComponent.add("implied", (BValue)this.impliedTags);
            TagDictionaryService service = this.mgr.getTagDictionaryService();
            if (service != null) {
                if (!this.target.isRunning()) {
                    BRelation[] childRelations;
                    StringJoiner unresolvedTagGroupRelationList = new StringJoiner("\n");
                    boolean isUnResolvedTagGroupName = false;
                    for (BRelation childRelation : childRelations = (BRelation[])this.target.getChildren(BRelation.class)) {
                        if (childRelation instanceof BLink || !childRelation.getId().equals((Object)TAG_GROUP_RELATION)) continue;
                        BOrd endpointOrd = null;
                        try {
                            endpointOrd = childRelation.getEndpointOrd();
                            Entity endpoint = childRelation.getEndpoint();
                            String name = "r";
                            if (endpoint instanceof TagGroupInfo) {
                                name = ((TagGroupInfo)endpoint).getGroupId().getQName();
                                name = SlotPath.escape((String)name);
                            }
                            if (this.directTags.get(name) == null) {
                                Property tgProp = this.directTags.add(name, (BValue)endpointOrd, TAG_GROUP_FLAGS);
                                this.directTags.setFacets((Slot)tgProp, BFacets.make((String)TAG_GROUP_FACET, (boolean)true));
                            }
                            this.hasUnhiddenTag = true;
                        }
                        catch (Exception e) {
                            isUnResolvedTagGroupName = true;
                            unresolvedTagGroupRelationList.add(endpointOrd.toString());
                            String logMessage = "Could not resolve the tag group: " + endpointOrd + "; " + e;
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.WARNING, logMessage, e);
                                continue;
                            }
                            logger.warning(logMessage);
                        }
                    }
                    if (isUnResolvedTagGroupName) {
                        BDialog.error((BWidget)this.shell, (String)lex.getText("editTagDialog.unresolvedTagGroup.error.message.title"), (Object)lex.getText("editTagDialog.unresolvedTagGroup.error.message"), (String)unresolvedTagGroupRelationList.toString());
                    }
                } else {
                    for (Relation relation : new ComponentRelations(this.target)) {
                        Entity endpoint;
                        if (!relation.getId().equals((Object)TAG_GROUP_RELATION) || !((endpoint = relation.getEndpoint()) instanceof TagGroupInfo)) continue;
                        endpoint.getOrdToEntity().ifPresent(ord -> {
                            BOrd slotPathOrd = ord.get((BObject)this.target).asComponent().getSlotPathOrd();
                            TagGroupInfo tagGroup = (TagGroupInfo)endpoint;
                            this.directTags.add(SlotPath.escape((String)tagGroup.getGroupId().getQName()), (BValue)slotPathOrd, TAG_GROUP_FLAGS);
                            this.hasUnhiddenTag = true;
                        });
                    }
                }
                for (Tag tag : new ComponentTags(this.target)) {
                    Property property = this.target.getProperty(SlotPath.escape((String)tag.getId().getQName()));
                    int flags = this.target.getFlags((Slot)property);
                    if (property != null && property.isFrozen()) {
                        flags |= 0x10000000;
                    } else if ((flags & 4) == 0) {
                        this.hasUnhiddenTag = true;
                    }
                    if (this.directTags.get(SlotPath.escape((String)tag.getId().getQName())) != null) continue;
                    this.directTags.add(SlotPath.escape((String)tag.getId().getQName()), (BValue)tag.getValue(), flags);
                }
                for (Tag tag : new ImpliedTags(service, (Entity)this.target)) {
                    String tagName = SlotPath.escape((String)tag.getId().getQName());
                    if (this.directTags.get(tagName) != null) continue;
                    Property p = this.impliedTags.getProperty(tagName);
                    if (p == null) {
                        this.impliedTags.add(tagName, (BValue)tag.getValue(), 16385, null);
                        continue;
                    }
                    this.impliedTags.set(p, (BValue)tag.getValue());
                    this.impliedTags.setFlags((Slot)p, 16385);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doAdd() {
        ArrayList<TagInfo> selectedTags;
        boolean isAdHoc = true;
        ArrayList<TagGroupInfo> selectedTagGroups = this.getSelectedTagGroupInfos();
        if (selectedTagGroups.size() > 0) {
            isAdHoc = false;
            for (TagGroupInfo tagGroup : selectedTagGroups) {
                Optional ord;
                if (!(tagGroup instanceof Entity) || !(ord = ((Entity)tagGroup).getOrdToEntity()).isPresent()) continue;
                BOrd slotPathOrd = ((BOrd)ord.get()).get((BObject)this.target).asComponent().getSlotPathOrd();
                Property tgProp = this.directTags.add(SlotPath.escape((String)tagGroup.getGroupId().getQName()), (BValue)slotPathOrd, TAG_GROUP_FLAGS);
                this.directTags.setFacets((Slot)tgProp, TAG_GROUP_FACETS);
            }
        }
        if ((selectedTags = this.getSelectedTagInfos()).size() > 0) {
            isAdHoc = false;
            for (TagInfo tag : selectedTags) {
                String name = SlotPath.escape((String)tag.getTagId().getQName());
                if (this.directTags.get(name) != null) continue;
                this.directTags.add(name, (BValue)tag.getDefaultValue(), 16384);
                this.hasUnhiddenTag = true;
            }
        }
        if (isAdHoc) {
            String id;
            BTextField idTextField = new BTextField();
            BListDropDown typeDropDown = new BListDropDown();
            TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BIDataValue.TYPE.getTypeInfo());
            BList list = typeDropDown.getList();
            Arrays.stream(types).forEach(arg_0 -> ((BList)list).addItem(arg_0));
            typeDropDown.setSelectedItem((Object)BMarker.TYPE.getTypeInfo());
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(lex.getText("add.tag.tagId")));
            grid.add(null, (BValue)idTextField);
            grid.add(null, (BValue)new BLabel(lex.getText("add.tag.type")));
            grid.add(null, (BValue)typeDropDown);
            BBorderPane pane = new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0);
            while (true) {
                if (1 != BDialog.open((BWidget)this, (String)lex.getText("add.tag.title"), (Object)pane, (int)3, (BImage)addIcon)) {
                    return;
                }
                id = idTextField.getText();
                if (TagUtil.isValidTagId(id)) break;
                BDialog.error((BWidget)this, (String)lex.getText("add.tag.error.title"), (Object)lex.getText("add.tag.error.invalid.id", new Object[]{id}));
            }
            String[] split = id.split(":");
            String name = SlotPath.escape((String)(split[0].trim() + ':' + split[1]));
            if (this.directTags.get(name) != null) {
                return;
            }
            Object type = typeDropDown.getSelectedItem();
            try {
                BValue value = ((TypeInfo)type).getInstance().asValue();
                this.directTags.add(name, value, 16384);
                this.hasUnhiddenTag = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.directEditor.saveValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.directEditor.loadValue((BObject)this.directTags);
        this.doTagsModified();
        this.doUpdateCommands();
        this.mgr.clearSelectedObjects();
    }

    public void doRemove() {
        try {
            this.directEditor.saveValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Property[] properties = this.directTags.getPropertiesArray();
        BCheckBox[] deleteSelect = new BCheckBox[properties.length];
        int colCount = properties.length / 20;
        int gridSize = 2 * (1 + colCount);
        BEdgePane edgePane = new BEdgePane();
        BGridPane grid = new BGridPane(gridSize);
        for (int i = 0; i < properties.length; ++i) {
            deleteSelect[i] = new BCheckBox();
            if ((this.directTags.getFlags((Slot)properties[i]) & 0x10000004) != 0) continue;
            grid.add(null, (BValue)deleteSelect[i]);
            grid.add(null, (BValue)new BLabel(SlotPath.unescape((String)properties[i].getName())));
        }
        BCheckBox removeAll = new BCheckBox();
        if (properties.length == 1) {
            deleteSelect[0].setSelected(true);
        } else if (properties.length > 1) {
            BGridPane removePane = new BGridPane(2);
            removePane.add(null, (BValue)removeAll);
            removePane.add(null, (BValue)new BLabel("RemoveAll"));
            edgePane.setBottom((BWidget)removePane);
        }
        edgePane.setCenter((BWidget)grid);
        if (1 != BDialog.open((BWidget)this, (String)lex.getText("Remove"), (Object)edgePane, (int)3)) {
            return;
        }
        for (int i = 0; i < properties.length; ++i) {
            if (deleteSelect[i].getParent() == null || !removeAll.isSelected() && !deleteSelect[i].isSelected()) continue;
            this.directTags.remove(properties[i]);
        }
        this.directEditor.loadValue((BObject)this.directTags);
        properties = this.directTags.getPropertiesArray();
        this.hasUnhiddenTag = properties.length > 0;
        this.doTagsModified();
        this.doUpdateCommands();
    }

    public void doSave() {
        try {
            this.directEditor.saveValue();
        }
        catch (Exception e) {
            BDialog.error((BWidget)this.shell, (Object)e.getLocalizedMessage());
            return;
        }
        if (!this.isBatchEdit) {
            ComponentTags editedTags = new ComponentTags(this.directTags);
            ComponentTags existingTags = new ComponentTags(this.target);
            for (BRelation existingRelation : (BRelation[])this.target.getChildren(BRelation.class)) {
                TagGroupInfo tagGroupInfo;
                Entity endpoint;
                if (existingRelation instanceof BLink || !((endpoint = existingRelation.getEndpoint()) instanceof TagGroupInfo) || !(endpoint instanceof BComponent) || editedTags.contains((tagGroupInfo = (TagGroupInfo)endpoint).getGroupId())) continue;
                this.target.remove((BComplex)existingRelation);
            }
            Tags tags = this.target.tags();
            for (Property property : this.directTags.getProperties()) {
                String qName = SlotPath.unescape((String)property.getName());
                BValue bValue = this.directTags.get(property);
                if (BEditTagDialog.isTagGroupRelationTag(this.directTags, property)) {
                    BRelation tagGroupRelation = BEditTagDialog.makeTagGroupRelation(this.directTags, property);
                    if (tagGroupRelation == null || BEditTagDialog.hasRelation(tagGroupRelation, this.target)) continue;
                    this.target.add("r?", (BValue)tagGroupRelation, 1);
                    continue;
                }
                if (BEditTagDialog.isTagGroupTag(this.directTags, property)) {
                    CompUtil.setOrAdd((BComponent)this.target, (String)property.getName(), (BValue)bValue, (int)TAG_GROUP_TAG_FLAGS, (BFacets)TAG_GROUP_TAG_FACETS, null);
                    continue;
                }
                if (!qName.contains(":") || !(bValue instanceof BIDataValue)) continue;
                Id tagId = Id.newId((String)qName);
                if (tags.isMulti(tagId)) {
                    tags.addMulti(tagId, (BIDataValue)bValue);
                    continue;
                }
                tags.set(tagId, (BIDataValue)bValue);
            }
            for (Tag existingTag : existingTags) {
                if (editedTags.get(existingTag.getId()).isPresent()) continue;
                tags.remove(existingTag);
            }
        }
        this.results = 1;
        this.close();
    }

    public void doCancel() {
        this.results = 2;
        this.close();
    }

    public BComponent getDirectTags() {
        return this.directTags;
    }

    public int getResult() {
        return this.results;
    }

    public void doTagsModified() {
        this.tagManager.getController().tagSelectionChanged();
        this.btnSave.setEnabled(true);
    }

    public void doUpdateCommands() {
        BWidget selectedTab = this.tabbedPane.getSelectedPane();
        if (selectedTab.equals((Object)this.directEditor)) {
            this.btnAdd.setEnabled(true);
            this.btnRemove.setEnabled(this.hasUnhiddenTag);
        } else {
            this.btnAdd.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    private ArrayList<TagGroupInfo> getSelectedTagGroupInfos() {
        ArrayList<TagGroupInfo> tagGroupInfos = new ArrayList<TagGroupInfo>();
        for (Object selected : this.mgr.getSelectedObjects()) {
            if (!(selected instanceof TagGroupInfo)) continue;
            tagGroupInfos.add((TagGroupInfo)selected);
        }
        return tagGroupInfos;
    }

    private ArrayList<TagInfo> getSelectedTagInfos() {
        ArrayList<TagInfo> tagInfos = new ArrayList<TagInfo>();
        for (Object selTags : this.mgr.getSelectedObjects()) {
            if (!(selTags instanceof TagInfo)) continue;
            tagInfos.add((TagInfo)selTags);
        }
        return tagInfos;
    }

    private BPane buildButtonPane() {
        BFlowPane pane = new BFlowPane();
        pane.setAlign(BHalign.center);
        pane.add(null, (BValue)this.makeSaveButton());
        pane.add(null, (BValue)this.makeAddButton());
        pane.add(null, (BValue)this.makeRemoveButton());
        pane.add(null, (BValue)this.makeCancelButton());
        return pane;
    }

    protected BButton makeCancelButton() {
        BButton btnCancel = new BButton(new Command((BWidget)this, lex, "cancel"));
        this.linkTo((BComponent)btnCancel, (Slot)BButton.actionPerformed, (Slot)cancel);
        return btnCancel;
    }

    protected BButton makeAddButton() {
        this.btnAdd = new BButton(new Command((BWidget)this, lex, "command.add"));
        this.linkTo((BComponent)this.btnAdd, (Slot)BButton.actionPerformed, (Slot)add);
        this.btnAdd.setEnabled(false);
        return this.btnAdd;
    }

    protected BButton makeRemoveButton() {
        this.btnRemove = new BButton(new Command((BWidget)this, lex, "command.remove"));
        this.linkTo((BComponent)this.btnRemove, (Slot)BButton.actionPerformed, (Slot)remove);
        this.btnRemove.setEnabled(false);
        return this.btnRemove;
    }

    protected BButton makeSaveButton() {
        this.btnSave = new BButton(new Command((BWidget)this, lex, "bogFile.save"));
        this.linkTo((BComponent)this.btnSave, (Slot)BButton.actionPerformed, (Slot)save);
        this.btnSave.setEnabled(false);
        return this.btnSave;
    }

    public void close() {
        lastBounds = this.getScreenBounds();
        lastTagNamespace = this.tagDictionaryPane.getNamespace();
        lastSearch = this.tagDictionaryPane.getTagSearch();
        super.close();
    }

    private static boolean isTagGroupRelationTag(BComponent directTags, Property property) {
        BFacets slotFacets = directTags.getSlotFacets((Slot)property);
        return slotFacets.getb(TAG_GROUP_FACET, false);
    }

    private static boolean isTagGroupTag(BComponent directTags, Property property) {
        BFacets slotFacets = directTags.getSlotFacets((Slot)property);
        return slotFacets.getb(TAG_GROUP_TAG_FACET, false);
    }

    private static BRelation makeTagGroupRelation(BComponent directTags, Property property) {
        BValue value;
        if (BEditTagDialog.isTagGroupRelationTag(directTags, property) && (value = directTags.get(property)) instanceof BOrd) {
            return new BRelation(TAG_GROUP_RELATION, (BOrd)value);
        }
        return null;
    }

    private static boolean hasRelation(BRelation relation, BComponent component) {
        boolean hasRelation = false;
        for (BRelation existingRelation : (BRelation[])component.getChildren(BRelation.class)) {
            if (existingRelation instanceof BLink) continue;
            BObject existingEp = existingRelation.getEndpointOrd().resolve((BObject)component).get();
            BObject givenEp = relation.getEndpointOrd().resolve((BObject)component).get();
            if (!existingRelation.getId().equals((Object)relation.getId()) || !existingEp.equals((Object)givenEp)) continue;
            hasRelation = true;
            break;
        }
        return hasRelation;
    }

    static {
        logger = Logger.getLogger("tagdictionary");
    }
}

