/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.synthetic;

import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.synthetic.SyntheticModuleTypesAgentsTab;
import com.tridium.workbench.synthetic.SyntheticModuleTypesDetailsTab;
import com.tridium.workbench.synthetic.SyntheticModuleTypesEnumTab;
import com.tridium.workbench.synthetic.SyntheticModuleTypesSlotsTab;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.workbench.BWbPlugin;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class SyntheticModuleTypesTab {
    SyntheticModuleTypesAgentsTab agentsOnFE;
    SyntheticModuleTypesDetailsTab detailsFE;
    SyntheticModuleTypesSlotsTab slotsFE;
    SyntheticModuleTypesEnumTab enumFE;
    BSplitPane splitPane;
    BLabelPane slotLabelPane;
    BLabelPane enumLabelPane;
    BTabbedPane tabbedPane;
    BAbstractButton removeButton;
    BAbstractButton addButton;
    private String moduleName;
    private BWbPlugin parent;
    private BTable table;
    private BWidget content;
    private XElem root;

    public void setModified() {
        this.parent.setModified();
    }

    public SyntheticModuleTypesTab(BWbPlugin parent) {
        this.parent = parent;
        BBorderPane borderPane = new BBorderPane();
        borderPane.setPadding(BInsets.make((double)10.0, (double)10.0, (double)10.0, (double)10.0));
        this.splitPane = new BSplitPane(BOrientation.horizontal, 30.0);
        borderPane.setContent((BWidget)this.splitPane);
        BEdgePane edgePane = new BEdgePane();
        this.splitPane.setWidget1((BWidget)edgePane);
        this.table = new BTable((TableModel)new Model());
        this.table.setLayout(BLayout.FILL);
        this.table.setController((TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        edgePane.setCenter((BWidget)this.table);
        BBorderPane buttonBorder = new BBorderPane();
        buttonBorder.setPadding(BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        edgePane.setBottom((BWidget)buttonBorder);
        BGridPane buttonGrid = new BGridPane(2);
        buttonGrid.setColumnGap(10.0);
        this.addButton = BButton.make((Command)new AddCommand(parent));
        buttonGrid.add(null, (BValue)this.addButton);
        this.removeButton = BButton.make((Command)new RemoveCommand(parent));
        buttonGrid.add(null, (BValue)this.removeButton);
        buttonBorder.setContent((BWidget)buttonGrid);
        this.tabbedPane = new BTabbedPane();
        this.splitPane.setWidget2((BWidget)new BNullWidget());
        this.detailsFE = new SyntheticModuleTypesDetailsTab(parent);
        this.tabbedPane.addPane(new BLabelPane(new BLabel("Details"), this.detailsFE.getContent()));
        this.slotsFE = new SyntheticModuleTypesSlotsTab(parent);
        this.slotLabelPane = new BLabelPane(new BLabel("Slots"), this.slotsFE.getContent());
        this.tabbedPane.addPane(this.slotLabelPane);
        this.enumFE = new SyntheticModuleTypesEnumTab(parent);
        this.enumLabelPane = new BLabelPane(new BLabel("Enum"), this.enumFE.getContent());
        this.tabbedPane.addPane(this.enumLabelPane);
        this.agentsOnFE = new SyntheticModuleTypesAgentsTab(parent);
        this.tabbedPane.addPane(new BLabelPane(new BLabel("Agents On"), this.agentsOnFE.getContent()));
        this.content = borderPane;
    }

    public void loadValue(XElem root, String moduleName, Context cx) {
        this.root = root;
        this.moduleName = moduleName;
        XElem[] typesXml = root.elem("types").elems("type");
        if (typesXml.length > 0) {
            this.splitPane.setWidget2((BWidget)this.tabbedPane);
            this.table.getSelection().select(0);
        } else {
            this.splitPane.setWidget2((BWidget)new BNullWidget());
        }
    }

    public void saveValue(Context cx) {
        this.detailsFE.saveValue(cx);
        if (this.table.getModel().getRowCount() > 0) {
            XElem typesElem = this.root.elem("types");
            if (typesElem == null) {
                typesElem = new XElem("types");
                this.root.addContent((XContent)typesElem);
            }
            if (this.table.getSelection().getRow() == -1 || this.table.getSelection().getRow() >= typesElem.elems("type").length) {
                return;
            }
            XElem xElem = typesElem.elems("type")[this.table.getSelection().getRow()];
        }
    }

    public BWidget getContent() {
        return this.content;
    }

    public void updateTabs() {
        int selected = this.table.getSelection().getRow();
        if (selected == -1) {
            return;
        }
        try {
            if (this.detailsFE.superTypeFE.saveValue().equals((Object)BFrozenEnum.TYPE.getTypeSpec())) {
                this.enumLabelPane.setVisible(true);
                if (this.tabbedPane.getSelectedLabelPane() == this.slotLabelPane) {
                    this.tabbedPane.selectLabelPane(this.enumLabelPane);
                }
                this.slotLabelPane.setVisible(false);
            } else {
                this.slotLabelPane.setVisible(true);
                if (this.tabbedPane.getSelectedLabelPane() == this.enumLabelPane) {
                    this.tabbedPane.selectLabelPane(this.slotLabelPane);
                }
                this.enumLabelPane.setVisible(false);
            }
        }
        catch (Exception e) {
            this.slotLabelPane.setVisible(true);
            if (this.tabbedPane.getSelectedLabelPane() == this.enumLabelPane) {
                this.tabbedPane.selectLabelPane(this.slotLabelPane);
            }
            this.enumLabelPane.setVisible(false);
        }
    }

    private class Model
    extends TableModel {
        private Model() {
        }

        public int getRowCount() {
            return SyntheticModuleTypesTab.this.root.elem("types").elems("type").length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Type";
            }
            return "???";
        }

        public Object getSubject(int row) {
            return SyntheticModuleTypesTab.this.root.elem("types").elems("type")[row];
        }

        public Object getValueAt(int row, int col) {
            XElem dep = SyntheticModuleTypesTab.this.root.elem("types").elems("type")[row];
            switch (col) {
                case 0: {
                    return dep.get("name");
                }
            }
            return "???";
        }

        public BImage getRowIcon(int row) {
            XElem typeElem = SyntheticModuleTypesTab.this.root.elem("types").elems("type")[row];
            if (typeElem.getb("abstract", false)) {
                return BImage.make((BIcon)BIcon.std((String)"shapes/diamondGray.png"));
            }
            return BImage.make((BIcon)BIcon.std((String)"shapes/squareGray.png"));
        }

        public boolean isColumnSortable(int col) {
            return false;
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected BMenu makePopup(TableSubject subject) {
            BMenu menu = new BMenu();
            menu.add("add", SyntheticModuleTypesTab.this.addButton.getCommand());
            if (subject.getRows().length > 0) {
                menu.add("remove", SyntheticModuleTypesTab.this.removeButton.getCommand());
            }
            return menu;
        }

        public int getTextSearchColumn() {
            return 0;
        }
    }

    private class Selection
    extends TableSelection {
        private Selection() {
        }

        public void select(int row) {
            this.select(row, true);
        }

        public void select(int row, boolean clear) {
            super.select(row, true);
            this.select(SyntheticModuleTypesTab.this.root.elem("types").elems("type")[row]);
        }

        public void select(int anchor, int lead, boolean clear) {
            super.select(lead, lead, true);
            this.select(SyntheticModuleTypesTab.this.root.elem("types").elems("type")[lead]);
        }

        public void select(int[] rows) {
            super.select(rows[0], true);
            this.select(SyntheticModuleTypesTab.this.root.elem("types").elems("type")[rows[0]]);
        }

        public void deselect(int row) {
        }

        public void deselectAll() {
        }

        public void select(XElem elem) {
            SyntheticModuleTypesTab.this.tabbedPane.setEnabled(!this.isEmpty());
            SyntheticModuleTypesTab.this.detailsFE.loadValue(elem, SyntheticModuleTypesTab.this.root, null);
            SyntheticModuleTypesTab.this.slotsFE.loadValue(elem, SyntheticModuleTypesTab.this.root, null);
            SyntheticModuleTypesTab.this.agentsOnFE.loadValue(elem, SyntheticModuleTypesTab.this.root, null);
            SyntheticModuleTypesTab.this.enumFE.loadValue(elem, null);
            SyntheticModuleTypesTab.this.splitPane.setWidget2((BWidget)SyntheticModuleTypesTab.this.tabbedPane);
            SyntheticModuleTypesTab.this.content.relayout();
            try {
                if (Sys.getType(Class.forName(elem.get("extends"))).is(BFrozenEnum.TYPE)) {
                    SyntheticModuleTypesTab.this.enumLabelPane.setVisible(true);
                    if (SyntheticModuleTypesTab.this.tabbedPane.getSelectedLabelPane() == SyntheticModuleTypesTab.this.slotLabelPane) {
                        SyntheticModuleTypesTab.this.tabbedPane.selectLabelPane(SyntheticModuleTypesTab.this.enumLabelPane);
                    }
                    SyntheticModuleTypesTab.this.slotLabelPane.setVisible(false);
                } else {
                    SyntheticModuleTypesTab.this.slotLabelPane.setVisible(true);
                    if (SyntheticModuleTypesTab.this.tabbedPane.getSelectedLabelPane() == SyntheticModuleTypesTab.this.enumLabelPane) {
                        SyntheticModuleTypesTab.this.tabbedPane.selectLabelPane(SyntheticModuleTypesTab.this.slotLabelPane);
                    }
                    SyntheticModuleTypesTab.this.enumLabelPane.setVisible(false);
                }
            }
            catch (ClassNotFoundException e) {
                SyntheticModuleTypesTab.this.slotLabelPane.setVisible(true);
                if (SyntheticModuleTypesTab.this.tabbedPane.getSelectedLabelPane() == SyntheticModuleTypesTab.this.enumLabelPane) {
                    SyntheticModuleTypesTab.this.tabbedPane.selectLabelPane(SyntheticModuleTypesTab.this.slotLabelPane);
                }
                SyntheticModuleTypesTab.this.enumLabelPane.setVisible(false);
            }
        }
    }

    private class AddCommand
    extends Command {
        public AddCommand(BWidget parent) {
            super(parent, "Add");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"add.png"));
        }

        public CommandArtifact doInvoke() throws Exception {
            String typeName = BOptionDialog.prompt((BWidget)this.getShell(), (String)this.getLabel(), (String)"", (int)3);
            if (typeName != null && typeName.length() > 0) {
                XElem typeElem = SyntheticModuleTypesTab.this.root.elem("types");
                if (typeElem != null) {
                    XElem[] types = typeElem.elems("type");
                    for (int i = 0; i < types.length; ++i) {
                        if (!typeName.equalsIgnoreCase(types[i].get("name"))) continue;
                        throw new BajaException("Duplicate type name.");
                    }
                }
                typeName = TextUtil.capitalize((String)typeName);
                XElem newType = new XElem("type");
                newType.addAttr("name", typeName);
                newType.addAttr("class", "synth." + SyntheticModuleTypesTab.this.moduleName + ".B" + typeName);
                newType.addAttr("extends", "javax.baja.sys.BComponent");
                newType.addContent((XContent)new XElem("slots"));
                SyntheticModuleTypesTab.this.root.elem("types").addContent((XContent)newType);
                SyntheticModuleTypesTab.this.table.getModel().updateTable();
                ((BWbPlugin)this.getOwner()).setModified();
                SyntheticModuleTypesTab.this.splitPane.setWidget2((BWidget)SyntheticModuleTypesTab.this.tabbedPane);
                SyntheticModuleTypesTab.this.table.getSelection().select(SyntheticModuleTypesTab.this.table.getModel().getRowCount() - 1);
            }
            return null;
        }
    }

    private class RemoveCommand
    extends Command {
        public RemoveCommand(BWidget parent) {
            super(parent, "Remove");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"delete.png"));
        }

        public boolean isEnabled() {
            return SyntheticModuleTypesTab.this.table.getModel().getRowCount() > 0;
        }

        public CommandArtifact doInvoke() throws Exception {
            int selected = SyntheticModuleTypesTab.this.table.getSelection().getRow();
            if (selected == -1 || SyntheticModuleTypesTab.this.table.getModel().getRowCount() == 0) {
                return null;
            }
            String prompt = "Remove type " + SyntheticModuleTypesTab.this.root.elem("types").elems()[selected].get("name") + "?";
            int result = BOptionDialog.confirm((BWidget)this.getShell(), (String)this.getLabel(), (Object)prompt, (int)3);
            if (result == 1) {
                SyntheticModuleTypesTab.this.root.elem("types").removeContent(selected);
                ((BWbPlugin)this.getOwner()).setModified();
            }
            if (selected != -1) {
                if (selected < SyntheticModuleTypesTab.this.table.getModel().getRowCount()) {
                    SyntheticModuleTypesTab.this.table.getSelection().select(selected);
                } else if (SyntheticModuleTypesTab.this.table.getModel().getRowCount() > 0) {
                    SyntheticModuleTypesTab.this.table.getSelection().select(SyntheticModuleTypesTab.this.table.getModel().getRowCount() - 1);
                } else {
                    SyntheticModuleTypesTab.this.splitPane.setWidget2((BWidget)new BNullWidget());
                }
            }
            SyntheticModuleTypesTab.this.splitPane.relayout();
            return null;
        }
    }
}

