/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.slotsheet;

import com.tridium.sys.module.BTypeNavNode;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.slotsheet.BSlotSheet;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"baja:TypeNavNode"})})
public class BTypeSlotSheet
extends BWbView {
    @Generated
    public static final Type TYPE = Sys.loadType(BTypeSlotSheet.class);
    static BFont overrideFont = BFont.make((String)Theme.table().getCellFont().getName(), (double)Theme.table().getCellFont().getSize(), (int)1);
    final UiLexicon lex = UiLexicon.bajaui();
    final String lexProperty = this.lex.getText("slotsheet.property");
    final String lexAction = this.lex.getText("slotsheet.action");
    final String lexTopic = this.lex.getText("slotsheet.topic");
    final String lexFrozen = this.lex.getText("slotsheet.frozen");
    final String lexDynamic = this.lex.getText("slotsheet.dynamic");
    final String lexSlot = this.lex.getText("slotsheet.slot");
    final String lexIndex = this.lex.getText("slotsheet.index");
    final String lexName = this.lex.getText("slotsheet.name");
    final String lexDisplayName = this.lex.getText("slotsheet.displayName");
    final String lexDefinition = this.lex.getText("slotsheet.definition");
    final String lexFlags = this.lex.getText("slotsheet.flags");
    final String lexType = this.lex.getText("slotsheet.type");
    final String lexFacets = this.lex.getText("slotsheet.facets");
    final String lexNameMap = this.lex.getText("slotsheet.nameMap");
    Model model = new Model();
    BTable table;
    SlotEntry[] slots = new SlotEntry[0];
    BNameMap displayNames = null;
    String name;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTypeSlotSheet() {
        this.table = new BTable((TableModel)this.model);
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setSelection((TableSelection)new Selection());
        this.setContent((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT));
    }

    @Override
    public void doLoadValue(BObject value, Context cx) {
        BTypeNavNode node = (BTypeNavNode)value;
        this.name = node.getNavName();
        this.updateModels(node.getSlots());
    }

    @Override
    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        return value;
    }

    public Slot[] getSelectedSlots() {
        int[] rows = this.table.getSelection().getRows();
        Slot[] selected = new Slot[rows.length];
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = this.slots[rows[i]].slot;
        }
        return selected;
    }

    public SlotEntry[] getSelectedEntries() {
        int[] rows = this.table.getSelection().getRows();
        SlotEntry[] selected = new SlotEntry[rows.length];
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = this.slots[rows[i]];
        }
        return selected;
    }

    void updateModels(Slot[] s) {
        SlotEntry[] slots = new SlotEntry[s.length];
        BNameMap displayNames = null;
        for (int i = 0; i < s.length; ++i) {
            Property prop;
            BValue val;
            Slot slot = s[i];
            String name = slot.getName();
            slots[i] = new SlotEntry(i, slot);
            if (!slot.isProperty() || !name.equals("displayNames") || !((val = (prop = slot.asProperty()).getDefaultValue()) instanceof BNameMap)) continue;
            displayNames = (BNameMap)val;
        }
        this.table.relayout();
        this.slots = slots;
        this.displayNames = displayNames;
    }

    class SlotEntry {
        String summary;
        int index;
        BImage icon;
        Slot slot;
        String definition;
        int flags;
        String type;
        String facetsString;

        SlotEntry(int index, Slot slot) {
            this.slot = slot;
            this.index = index;
            this.flags = slot.getDefaultFlags();
            this.facetsString = slot.getFacets().toString();
            String string = this.definition = slot.isFrozen() ? BTypeSlotSheet.this.lexFrozen : BTypeSlotSheet.this.lexDynamic;
            if (slot.isAction()) {
                this.summary = BTypeSlotSheet.this.lexAction;
                this.icon = BSlotSheet.actionIcon;
                this.type = this.typestr(slot.asAction().getReturnType()) + " (" + this.typestr(slot.asAction().getParameterType()) + ")";
            } else if (slot.isTopic()) {
                this.summary = BTypeSlotSheet.this.lexTopic;
                this.icon = BSlotSheet.topicIcon;
                this.type = this.typestr(slot.asTopic().getEventType());
            } else {
                this.summary = BTypeSlotSheet.this.lexProperty;
                this.icon = BSlotSheet.propertyIcon;
                this.type = slot.isFrozen() ? this.typestr(slot.asProperty().getType()) : slot.getDeclaringType().toString();
            }
        }

        boolean isDisplayNameOverridden() {
            return BTypeSlotSheet.this.displayNames != null && BTypeSlotSheet.this.displayNames.get(this.slot.getName()) != null;
        }

        String toDisplayName() {
            BFormat format;
            if (BTypeSlotSheet.this.displayNames != null && (format = BTypeSlotSheet.this.displayNames.get(this.slot.getName())) != null) {
                return format.getFormat();
            }
            return this.slot.getDefaultDisplayName(null);
        }

        String typestr(Type type) {
            if (type == null) {
                return "void";
            }
            return type.toString();
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BTypeSlotSheet.this.slots.length;
        }

        public int getColumnCount() {
            return 8;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return BTypeSlotSheet.this.lexSlot;
            }
            if (col == 1) {
                return BTypeSlotSheet.this.lexIndex;
            }
            if (col == 2) {
                return BTypeSlotSheet.this.lexName;
            }
            if (col == 3) {
                return BTypeSlotSheet.this.lexDisplayName;
            }
            if (col == 4) {
                return BTypeSlotSheet.this.lexDefinition;
            }
            if (col == 5) {
                return BTypeSlotSheet.this.lexFlags;
            }
            if (col == 6) {
                return BTypeSlotSheet.this.lexType;
            }
            if (col == 7) {
                return BTypeSlotSheet.this.lexFacets;
            }
            return "???";
        }

        public Object getSubject(int row) {
            return BTypeSlotSheet.this.slots[row];
        }

        public Object getValueAt(int row, int col) {
            SlotEntry se = BTypeSlotSheet.this.slots[row];
            if (col == 0) {
                return se.summary;
            }
            if (col == 1) {
                return String.valueOf(se.index);
            }
            if (col == 2) {
                return se.slot.getName();
            }
            if (col == 3) {
                return se.toDisplayName();
            }
            if (col == 4) {
                return se.definition;
            }
            if (col == 5) {
                return Flags.encodeToString((int)se.flags);
            }
            if (col == 6) {
                return se.type;
            }
            if (col == 7) {
                return se.facetsString;
            }
            return "???";
        }

        public BImage getRowIcon(int row) {
            return BTypeSlotSheet.this.slots[row].icon;
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            Object[] keys = new Object[BTypeSlotSheet.this.slots.length];
            block3: for (int i = 0; i < keys.length; ++i) {
                switch (col) {
                    case 1: {
                        keys[i] = BTypeSlotSheet.this.slots[i].index;
                        continue block3;
                    }
                    default: {
                        keys[i] = this.getValueAt(i, col).toString();
                    }
                }
            }
            SortUtil.sort((Object[])keys, (Object[])BTypeSlotSheet.this.slots, (boolean)ascending);
        }
    }

    class Renderer
    extends TableCellRenderer {
        Renderer() {
        }

        public BFont getFont(TableCellRenderer.Cell cell) {
            SlotEntry se;
            if (cell.column == 3 && (se = BTypeSlotSheet.this.slots[cell.row]).isDisplayNameOverridden()) {
                return overrideFont;
            }
            return super.getFont(cell);
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
        }
    }
}

