/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.propsheet.BPropertySheet;
import com.tridium.workbench.shell.WbOptionsManager;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;

@NiagaraType
public class BOptionsEditor
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BOptionsEditor.class);
    HashMap<Node, BWbEditor> hash = new HashMap();
    BTree tree;
    BLabel label;
    BBorderPane current;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static void openInDialog(BWbShell shell) {
        BOptionsEditor options = new BOptionsEditor(shell);
        if (1 == BDialog.open((BWidget)shell, (String)"Options", (Object)((Object)options), (int)3)) {
            options.saveAll();
        }
    }

    public BOptionsEditor() {
        throw new IllegalStateException();
    }

    public BOptionsEditor(BWbShell shell) {
        this.tree = new BTree((TreeModel)new Model(shell));
        this.tree.setSelection((TreeSelection)new Selection());
        this.label = new BLabel("", BHalign.left);
        this.label.setForeground(BColor.white.toBrush());
        this.label.setFont(Theme.widget().getLargeBoldFont());
        BBorderPane a = new BBorderPane((BWidget)this.label, BBorder.make((double)1.0, (int)1, (BBrush)BColor.black.toBrush()), BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0));
        a.setFill(Theme.widget().getControlShadow());
        BBorderPane b = new BBorderPane((BWidget)a, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        b.setMargin(BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0));
        this.current = new BBorderPane((BWidget)new BNullWidget(), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)b);
        edge.setCenter((BWidget)this.current);
        BSplitPane split = new BSplitPane();
        split.setDividerPosition(25.0);
        split.setWidget1((BWidget)new BBorderPane((BWidget)new BTreePane(this.tree), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        split.setWidget2((BWidget)edge);
        this.setCenter((BWidget)split);
        if (this.tree.getModel().getRootCount() > 0) {
            this.tree.getSelection().select(this.tree.getModel().getRoot(0));
        }
    }

    public void computePreferredSize() {
        this.setPreferredSize(700.0, 450.0);
    }

    private void saveAll() {
        Iterator<Node> iter = this.hash.keySet().iterator();
        while (iter.hasNext()) {
            try {
                BWbEditor editor = this.hash.get((Object)iter.next());
                if (editor == null) continue;
                editor.saveValue();
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (String)"Error", (Object)"Failed to save options", (Throwable)e);
                return;
            }
        }
    }

    class Node
    extends TreeNode {
        TypeInfo type;
        String text;
        BImage icon;

        public Node(TreeModel model, TypeInfo type) {
            super(model);
            this.type = type;
            this.text = type.getDisplayName(null);
            this.icon = BImage.make((BIcon)type.getIcon(null));
        }

        public Object getSubject() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        public BImage getIcon() {
            return this.icon;
        }

        public boolean hasChildren() {
            return false;
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChild(int index) {
            return null;
        }

        BOptions getInstance() {
            return BOptions.getOptionsManager().load(this.type);
        }
    }

    class Model
    extends TreeModel {
        Node[] roots;

        public Model(BWbShell shell) {
            TypeInfo[] types = WbOptionsManager.getAllUserOptions(shell);
            this.roots = new Node[types.length];
            for (int i = 0; i < types.length; ++i) {
                this.roots[i] = new Node(this, types[i]);
            }
        }

        public int getRootCount() {
            return this.roots.length;
        }

        public TreeNode getRoot(int index) {
            return this.roots[index];
        }
    }

    class Selection
    extends TreeSelection {
        Selection() {
        }

        public void updateTree() {
            super.updateTree();
            Node node = (Node)this.getNode();
            if (node == null) {
                return;
            }
            BWbEditor editor = BOptionsEditor.this.hash.get((Object)node);
            if (editor == null) {
                editor = new BPropertySheet();
                editor.loadValue((BObject)node.getInstance());
                BOptionsEditor.this.hash.put(node, editor);
            }
            BOptionsEditor.this.label.setText(node.text);
            BOptionsEditor.this.current.setContent((BWidget)editor);
            BOptionsEditor.this.current.relayout();
        }
    }
}

