/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.nre.util.SystemPropertiesUtil;
import com.tridium.sys.Nre;
import com.tridium.ui.theme.custom.nss.NSSUtils;
import com.tridium.util.CustomThemeModuleManager;
import com.tridium.util.TimeFormat;
import com.tridium.workbench.shell.BFontSize;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Properties;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BUserOptions;
import javax.baja.units.BUnitConversion;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="timeFormat", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, \"workbench:TimeFormatFE\")")}), @NiagaraProperty(name="unitConversion", type="BUnitConversion", defaultValue="BUnitConversion.none"), @NiagaraProperty(name="autoLogoffEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="autoLogoffPeriod", type="BRelTime", defaultValue="BRelTime.make(15L*60L*1000L)"), @NiagaraProperty(name="promptForNameOnInsert", type="boolean", defaultValue="true"), @NiagaraProperty(name="useAntiAlias", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="fontSize", type="BFontSize", defaultValue="BFontSize.normal"), @NiagaraProperty(name="activeTheme", type="BDynamicEnum", defaultValue="BDynamicEnum.DEFAULT"), @NiagaraProperty(name="allowUserCredentialCaching", type="boolean", defaultValue="true"), @NiagaraProperty(name="locale", type="String", defaultValue="Locale.getDefault().toString()", flags=2, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.FIELD_WIDTH }, new BInteger[] { BInteger.make(2), BInteger.make(8) })")}), @NiagaraProperty(name="isDefaultConnectionTypeSsl", type="boolean", defaultValue="true", flags=4)})
public class BGeneralOptions
extends BUserOptions {
    @Generated
    public static final Property timeFormat = BGeneralOptions.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:TimeFormatFE"));
    @Generated
    public static final Property unitConversion = BGeneralOptions.newProperty((int)0, (BValue)BUnitConversion.none, null);
    @Generated
    public static final Property autoLogoffEnabled = BGeneralOptions.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property autoLogoffPeriod = BGeneralOptions.newProperty((int)0, (BValue)BRelTime.make((long)900000L), null);
    @Generated
    public static final Property promptForNameOnInsert = BGeneralOptions.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property useAntiAlias = BGeneralOptions.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property fontSize = BGeneralOptions.newProperty((int)0, (BValue)BFontSize.normal, null);
    @Generated
    public static final Property activeTheme = BGeneralOptions.newProperty((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    @Generated
    public static final Property allowUserCredentialCaching = BGeneralOptions.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property locale = BGeneralOptions.newProperty((int)2, (String)Locale.getDefault().toString(), (BFacets)BFacets.make((String[])new String[]{"min", "fieldWidth"}, (BIDataValue[])new BInteger[]{BInteger.make((int)2), BInteger.make((int)8)}));
    @Generated
    public static final Property isDefaultConnectionTypeSsl = BGeneralOptions.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BGeneralOptions.class);
    private static BGeneralOptions options;
    private static String brandThemeDefault;
    private static boolean brandThemeLocked;

    @Generated
    public String getTimeFormat() {
        return this.getString(timeFormat);
    }

    @Generated
    public void setTimeFormat(String v) {
        this.setString(timeFormat, v, null);
    }

    @Generated
    public BUnitConversion getUnitConversion() {
        return (BUnitConversion)this.get(unitConversion);
    }

    @Generated
    public void setUnitConversion(BUnitConversion v) {
        this.set(unitConversion, (BValue)v, null);
    }

    @Generated
    public boolean getAutoLogoffEnabled() {
        return this.getBoolean(autoLogoffEnabled);
    }

    @Generated
    public void setAutoLogoffEnabled(boolean v) {
        this.setBoolean(autoLogoffEnabled, v, null);
    }

    @Generated
    public BRelTime getAutoLogoffPeriod() {
        return (BRelTime)this.get(autoLogoffPeriod);
    }

    @Generated
    public void setAutoLogoffPeriod(BRelTime v) {
        this.set(autoLogoffPeriod, (BValue)v, null);
    }

    @Generated
    public boolean getPromptForNameOnInsert() {
        return this.getBoolean(promptForNameOnInsert);
    }

    @Generated
    public void setPromptForNameOnInsert(boolean v) {
        this.setBoolean(promptForNameOnInsert, v, null);
    }

    @Generated
    public boolean getUseAntiAlias() {
        return this.getBoolean(useAntiAlias);
    }

    @Generated
    public void setUseAntiAlias(boolean v) {
        this.setBoolean(useAntiAlias, v, null);
    }

    @Generated
    public BFontSize getFontSize() {
        return (BFontSize)this.get(fontSize);
    }

    @Generated
    public void setFontSize(BFontSize v) {
        this.set(fontSize, (BValue)v, null);
    }

    @Generated
    public BDynamicEnum getActiveTheme() {
        return (BDynamicEnum)this.get(activeTheme);
    }

    @Generated
    public void setActiveTheme(BDynamicEnum v) {
        this.set(activeTheme, (BValue)v, null);
    }

    @Generated
    public boolean getAllowUserCredentialCaching() {
        return this.getBoolean(allowUserCredentialCaching);
    }

    @Generated
    public void setAllowUserCredentialCaching(boolean v) {
        this.setBoolean(allowUserCredentialCaching, v, null);
    }

    @Generated
    public String getLocale() {
        return this.getString(locale);
    }

    @Generated
    public void setLocale(String v) {
        this.setString(locale, v, null);
    }

    @Generated
    public boolean getIsDefaultConnectionTypeSsl() {
        return this.getBoolean(isDefaultConnectionTypeSsl);
    }

    @Generated
    public void setIsDefaultConnectionTypeSsl(boolean v) {
        this.setBoolean(isDefaultConnectionTypeSsl, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BGeneralOptions make() {
        if (options == null) {
            BGeneralOptions.loadBrand();
            options = (BGeneralOptions)BGeneralOptions.load((Type)TYPE);
            NSSUtils.setIncreaseFontSize((options.getFontSize() == BFontSize.large ? 1 : 0) != 0);
            BDynamicEnum activeTheme = options.getActiveTheme();
            String tag = activeTheme.getTag();
            Slot slot = options.getSlot("activeTheme");
            int flags = options.getFlags(slot);
            if (brandThemeLocked) {
                options.setFlags(slot, flags | 4);
                if (brandThemeDefault != null) {
                    tag = brandThemeDefault;
                }
            } else {
                boolean noneSelected;
                options.setFlags(slot, flags & 0xFFFFFFFB);
                boolean bl = noneSelected = tag == null || tag.equals("0") && activeTheme.getRange().isNull();
                if (brandThemeDefault != null && noneSelected) {
                    tag = brandThemeDefault;
                }
            }
            options.setActiveTheme(CustomThemeModuleManager.getModuleEnumForTag((String)tag));
        }
        return options;
    }

    private static void loadBrand() {
        final File f = new File(Nre.getNiagaraHome(), "etc" + File.separator + "brand.properties");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Properties props = new Properties();
                    try (FileInputStream in = new FileInputStream(f);){
                        props.load(in);
                    }
                    brandThemeDefault = props.getProperty("workbench.theme.default", "Zebra");
                    brandThemeLocked = "true".equals(props.getProperty("workbench.theme.locked"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        this.apply();
    }

    public void initFromUserFacets(BFacets facets) {
        int unitConv;
        String timeFormat = facets.gets("timeFormat", null);
        if (timeFormat != null) {
            this.setTimeFormat(timeFormat);
        }
        if ((unitConv = facets.geti("unitConversion", -1)) != -1) {
            this.setUnitConversion(BUnitConversion.make((int)unitConv));
        }
    }

    public void apply() {
        TimeFormat.setDefaultPattern((String)this.getTimeFormat());
        Nre.unitConversion = this.getUnitConversion().getOrdinal();
        if (!this.getLocale().equalsIgnoreCase(Locale.getDefault().toString())) {
            AccessController.doPrivileged(() -> SystemPropertiesUtil.setSystemProperty((String)"niagara.lang", (String)this.getLocale()));
        }
    }

    static {
        brandThemeLocked = false;
    }
}

