/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.service;

import com.tridium.workbench.service.BWbServiceManager;
import com.tridium.workbench.service.BWbServiceSpec;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"workbench:WbServiceManagerTool"})})
public class BWbServiceManagerView
extends BWbView {
    @Generated
    public static final Type TYPE = Sys.loadType(BWbServiceManagerView.class);
    static final int COL_SERVICE = 0;
    static final int COL_INSTALLED = 1;
    static final int COL_AUTO_START = 2;
    static final int COL_RUNNING = 3;
    final UiLexicon lex = UiLexicon.bajaui();
    final String LEX_SERVICE = this.lex.getText("serviceManager.service");
    final String LEX_INSTALLED = this.lex.getText("serviceManager.installed");
    final String LEX_AUTO_START = this.lex.getText("serviceManager.autoStart");
    final String LEX_RUNNING = this.lex.getText("serviceManager.running");
    final String LEX_TITLE = this.lex.getText("serviceManager.wbServiceManager");
    BTable table;
    Row[] rows = new Row[0];
    Command start;
    Command stop;
    ToggleCommand autoStart;
    boolean inUpdate;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWbServiceManagerView() {
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        this.table.setMultipleSelection(false);
        BGridPane buttons = new BGridPane(3);
        buttons.setValign(BValign.top);
        this.start = new Start(this);
        buttons.add(null, (BValue)new BButton(this.start));
        this.stop = new Stop(this);
        buttons.add(null, (BValue)new BButton(this.stop));
        this.autoStart = new AutoStart(this);
        buttons.add(null, (BValue)new BBorderPane((BWidget)new BCheckBox(this.autoStart), BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)10.0)));
        this.updateRows();
        this.table.sortByColumn(0, true);
        this.updateCommands();
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)BTitlePane.makePane((String)this.LEX_TITLE, (BTable)this.table));
        edge.setBottom((BWidget)new BBorderPane((BWidget)buttons, 10.0, 10.0, 0.0, 10.0));
        this.setContent((BWidget)edge);
    }

    public BWbServiceSpec getSelectedSpec() {
        int index = this.table.getSelection().getRow();
        if (index < 0) {
            return null;
        }
        return this.rows[index].spec;
    }

    public void updateCommands() {
        this.inUpdate = true;
        BWbServiceSpec spec = this.getSelectedSpec();
        if (spec != null && !spec.getInstalled()) {
            spec = null;
        }
        this.start.setEnabled(spec != null && !spec.getRunning());
        this.stop.setEnabled(spec != null && spec.getRunning());
        this.autoStart.setEnabled(spec != null);
        this.autoStart.setSelected(spec != null && spec.getAutoStart());
        this.inUpdate = false;
    }

    public void updateRows() {
        BWbServiceSpec[] specs = BWbServiceManager.make().getSpecs();
        this.rows = new Row[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            this.rows[i] = new Row(specs[i]);
        }
        this.repaint();
    }

    public void open() {
        BWbServiceSpec spec = this.getSelectedSpec();
        if (spec != null && spec.typeInfo != null) {
            this.getWbShell().hyperlink(BOrd.make((String)("workbench:/tools/" + spec.typeInfo)));
        }
    }

    static class Row {
        BWbServiceSpec spec;

        Row(BWbServiceSpec spec) {
            this.spec = spec;
        }

        public Object valueAt(int col) {
            switch (col) {
                case 0: {
                    return this.spec.getDisplayName(null);
                }
                case 1: {
                    return String.valueOf(this.spec.getInstalled());
                }
                case 2: {
                    return String.valueOf(this.spec.getAutoStart());
                }
                case 3: {
                    return String.valueOf(this.spec.getRunning());
                }
            }
            return "?";
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BWbServiceManagerView.this.rows.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BWbServiceManagerView.this.LEX_SERVICE;
                }
                case 1: {
                    return BWbServiceManagerView.this.LEX_INSTALLED;
                }
                case 2: {
                    return BWbServiceManagerView.this.LEX_AUTO_START;
                }
                case 3: {
                    return BWbServiceManagerView.this.LEX_RUNNING;
                }
            }
            return "?";
        }

        public Object getSubject(int row) {
            return BWbServiceManagerView.this.rows[row].spec;
        }

        public Object getValueAt(int row, int col) {
            return BWbServiceManagerView.this.rows[row].valueAt(col);
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            Object[] keys = new Object[BWbServiceManagerView.this.rows.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = BWbServiceManagerView.this.rows[i].valueAt(col);
            }
            SortUtil.sort((Object[])keys, (Object[])BWbServiceManagerView.this.rows, (boolean)ascending);
        }

        public BImage getRowIcon(int row) {
            return BWbServiceManagerView.this.rows[row].spec.getServiceIcon();
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyPressed(BKeyEvent event) {
            if (event.getKeyCode() == 10) {
                event.consume();
                BWbServiceManagerView.this.open();
            }
            super.keyPressed(event);
        }

        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            super.cellDoubleClicked(event, row, col);
            BWbServiceManagerView.this.open();
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BWbServiceManagerView.this.updateCommands();
        }
    }

    class AutoStart
    extends ToggleCommand {
        AutoStart(BWidget owner) {
            super(owner, BWbServiceManagerView.this.lex.module, "serviceManager.autoStart");
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            if (BWbServiceManagerView.this.inUpdate) {
                return;
            }
            BWbServiceSpec spec = BWbServiceManagerView.this.getSelectedSpec();
            if (spec != null) {
                spec.updateAutoStart(sel);
            }
            BWbServiceManagerView.this.updateRows();
            BWbServiceManagerView.this.updateCommands();
        }
    }

    class Stop
    extends Command {
        Stop(BWidget owner) {
            super(owner, BWbServiceManagerView.this.lex.module, "serviceManager.stop");
        }

        public CommandArtifact doInvoke() {
            BWbServiceManagerView.this.getSelectedSpec().stopService();
            BWbServiceManagerView.this.updateRows();
            BWbServiceManagerView.this.updateCommands();
            return null;
        }
    }

    class Start
    extends Command {
        Start(BWidget owner) {
            super(owner, BWbServiceManagerView.this.lex.module, "serviceManager.start");
        }

        public CommandArtifact doInvoke() {
            BWbServiceManagerView.this.getSelectedSpec().startService();
            BWbServiceManagerView.this.updateRows();
            BWbServiceManagerView.this.updateCommands();
            return null;
        }
    }
}

