/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.px;

import com.tridium.ui.px.PxPropertyComponentArray;
import com.tridium.ui.px.PxUtil;
import com.tridium.workbench.px.PxFileMigrationArguments;
import com.tridium.workbench.px.PxFileMigrator;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import javax.baja.file.types.text.BPxFile;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BScaleMode;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxEncoder;
import javax.baja.ui.px.PxProperty;

public class MobileRefreshPxFileMigrator
extends PxFileMigrator<MobileRefreshPxFileMigrator> {
    private double minScale = 0.5;
    private double maxScale = 1.0;
    private BScaleMode scaleMode = BScaleMode.fitRatio;
    private boolean processCanvasPanes;
    private boolean wrapInScrollPane;
    private PxDecoder decoder;
    private BWidget oldRoot;
    private BWidget newRoot;
    private static final String MIN_SCALE = "min-scale";
    private static final String MAX_SCALE = "max-scale";
    private static final String PROCESS_CANVAS_PANES = "process-canvas-panes";
    private static final String SCALE = "scale";
    private static final String WRAP_IN_SCROLL_PANE = "wrap-in-scroll-pane";

    public static void main(String ... args) {
        PxFileMigrationArguments migrationArgs = new PxFileMigrationArguments(args);
        migrationArgs.validateKnownOptions(PROCESS_CANVAS_PANES, WRAP_IN_SCROLL_PANE, MAX_SCALE, MIN_SCALE, SCALE);
        MobileRefreshPxFileMigrator migrator = MobileRefreshPxFileMigrator.make(migrationArgs);
        String rootFilePath = migrationArgs.getRootFilePath();
        String regex = migrationArgs.getRegex();
        MobileRefreshPxFileMigrator.migrateToResponsive(migrator, BOrd.make((String)rootFilePath), regex, null).exceptionally(e -> {
            LOG.log(Level.SEVERE, "Px file migration failed.", (Throwable)e);
            return null;
        });
    }

    public static CompletableFuture<Void> migrateToResponsive(MobileRefreshPxFileMigrator migrator, BOrd rootFilePath, String regex, Context cx) {
        return MobileRefreshPxFileMigrator.processAllAsync(migrator, rootFilePath, regex, cx);
    }

    public static MobileRefreshPxFileMigrator make(PxFileMigrationArguments args) {
        return ((MobileRefreshPxFileMigrator)((MobileRefreshPxFileMigrator)new MobileRefreshPxFileMigrator().inDryRunMode(args.isDryRun())).preservingIdentities(args.isPreserveIdentities())).processingCanvasPanes(args.hasOption(PROCESS_CANVAS_PANES)).wrappingInScrollPane(args.hasOption(WRAP_IN_SCROLL_PANE)).withMaxScale(Double.parseDouble(args.getOption(MAX_SCALE, "1.0"))).withMinScale(Double.parseDouble(args.getOption(MIN_SCALE, "1.0"))).withScaleMode(BScaleMode.make((String)args.getOption(SCALE, "fitRatio")));
    }

    @Override
    public boolean readyToPersist(BOrd pxOrd, InputStream in, Context cx) throws Exception {
        try {
            this.decoder = new PxDecoder(pxOrd, in);
            this.oldRoot = this.decoder.decodeDocument();
            this.newRoot = this.migrateRootWidget(pxOrd.isNull() ? null : (BPxFile)pxOrd.get(), this.oldRoot);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Cannot parse Px file " + pxOrd, e);
            return false;
        }
        return true;
    }

    @Override
    public void persist(OutputStream out, Context cx) throws Exception {
        PxProperty[] newProps = MobileRefreshPxFileMigrator.migrateProperties(this.oldRoot, this.newRoot, this.decoder.getPxProperties());
        TypeInfo media = this.decoder.getMedia();
        if (!this.dryRun) {
            new PxEncoder(out).setPreserveIdentities(this.preserveIdentities || newProps.length > 0).encodeDocumentWithMedia(this.newRoot, newProps, this.decoder.getPxLayers(), media == null ? null : media.getTypeSpec());
        }
    }

    public MobileRefreshPxFileMigrator withMinScale(double minScale) {
        this.minScale = minScale;
        return this;
    }

    public MobileRefreshPxFileMigrator withMaxScale(double maxScale) {
        this.maxScale = maxScale;
        return this;
    }

    public MobileRefreshPxFileMigrator withScaleMode(BScaleMode scaleMode) {
        this.scaleMode = scaleMode;
        return this;
    }

    public MobileRefreshPxFileMigrator processingCanvasPanes(boolean processCanvasPanes) {
        this.processCanvasPanes = processCanvasPanes;
        return this;
    }

    public MobileRefreshPxFileMigrator wrappingInScrollPane(boolean wrapInScrollPane) {
        this.wrapInScrollPane = wrapInScrollPane;
        return this;
    }

    public BWidget migrateRootWidget(BPxFile pxFile, BWidget rootWidget) {
        if ("mobile".equals(rootWidget.getType().getModule().getModuleName())) {
            this.logFine(pxFile, "Skip processing mobile");
            return rootWidget;
        }
        BWidget result = rootWidget;
        BWidget rootDrawable = MobileRefreshPxFileMigrator.withoutBorders(rootWidget);
        BCanvasPane canvasPane = MobileRefreshPxFileMigrator.getRootCanvasPane(rootDrawable);
        if (canvasPane == null) {
            this.logFine(pxFile, "No CanvasPane found");
            return result;
        }
        if (!(rootDrawable instanceof BScrollPane) && this.wrapInScrollPane) {
            this.logInfo(pxFile, "root widget of type " + rootWidget.getType() + " will be wrapped in bajaui:ScrollPane");
            if (!this.dryRun) {
                result = MobileRefreshPxFileMigrator.wrapInScrollPane(rootWidget);
            }
        }
        if (this.processCanvasPanes) {
            if (canvasPane.getMinScaleFactor() != this.minScale) {
                this.logInfo(pxFile, "CanvasPane will receive minScaleFactor of " + this.minScale);
                if (!this.dryRun) {
                    canvasPane.setMinScaleFactor(this.minScale);
                }
            }
            if (canvasPane.getMaxScaleFactor() != this.maxScale) {
                this.logInfo(pxFile, "CanvasPane will receive maxScaleFactor of " + this.maxScale);
                if (!this.dryRun) {
                    canvasPane.setMaxScaleFactor(this.maxScale);
                }
            }
            if (canvasPane.getScale() != this.scaleMode) {
                this.logInfo(pxFile, "CanvasPane will receive scale mode of " + this.scaleMode);
                if (!this.dryRun) {
                    canvasPane.setScale(this.scaleMode);
                }
            }
        }
        return result;
    }

    private static BCanvasPane getRootCanvasPane(BWidget widget) {
        if ((widget = MobileRefreshPxFileMigrator.withoutBorders(widget)) instanceof BScrollPane) {
            widget = ((BScrollPane)widget).getContent();
        }
        return (widget = MobileRefreshPxFileMigrator.withoutBorders(widget)) instanceof BCanvasPane ? (BCanvasPane)widget : null;
    }

    private static BWidget withoutBorders(BWidget widget) {
        while (widget instanceof BBorderPane) {
            widget = ((BBorderPane)widget).getContent();
        }
        return widget;
    }

    private static BScrollPane wrapInScrollPane(BWidget widget) {
        BScrollPane scrollPane = new BScrollPane();
        scrollPane.setContent(widget);
        return scrollPane;
    }

    private static PxProperty[] migrateProperties(BWidget oldRoot, BWidget newRoot, PxProperty[] props) {
        PxPropertyComponentArray propComps = new PxPropertyComponentArray();
        PxUtil.loadProperties((BWidget)oldRoot, (PxProperty[])props, (PxPropertyComponentArray)propComps);
        propComps.updateTargets(newRoot, props);
        return props;
    }
}

