/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav.commands;

import com.tridium.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFolder;
import javax.baja.nav.BNavRoot;
import javax.baja.space.Mark;
import javax.baja.sys.BObject;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;

public class MoveNavFolderCommand
extends Command {
    private BTree tree;
    private final BINavNode[] navNodes;
    private static boolean allowDialogs = true;

    public MoveNavFolderCommand(BWidget owner, BINavNode navNode) {
        this(owner, new BINavNode[]{navNode});
    }

    public MoveNavFolderCommand(BWidget owner, BINavNode[] navNodes) {
        super(owner, (Lexicon)UiLexicon.bajaui(), "commands.moveNavNode");
        this.navNodes = navNodes;
        MoveNavTreeModel model = new MoveNavTreeModel((BINavNode)BNavRoot.INSTANCE);
        this.tree = new BTree((TreeModel)model);
        this.tree.setMultipleSelection(false);
        this.tree.setExpanded(model.getRoot(0), true);
    }

    public CommandArtifact doInvoke() throws Exception {
        BScrollPane pane = new BScrollPane();
        BConstrainedPane constrained = new BConstrainedPane((BWidget)this.tree);
        constrained.setMinHeight(400.0);
        constrained.setMinWidth(300.0);
        pane.setContent((BWidget)constrained);
        int dialogResult = 1;
        if (allowDialogs) {
            dialogResult = BDialog.open((BWidget)this.getOwner(), (String)UiLexicon.bajaui().getText("commands.moveNavNode.title"), (Object)pane, (int)3);
        }
        if (dialogResult == 1) {
            BINavNode newParent = (BINavNode)this.tree.getSelection().getNodes()[0].getSubject();
            BObject[] objects = (BObject[])Arrays.copyOf(this.navNodes, this.navNodes.length, BObject[].class);
            Mark mark = new Mark(objects);
            mark.moveTo((BObject)newParent, null);
            this.getOwner().repaint();
        }
        return null;
    }

    public Command doMerge(Command c) {
        return new MoveNavFolderCommand(this.getOwner(), (BINavNode[])ArrayUtil.add((Object[])this.navNodes, (Object[])((MoveNavFolderCommand)c).navNodes));
    }

    static class MoveNavTreeNode
    extends NavTreeNode {
        public MoveNavTreeNode(NavTreeModel model, NavTreeNode parent, BINavNode navNode) {
            super(model, parent, navNode);
        }

        @Override
        protected NavTreeNode[] buildChildren() {
            NavTreeNode[] kids = super.buildChildren();
            ArrayList<NavTreeNode> list = new ArrayList<NavTreeNode>();
            for (NavTreeNode node : kids) {
                BINavNode target = node.getNavNode();
                if (!(target instanceof BNavFolder)) continue;
                list.add(node);
            }
            return list.toArray(new NavTreeNode[0]);
        }
    }

    public static class MoveNavTreeModel
    extends NavTreeModel {
        private final MoveNavTreeNode root;

        public MoveNavTreeModel(BINavNode rootNavNode) {
            this.root = new MoveNavTreeNode(this, null, rootNavNode);
        }

        @Override
        public NavTreeNode makeNavTreeNode(NavTreeNode parent, BINavNode navNode) {
            return new MoveNavTreeNode(this, parent, navNode);
        }

        public BINavNode getRootNavNode() {
            return this.root.getNavNode();
        }

        public int getRootCount() {
            return 1;
        }

        public TreeNode getRoot(int index) {
            return this.root;
        }
    }
}

