/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.util.ArrayUtil;
import com.tridium.workbench.nav.BHostMenuAgent;
import com.tridium.workbench.nav.BSessionMenuAgent;
import com.tridium.workbench.nav.commands.MoveNavFolderCommand;
import com.tridium.workbench.sidebars.BNavReorderPad;
import java.util.function.Supplier;
import javax.baja.naming.BHost;
import javax.baja.nav.BINavContainer;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.nav.BNavFolder;
import javax.baja.nav.BNavRoot;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.nav.menu.BNavMenuAgent;

@NiagaraType(agent={@AgentOn(types={"baja:NavFolder"})})
@NiagaraSingleton
public class BNavFolderMenuAgent
extends BNavMenuAgent {
    @Generated
    public static final BNavFolderMenuAgent INSTANCE = new BNavFolderMenuAgent();
    @Generated
    public static final Type TYPE = Sys.loadType(BNavFolderMenuAgent.class);
    public static final BModule module = TYPE.getModule();
    public static final UiLexicon lex = UiLexicon.bajaui();
    private static boolean allowDialogs = true;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BNavFolderMenuAgent() {
    }

    @Override
    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        return this.getDefaultFolderMenu(owner, (BNavFolder)target, cx);
    }

    BMenu getDefaultFolderMenu(BWidget owner, BNavFolder folder, Context cx) {
        BMenu menu = new BMenu();
        BHost[] hosts = BNavFolderMenuAgent.getHosts(new BINavContainer[]{folder});
        if (hosts.length > 0) {
            menu.add(null, (Command)new BHostMenuAgent.Disconnect(owner, hosts));
        }
        menu.add(null, (Command)new Close(owner, folder));
        menu.add(null, (BValue)new BSeparator());
        menu.add(null, (Command)new EditCommand(owner, folder));
        menu.add(null, (Command)new NewFolderCommand(owner, () -> folder));
        menu.add(null, (Command)new MoveNavFolderCommand(owner, (BINavNode)folder));
        if (folder.getNavChildren().length > 1) {
            menu.add(null, (Command)new ReorderCommand(owner, (BNavContainer)folder));
        }
        return menu;
    }

    public static BHost[] getHosts(BINavContainer[] containers) {
        Array hosts = new Array(BHost.class);
        for (BINavContainer container : containers) {
            BINavNode[] children;
            for (BINavNode child : children = ((BINavNode)container).getNavChildren()) {
                if (child instanceof BHost) {
                    hosts.add((Object)((BHost)child));
                }
                if (!(child instanceof BNavFolder)) continue;
                hosts.addAll((Object[])BNavFolderMenuAgent.getHosts(new BINavContainer[]{(BINavContainer)child}));
            }
        }
        return (BHost[])hosts.trim();
    }

    public static class ReorderCommand
    extends Command {
        BNavContainer container;

        public ReorderCommand(BWidget owner, BNavContainer container) {
            super(owner, (Lexicon)UiLexicon.bajaui(), "commands.reorder");
            this.container = container;
        }

        public CommandArtifact doInvoke() throws Exception {
            BNavReorderPad pad = new BNavReorderPad((BINavNode)this.container);
            int r = BDialog.open((BWidget)this.getOwner(), (String)UiLexicon.bajaui().get("commands.reorder.label"), (Object)((Object)pad), (int)3);
            if (r == 2) {
                return null;
            }
            this.reorderHosts(pad.newOrder());
            return null;
        }

        private void reorderHosts(BINavNode[] newOrder) {
            this.container.reorderNavChildren(newOrder);
        }
    }

    public static class Close
    extends Command {
        BNavFolder[] folders;

        public Close(BWidget owner, BNavFolder folder) {
            this(owner, new BNavFolder[]{folder});
        }

        public Close(BWidget owner, BNavFolder[] folders) {
            super(owner, module, "close");
            this.folders = folders;
        }

        public CommandArtifact doInvoke() throws Exception {
            BHost[] hosts = BNavFolderMenuAgent.getHosts((BINavContainer[])this.folders);
            if (hosts.length == 0 || BSessionMenuAgent.confirmDisconnect(this.getOwner(), this.getLabel(), "confirm.host", "confirm.close", (BINavNode[])hosts)) {
                for (BHost bHost : hosts) {
                    bHost.close();
                }
                for (BHost bHost : this.folders) {
                    ((BINavContainer)bHost.getNavParent()).removeNavChild((BINavNode)bHost);
                }
                this.getOwner().repaint();
            }
            return null;
        }

        public Command doMerge(Command c) {
            return new Close(this.getOwner(), (BNavFolder[])ArrayUtil.add((Object[])this.folders, (Object[])((Close)c).folders));
        }
    }

    public static class EditFolderArtifact
    implements CommandArtifact {
        BWidget owner;
        BNavFolder folder;
        BINavContainer parent;
        String oldName;
        String newName;
        String oldDescription;
        String newDescription;
        String oldDisplayName;
        String newDisplayName;
        BIcon oldIcon;
        BIcon newIcon;
        boolean adding;

        public EditFolderArtifact(BWidget owner, BNavFolder folder, BINavContainer parent, String oldName, String newName, String oldDescription, String newDescription, String oldDisplayName, String newDisplayName, BIcon oldIcon, BIcon newIcon) {
            this.owner = owner;
            this.folder = folder;
            this.parent = parent;
            this.oldName = oldName;
            this.newName = newName;
            this.oldDescription = oldDescription;
            this.newDescription = newDescription;
            this.oldDisplayName = oldDisplayName;
            this.newDisplayName = newDisplayName;
            this.oldIcon = oldIcon;
            this.newIcon = newIcon;
            this.adding = folder.getNavParent() == null && parent != null;
        }

        public void redo() throws Exception {
            this.folder.setNavDescription(this.newDescription);
            this.folder.setIcon(this.newIcon);
            this.folder.setNavDisplayName(this.newDisplayName);
            if (this.adding) {
                this.folder.rename(this.newName);
                this.parent.addNavChild((BINavNode)this.folder);
            }
            if (!this.oldName.equals(this.newName)) {
                this.folder.rename(this.newName);
            }
            this.owner.repaint();
        }

        public void undo() throws Exception {
            this.folder.setNavDescription(this.oldDescription);
            this.folder.setIcon(this.oldIcon);
            this.folder.setNavDisplayName(this.oldDisplayName);
            if (this.adding) {
                this.parent.removeNavChild((BINavNode)this.folder);
            }
            if (!this.oldName.equals(this.newName)) {
                this.folder.rename(this.oldName);
            }
            this.owner.repaint();
        }
    }

    public static class EditCommand
    extends Command {
        private final BNavFolder folder;
        private final Supplier<BINavContainer> parentSupplier;

        public EditCommand(BWidget owner, BNavFolder folder) {
            this(owner, folder, () -> null, null);
        }

        public EditCommand(BWidget owner, BNavFolder folder, Supplier<BINavContainer> parentSupplier, String keyBase) {
            super(owner, UiLexicon.bajaui().module, keyBase != null ? keyBase : "commands.edit");
            this.folder = folder;
            this.parentSupplier = parentSupplier;
        }

        public CommandArtifact doInvoke() throws Exception {
            BINavContainer parent = this.parentSupplier.get();
            BNavFolder folder = this.folder;
            if (parent instanceof BNavRoot || folder == null) {
                folder = new BNavFolder(lex.getText("commands.newFolder.newFolderName"));
            }
            BGridPane pane = new BGridPane(2);
            String oldName = folder.getNavName();
            BFormat oldDescription = BFormat.make((String)folder.getNavDescriptionFormat());
            BFormat oldDisplayName = BFormat.make((String)folder.getNavDisplayFormat());
            BIcon oldIcon = folder.getIcon();
            BWbFieldEditor nameEditor = BWbFieldEditor.makeFor((BObject)BString.DEFAULT);
            pane.add(null, (BValue)new BLabel(lex.getText("nav.name")));
            pane.add(null, (BValue)nameEditor);
            nameEditor.loadValue((BObject)BString.make((String)oldName));
            BWbFieldEditor descriptionEditor = BWbFieldEditor.makeFor((BObject)BFormat.DEFAULT);
            pane.add(null, (BValue)new BLabel(lex.getText("nav.description")));
            pane.add(null, (BValue)descriptionEditor);
            descriptionEditor.loadValue((BObject)oldDescription);
            BWbFieldEditor displayEditor = BWbFieldEditor.makeFor((BObject)BFormat.DEFAULT);
            pane.add(null, (BValue)new BLabel(lex.getText("nav.displayName")));
            pane.add(null, (BValue)displayEditor);
            displayEditor.loadValue((BObject)oldDisplayName);
            BWbFieldEditor iconEditor = BWbFieldEditor.makeFor((BObject)BIcon.DEFAULT);
            pane.add(null, (BValue)new BLabel(lex.getText("nav.icon")));
            pane.add(null, (BValue)iconEditor);
            iconEditor.loadValue((BObject)oldIcon);
            int dialogResult = 1;
            if (allowDialogs) {
                dialogResult = BDialog.open((BWidget)this.getShell(), (String)this.getLabel(), (Object)pane, (int)3);
            }
            if (dialogResult == 2) {
                return null;
            }
            String newName = nameEditor.saveValue().toString().trim();
            String newDescription = descriptionEditor.saveValue().toString().trim();
            String newDisplayName = displayEditor.saveValue().toString().trim();
            BIcon newIcon = (BIcon)iconEditor.saveValue();
            EditFolderArtifact editArtifact = new EditFolderArtifact(this.getOwner(), folder, parent, oldName, newName, oldDescription.toString(), newDescription, oldDisplayName.toString(), newDisplayName, oldIcon, newIcon);
            editArtifact.redo();
            return editArtifact;
        }
    }

    public static class NewFolderCommand
    extends EditCommand {
        public NewFolderCommand(BWidget owner, Supplier<BINavContainer> parentSupplier) {
            super(owner, null, parentSupplier, "commands.newFolder");
        }
    }
}

