/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.workbench.ord.BFileOrdChooser;
import java.security.AccessController;
import javax.baja.file.BDataFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.ord.BIOrdChooser;

@NiagaraType(agent={@AgentOn(types={"baja:X509Certificate"})})
public class BX509CertFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BX509CertFE.class);
    private static final BImage browseIcon = BImage.make((String)"module://icons/x16/open.png");
    private static final BImage deleteIcon = BImage.make((String)"module://icons/x16/delete.png");
    private static final String CERT_HOME = AccessController.doPrivileged(() -> System.getProperty("niagara.user.home") + System.getProperty("file.separator") + "certManagement");
    private BWbShell shell;
    private final BLabel subjectDnLabel = new BLabel();
    private final BLabel warningLabel = new BLabel();
    private final BTextField field = new BTextField("", 40, false);
    private final BButton button = new BButton((Command)new Browse());
    private final BButton clearButton;
    private BX509Certificate cachedCert;
    private BOrd fileOrd;
    public static final Lexicon lexicon = Lexicon.make(BX509CertFE.class);
    private String warningText = "";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BX509CertFE() {
        this.button.setButtonStyle(BButtonStyle.toolBar);
        this.button.setVisible(true);
        this.clearButton = new BButton((Command)new Clear());
        this.clearButton.setButtonStyle(BButtonStyle.toolBar);
        this.warningLabel.setHalign(BHalign.left);
        this.warningLabel.setForeground(BBrush.makeSolid((BColor)BColor.red));
        BWidget[] widgets = new BWidget[]{this.field, this.button, this.clearButton};
        BGridPane pane = new BGridPane(3, widgets);
        BWidget[] childWidgets = new BWidget[]{this.subjectDnLabel, this.warningLabel, pane};
        BGridPane grid = new BGridPane(1, childWidgets);
        this.setContent((BWidget)grid);
    }

    public void started() {
        BObject val = this.getCurrentValue();
        if (val != null) {
            this.lockModifiedState();
            this.doLoadValue(val, this.getCurrentContext());
            this.unlockModifiedState();
        }
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.button.setEnabled(!readonly);
        this.clearButton.setEnabled(!readonly && (this.fileOrd != null && !this.fileOrd.isNull() || this.fileOrd == null && !BX509Certificate.DEFAULT.equals((Object)this.cachedCert)));
    }

    @Override
    protected void doLoadValue(BObject v, Context cx) {
        BObject warning;
        if (cx != null && (warning = cx.getFacet("warningText")) != null) {
            this.warningText = BFormat.format((String)warning.toString(), null, (Context)cx);
        }
        if (v == null && this.fileOrd == null) {
            this.clearButton.setEnabled(false);
            return;
        }
        this.cachedCert = (BX509Certificate)v;
        if (this.cachedCert.getX509Certificate() == null && this.fileOrd == null) {
            this.clearButton.setEnabled(false);
            return;
        }
        if (this.fileOrd != null) {
            this.updateCertSelection();
        } else {
            this.clearButton.setEnabled(!this.isReadonly());
            String subjectDn = this.cachedCert.getX509Certificate().getSubjectX500Principal().toString();
            this.subjectDnLabel.setText(subjectDn);
        }
        this.shell = this.getWbShell();
    }

    @Override
    protected BObject doSaveValue(BObject v, Context cx) {
        return this.cachedCert;
    }

    @Override
    public void setModified() {
        this.updateCertSelection();
        super.setModified();
    }

    private void updateCertSelection() {
        if (this.fileOrd == null || this.fileOrd.isNull()) {
            this.cachedCert = BX509Certificate.DEFAULT;
            this.field.setText("");
            this.subjectDnLabel.setText("");
            this.warningLabel.setText(this.warningText);
            this.warningLabel.setWordWrapEnabled(true, 300.0);
            this.clearButton.setEnabled(false);
            return;
        }
        this.clearButton.setEnabled(!this.isReadonly());
        BDataFile dataFile = (BDataFile)this.fileOrd.resolve().get();
        try {
            this.cachedCert = BX509Certificate.make((String)new String(dataFile.read()));
            String subjectDn = this.cachedCert.getX509Certificate().getSubjectX500Principal().toString();
            this.subjectDnLabel.setText(subjectDn);
            this.warningLabel.setText(this.warningText);
            this.warningLabel.setWordWrapEnabled(true, 300.0);
        }
        catch (Exception e) {
            this.subjectDnLabel.setText(String.format(lexicon.getText("clientCert.certFormat"), this.fileOrd.toString()));
        }
    }

    private class Clear
    extends Command {
        Clear() {
            super((BWidget)BX509CertFE.this, "");
        }

        public CommandArtifact doInvoke() {
            if (!BOrd.NULL.equals((Object)BX509CertFE.this.fileOrd)) {
                BX509CertFE.this.fileOrd = BOrd.NULL;
                BX509CertFE.this.setModified();
            }
            return null;
        }

        public BImage getIcon() {
            return deleteIcon;
        }
    }

    protected class Browse
    extends Command {
        private final TypeInfo info;

        Browse() {
            super((BWidget)BX509CertFE.this, "");
            this.info = BFileOrdChooser.TYPE.getTypeInfo();
        }

        public CommandArtifact doInvoke() {
            String trim;
            BObject base = null;
            if (BX509CertFE.this.shell != null) {
                base = BX509CertFE.this.shell.getActiveOrdTarget().get();
            }
            String location = CERT_HOME;
            if (BX509CertFE.this.field.getText() != null && (trim = BX509CertFE.this.field.getText().trim()).isEmpty()) {
                location = trim;
            }
            BOrd temp = BOrd.make((String)location);
            BIOrdChooser chooser = (BIOrdChooser)this.info.getInstance();
            BX509CertFE.this.fileOrd = chooser.openChooser(BX509CertFE.this, base, temp, BX509CertFE.this.getCurrentContext());
            if (BX509CertFE.this.fileOrd != null) {
                BX509CertFE.this.field.setText(BX509CertFE.this.fileOrd.encodeToString());
                BX509CertFE.this.setModified();
            }
            return null;
        }

        public BImage getIcon() {
            return browseIcon;
        }
    }
}

