/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BGridPane;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"baja:Unit"})})
@NiagaraAction(name="qboxChanged")
public class BUnitFE
extends BWbFieldEditor {
    @Generated
    public static final Action qboxChanged = BUnitFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUnitFE.class);
    private BListDropDown qbox = new BListDropDown();
    private BListDropDown ubox = new BListDropDown();
    private BMruButton history = new BMruButton("unitFE");
    private BUnit loading;

    @Generated
    public void qboxChanged() {
        this.invoke(qboxChanged, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUnitFE() {
        this.history.setMruController((BMruButton.MruController)new MruController());
        this.history.setButtonStyle(BButtonStyle.toolBar);
        BGridPane pane = new BGridPane(3);
        pane.setColumnAlign(BHalign.fill);
        pane.add("qbox", (BValue)this.qbox);
        pane.add("ubox", (BValue)this.ubox);
        pane.add("history", (BValue)this.history);
        this.setContent((BWidget)pane);
        this.linkTo("lk0", (BComponent)this.qbox, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk1", (BComponent)this.qbox, (Slot)BListDropDown.valueModified, (Slot)qboxChanged);
        this.linkTo("lk3", (BComponent)this.qbox, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk4", (BComponent)this.ubox, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk5", (BComponent)this.ubox, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        UnitDatabase.Quantity[] q = UnitDatabase.getDefault().getQuantities();
        for (int i = 0; i < q.length; ++i) {
            this.qbox.getList().addItem((Object)q[i]);
        }
        this.qbox.setSelectedIndex(0);
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.qbox.setDropDownEnabled(!readonly);
        this.ubox.setDropDownEnabled(!readonly);
        this.history.setEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        BUnit unit = (BUnit)value;
        UnitDatabase.Quantity q = UnitDatabase.getDefault().getQuantity(unit);
        if (q == null) {
            q = UnitDatabase.getDefault().getQuantities()[0];
        }
        this.loading = unit;
        this.qbox.setSelectedItem(null);
        this.qbox.setSelectedItem((Object)q);
        this.loading = null;
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        UnitEntry entry = (UnitEntry)this.ubox.getSelectedItem();
        this.history.getMruOptions().save(entry.unit.encodeToString());
        return entry.unit;
    }

    public void doQboxChanged() {
        int def = -1;
        this.ubox.getList().removeAllItems();
        UnitDatabase.Quantity q = (UnitDatabase.Quantity)this.qbox.getSelectedItem();
        if (q != null) {
            BUnit[] u = q.getUnits();
            for (int i = 0; i < u.length; ++i) {
                this.ubox.getList().addItem((Object)new UnitEntry(u[i]));
                if (u[i] != this.loading) continue;
                def = i;
            }
            if (def == -1 && this.loading != null) {
                this.ubox.getList().insertItem(0, (Object)new UnitEntry(this.loading));
                def = 0;
            }
            this.ubox.setSelectedIndex(def);
        }
    }

    class MruController
    extends BMruButton.MruController {
        MruController() {
        }

        public String toDisplayString(String value) {
            try {
                BUnit unit = (BUnit)BUnit.DEFAULT.decodeFromString(value);
                return unit.getUnitName() + " (" + unit.getSymbol() + ")";
            }
            catch (Exception e) {
                e.printStackTrace();
                return value;
            }
        }

        public void select(String value) {
            try {
                BUnitFE.this.loadValue(BUnit.DEFAULT.decodeFromString(value), BUnitFE.this.getCurrentContext());
                BUnitFE.this.setModified();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class UnitEntry {
        BUnit unit;
        String string;

        UnitEntry(BUnit unit) {
            this.unit = unit;
            this.string = unit.getUnitName() + " (" + unit.getSymbol() + ")";
        }

        public String toString() {
            return this.string;
        }
    }
}

