/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.workbench.fieldeditors.BStringFE;
import java.util.regex.Pattern;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
public class BURLPathFE
extends BStringFE {
    @Generated
    public static final Type TYPE = Sys.loadType(BURLPathFE.class);
    private static final Pattern pattern = Pattern.compile("([^?#]*)");
    private static final String LEX_EXCEPTION_MALFORMED = "URLPathFE.exception.malformed";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException {
        Lexicon lex = Lexicon.make(BURLPathFE.class);
        BString path = (BString)super.doSaveValue(value, cx);
        String pathString = path.getString();
        if (!pathString.startsWith("/")) {
            pathString = "/" + pathString;
        }
        if (!pattern.matcher(pathString).matches()) {
            throw new CannotSaveException(lex.get(LEX_EXCEPTION_MALFORMED), true);
        }
        return BString.make((String)pathString);
    }
}

