/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"gx:Transform"})})
@NiagaraActions(value={@NiagaraAction(name="transformSelectionChanged"), @NiagaraAction(name="typeChanged"), @NiagaraAction(name="field1Modified"), @NiagaraAction(name="field2Modified")})
public class BTransformFE
extends BWbFieldEditor {
    @Generated
    public static final Action transformSelectionChanged = BTransformFE.newAction((int)0, null);
    @Generated
    public static final Action typeChanged = BTransformFE.newAction((int)0, null);
    @Generated
    public static final Action field1Modified = BTransformFE.newAction((int)0, null);
    @Generated
    public static final Action field2Modified = BTransformFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTransformFE.class);
    static Lexicon lex = Lexicon.make((String)"workbench");
    static final BImage add = BImage.make((String)"module://icons/x16/add.png");
    static final BImage remove = BImage.make((String)"module://icons/x16/delete.png");
    static final BImage up = BImage.make((String)"module://icons/x16/arrowUp.png");
    static final BImage down = BImage.make((String)"module://icons/x16/arrowDown.png");
    BList transforms = new BList();
    BButton btnAdd;
    BButton btnRemove;
    BButton btnUp;
    BButton btnDown;
    BListDropDown types;
    BLabel label1;
    BLabel label2;
    BTextField field1;
    BTextField field2;

    @Generated
    public void transformSelectionChanged() {
        this.invoke(transformSelectionChanged, null, null);
    }

    @Generated
    public void typeChanged() {
        this.invoke(typeChanged, null, null);
    }

    @Generated
    public void field1Modified() {
        this.invoke(field1Modified, null, null);
    }

    @Generated
    public void field2Modified() {
        this.invoke(field2Modified, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTransformFE() {
        this.transforms.setMultipleSelection(false);
        BConstrainedPane transPane = new BConstrainedPane((BWidget)this.transforms);
        transPane.setMinHeight(this.transforms.getRenderer().getItemHeight() * 5.0);
        transPane.setMaxHeight(this.transforms.getRenderer().getItemHeight() * 5.0);
        BGridPane buttons = new BGridPane(4);
        this.btnAdd = BTransformFE.newButton(new Add(this));
        this.btnRemove = BTransformFE.newButton(new Remove(this));
        this.btnUp = BTransformFE.newButton(new Up(this));
        this.btnDown = BTransformFE.newButton(new Down(this));
        buttons.add(null, (BValue)this.btnAdd);
        buttons.add(null, (BValue)this.btnRemove);
        buttons.add(null, (BValue)this.btnUp);
        buttons.add(null, (BValue)this.btnDown);
        BEdgePane left = new BEdgePane();
        left.setCenter((BWidget)transPane);
        left.setBottom((BWidget)new BBorderPane((BWidget)buttons, 5.0, 0.0, 0.0, 0.0));
        this.types = new BListDropDown();
        this.types.getList().addItem((Object)BTransformFE.text("translate"));
        this.types.getList().addItem((Object)BTransformFE.text("scale"));
        this.types.getList().addItem((Object)BTransformFE.text("rotate"));
        this.types.getList().addItem((Object)BTransformFE.text("skewX"));
        this.types.getList().addItem((Object)BTransformFE.text("skewY"));
        this.label1 = new BLabel("???", BHalign.right);
        this.label2 = new BLabel("???", BHalign.right);
        this.field1 = new BTextField("", 10);
        this.field2 = new BTextField("", 10);
        double width = this.labelMaxWidth();
        BConstrainedPane cons1 = new BConstrainedPane((BWidget)this.label1);
        BConstrainedPane cons2 = new BConstrainedPane((BWidget)this.label2);
        cons1.setMinWidth(width);
        cons2.setMinWidth(width);
        BGridPane fields = new BGridPane(2);
        fields.setHalign(BHalign.left);
        fields.setValign(BValign.top);
        fields.add(null, (BValue)cons1);
        fields.add(null, (BValue)this.field1);
        fields.add(null, (BValue)cons2);
        fields.add(null, (BValue)this.field2);
        BEdgePane right = new BEdgePane();
        right.setTop((BWidget)this.types);
        right.setCenter((BWidget)new BBorderPane((BWidget)fields, 5.0, 0.0, 0.0, 0.0));
        right.computePreferredSize();
        BConstrainedPane rightPane = new BConstrainedPane((BWidget)right);
        rightPane.setMinWidth(right.getPreferredWidth());
        BEdgePane contents = new BEdgePane();
        contents.setLeft((BWidget)left);
        contents.setRight((BWidget)new BBorderPane((BWidget)rightPane, 0.0, 0.0, 0.0, 5.0));
        this.setContent((BWidget)contents);
        this.linkTo(null, (BComponent)this.types, (Slot)BListDropDown.listActionPerformed, (Slot)typeChanged);
        this.linkTo(null, (BComponent)this.transforms, (Slot)BList.selectionModified, (Slot)transformSelectionChanged);
        this.linkTo("lnkField1Modified", (BComponent)this.field1, (Slot)BTextField.textModified, (Slot)field1Modified);
        this.linkTo("lnkField2Modified", (BComponent)this.field2, (Slot)BTextField.textModified, (Slot)field2Modified);
    }

    double labelMaxWidth() {
        BLabel temp = new BLabel(BTransformFE.text("x"));
        temp.computePreferredSize();
        double max = temp.getPreferredWidth();
        temp = new BLabel(BTransformFE.text("y"));
        temp.computePreferredSize();
        max = Math.max(max, temp.getPreferredWidth());
        temp = new BLabel(BTransformFE.text("angle"));
        temp.computePreferredSize();
        max = Math.max(max, temp.getPreferredWidth());
        return max;
    }

    public void doTransformSelectionChanged() {
        int n = this.transforms.getSelectedIndex();
        if (!this.isReadonly()) {
            this.btnRemove.setEnabled(n != -1);
            this.btnUp.setEnabled(n != -1 && n != 0);
            this.btnDown.setEnabled(n != -1 && n != this.transforms.getItemCount() - 1);
        }
        if (n == -1) {
            this.types.setVisible(false);
            this.label1.setVisible(false);
            this.label2.setVisible(false);
            this.field1.setVisible(false);
            this.field2.setVisible(false);
        } else {
            this.types.setVisible(true);
            BTransform.Transform t = (BTransform.Transform)this.transforms.getItem(n);
            this.types.getList().setSelectedIndex(t.getTransformCase() - 1);
            this.editTransform(t);
        }
        this.relayout();
    }

    void editTransform(BTransform.Transform t) {
        this.remove("lnkField1Modified");
        this.remove("lnkField2Modified");
        switch (t.getTransformCase()) {
            case 1: {
                this.label1.setVisible(true);
                this.label2.setVisible(true);
                this.label1.setText(BTransformFE.text("x"));
                this.label2.setText(BTransformFE.text("y"));
                this.field1.setVisible(true);
                this.field2.setVisible(true);
                BTransform.Translate trans = (BTransform.Translate)t;
                this.field1.setText(Double.toString(trans.getX()));
                this.field2.setText(Double.toString(trans.getY()));
                break;
            }
            case 2: {
                this.label1.setVisible(true);
                this.label2.setVisible(true);
                this.label1.setText(BTransformFE.text("x"));
                this.label2.setText(BTransformFE.text("y"));
                this.field1.setVisible(true);
                this.field2.setVisible(true);
                BTransform.Scale scale = (BTransform.Scale)t;
                this.field1.setText(Double.toString(scale.getX()));
                this.field2.setText(Double.toString(scale.getY()));
                break;
            }
            case 3: {
                this.label1.setVisible(true);
                this.label2.setVisible(false);
                this.label1.setText(BTransformFE.text("angle"));
                this.field1.setVisible(true);
                this.field2.setVisible(false);
                BTransform.Rotate rotate = (BTransform.Rotate)t;
                this.field1.setText(Double.toString(rotate.getAngle()));
                break;
            }
            case 4: {
                this.label1.setVisible(true);
                this.label2.setVisible(false);
                this.label1.setText(BTransformFE.text("angle"));
                this.field1.setVisible(true);
                this.field2.setVisible(false);
                BTransform.SkewX skewX = (BTransform.SkewX)t;
                this.field1.setText(Double.toString(skewX.getAngle()));
                break;
            }
            case 5: {
                this.label1.setVisible(true);
                this.label2.setVisible(false);
                this.label1.setText(BTransformFE.text("angle"));
                this.field1.setVisible(true);
                this.field2.setVisible(false);
                BTransform.SkewY skewY = (BTransform.SkewY)t;
                this.field1.setText(Double.toString(skewY.getAngle()));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.linkTo("lnkField1Modified", (BComponent)this.field1, (Slot)BTextField.textModified, (Slot)field1Modified);
        this.linkTo("lnkField2Modified", (BComponent)this.field2, (Slot)BTextField.textModified, (Slot)field2Modified);
    }

    public void doTypeChanged() {
        BTransform.Transform t = BTransformFE.makeTransform(this.types.getSelectedIndex() + 1);
        this.transforms.setItem(this.transforms.getSelectedIndex(), (Object)t);
        this.editTransform(t);
        this.setModified();
        this.repaint();
    }

    private static BTransform.Transform makeTransform(int n) {
        switch (n) {
            case 1: {
                return new BTransform.Translate(0.0, 0.0);
            }
            case 2: {
                return new BTransform.Scale(0.0, 0.0);
            }
            case 3: {
                return new BTransform.Rotate(0.0);
            }
            case 4: {
                return new BTransform.SkewX(0.0);
            }
            case 5: {
                return new BTransform.SkewY(0.0);
            }
        }
        throw new IllegalStateException();
    }

    public void doField1Modified() {
        int n = this.transforms.getSelectedIndex();
        BTransform.Transform t = (BTransform.Transform)this.transforms.getItem(n);
        switch (t.getTransformCase()) {
            case 1: {
                BTransform.Translate trans = (BTransform.Translate)t;
                t = new BTransform.Translate(this.atod(this.field1.getText()), trans.getY());
                break;
            }
            case 2: {
                BTransform.Scale scale = (BTransform.Scale)t;
                t = new BTransform.Scale(this.atod(this.field1.getText()), scale.getY());
                break;
            }
            case 3: {
                t = new BTransform.Rotate(this.atod(this.field1.getText()));
                break;
            }
            case 4: {
                t = new BTransform.SkewX(this.atod(this.field1.getText()));
                break;
            }
            case 5: {
                t = new BTransform.SkewY(this.atod(this.field1.getText()));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.transforms.setItem(n, (Object)t);
        this.setModified();
        this.repaint();
    }

    public void doField2Modified() {
        int n = this.transforms.getSelectedIndex();
        BTransform.Transform t = (BTransform.Transform)this.transforms.getItem(n);
        switch (t.getTransformCase()) {
            case 1: {
                BTransform.Translate trans = (BTransform.Translate)t;
                t = new BTransform.Translate(trans.getX(), this.atod(this.field2.getText()));
                break;
            }
            case 2: {
                BTransform.Scale scale = (BTransform.Scale)t;
                t = new BTransform.Scale(scale.getX(), this.atod(this.field2.getText()));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.transforms.setItem(n, (Object)t);
        this.setModified();
        this.repaint();
    }

    double atod(String text) {
        try {
            return Double.valueOf(text);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
        this.types.setEnabled(false);
        this.field1.setEnabled(false);
        this.field2.setEnabled(false);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BTransform t = (BTransform)value;
        BTransform.Transform[] forms = t.getTransforms();
        this.transforms.removeAllItems();
        for (int i = 0; i < forms.length; ++i) {
            this.transforms.addItem((Object)forms[i]);
        }
        this.transforms.getSelection().deselectAll();
        if (forms.length > 0) {
            this.transforms.getSelection().select(0);
        }
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        int len = this.transforms.getItemCount();
        BTransform.Transform[] forms = new BTransform.Transform[len];
        for (int i = 0; i < len; ++i) {
            forms[i] = (BTransform.Transform)this.transforms.getItem(i);
        }
        return BTransform.make((BTransform.Transform[])forms);
    }

    static BButton newButton(Command cmd) {
        BButton b = new BButton(cmd, true, true);
        b.setHalign(BHalign.left);
        return b;
    }

    static String text(String s) {
        return lex.getText("transformFE." + s);
    }

    class Down
    extends Command {
        Down(BWidget owner) {
            super(owner, null, down, null, null);
        }

        public CommandArtifact doInvoke() {
            int n = BTransformFE.this.transforms.getSelectedIndex();
            if (n == -1 || n == BTransformFE.this.transforms.getItemCount() - 1) {
                throw new IllegalStateException();
            }
            Object item = BTransformFE.this.transforms.getItem(n);
            BTransformFE.this.transforms.removeItem(n);
            BTransformFE.this.transforms.insertItem(n + 1, item);
            BTransformFE.this.transforms.getSelection().deselectAll();
            BTransformFE.this.transforms.getSelection().select(n + 1);
            BTransformFE.this.transforms.relayout();
            BTransformFE.this.setModified();
            return null;
        }
    }

    class Up
    extends Command {
        Up(BWidget owner) {
            super(owner, null, up, null, null);
        }

        public CommandArtifact doInvoke() {
            int n = BTransformFE.this.transforms.getSelectedIndex();
            if (n == -1 || n == 0) {
                throw new IllegalStateException();
            }
            Object item = BTransformFE.this.transforms.getItem(n);
            BTransformFE.this.transforms.removeItem(n);
            BTransformFE.this.transforms.insertItem(n - 1, item);
            BTransformFE.this.transforms.getSelection().deselectAll();
            BTransformFE.this.transforms.getSelection().select(n - 1);
            BTransformFE.this.transforms.relayout();
            BTransformFE.this.setModified();
            return null;
        }
    }

    class Remove
    extends Command {
        Remove(BWidget owner) {
            super(owner, null, remove, null, null);
        }

        public CommandArtifact doInvoke() {
            int n = BTransformFE.this.transforms.getSelectedIndex();
            if (n == -1) {
                throw new IllegalStateException();
            }
            BTransformFE.this.transforms.removeItem(n);
            BTransformFE.this.transforms.getSelection().deselectAll();
            int len = BTransformFE.this.transforms.getItemCount();
            if (len > 0) {
                BTransformFE.this.transforms.getSelection().select(n == len ? n - 1 : n);
            }
            BTransformFE.this.transforms.relayout();
            BTransformFE.this.setModified();
            return null;
        }
    }

    class Add
    extends Command {
        Add(BWidget owner) {
            super(owner, null, add, null, null);
        }

        public CommandArtifact doInvoke() {
            BTransformFE.this.transforms.addItem((Object)new BTransform.Translate(0.0, 0.0));
            BTransformFE.this.transforms.getSelection().deselectAll();
            BTransformFE.this.transforms.getSelection().select(BTransformFE.this.transforms.getItemCount() - 1);
            BTransformFE.this.transforms.relayout();
            BTransformFE.this.setModified();
            return null;
        }
    }
}

