/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import javax.baja.gx.BPen;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"gx:Pen"})})
public class BPenFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BPenFE.class);
    private static final double[] dotted = new double[]{2.0, 2.0};
    private static final double[] dashed = new double[]{8.0, 2.0};
    private BTextField width = new BTextField("", 5);
    private BListDropDown cap = new BListDropDown();
    private BListDropDown join = new BListDropDown();
    private BListDropDown dash = new BListDropDown();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPenFE() {
        BList list = this.cap.getList();
        list.addItem((Object)"Cap Butt");
        list.addItem((Object)"Cap Round");
        list.addItem((Object)"Cap Square");
        list = this.join.getList();
        list.addItem((Object)"Join Miter");
        list.addItem((Object)"Join Bevel");
        list.addItem((Object)"Join Round");
        list = this.dash.getList();
        list.addItem((Object)"Solid");
        list.addItem((Object)"Dotted");
        list.addItem((Object)"Dashed");
        BGridPane grid = new BGridPane(4);
        grid.add(null, (BValue)this.width);
        grid.add(null, (BValue)this.dash);
        grid.add(null, (BValue)this.cap);
        grid.add(null, (BValue)this.join);
        this.setContent((BWidget)grid);
        this.linkTo((BComponent)this.width, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.cap, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.join, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.dash, (Slot)BListDropDown.valueModified, (Slot)setModified);
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.width.setEditable(!readonly);
        this.cap.setDropDownEnabled(!readonly);
        this.join.setDropDownEnabled(!readonly);
        this.dash.setDropDownEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        BPen pen = (BPen)value;
        this.width.setText(Double.toString(pen.getWidth()));
        switch (pen.getCap()) {
            case 101: {
                this.cap.setSelectedIndex(0);
                break;
            }
            case 103: {
                this.cap.setSelectedIndex(1);
                break;
            }
            case 102: {
                this.cap.setSelectedIndex(2);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (pen.getJoin()) {
            case 201: {
                this.join.setSelectedIndex(0);
                break;
            }
            case 203: {
                this.join.setSelectedIndex(1);
                break;
            }
            case 202: {
                this.join.setSelectedIndex(2);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        double[] d = pen.getDash();
        if (d.length == 0) {
            this.dash.setSelectedIndex(0);
        } else if (d.length == 2 && d[0] == dotted[0] && d[1] == dotted[1]) {
            this.dash.setSelectedIndex(1);
        } else if (d.length == 2 && d[0] == dashed[0] && d[1] == dashed[1]) {
            this.dash.setSelectedIndex(2);
        } else {
            throw new IllegalStateException("Custom dash not implemented.");
        }
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        double[] d;
        int j;
        int c;
        double w = Double.parseDouble(this.width.getText());
        switch (this.cap.getSelectedIndex()) {
            case 0: {
                c = 101;
                break;
            }
            case 1: {
                c = 103;
                break;
            }
            case 2: {
                c = 102;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (this.join.getSelectedIndex()) {
            case 0: {
                j = 201;
                break;
            }
            case 1: {
                j = 203;
                break;
            }
            case 2: {
                j = 202;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (this.dash.getSelectedIndex()) {
            case 0: {
                d = null;
                break;
            }
            case 1: {
                d = dotted;
                break;
            }
            case 2: {
                d = dashed;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return BPen.make((double)w, (int)c, (int)j, (double[])d);
    }
}

