/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BOrdFE;
import java.io.IOException;
import javax.baja.gx.BBrush;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"baja:OrdList"})})
@NiagaraProperty(name="content", type="BWidget", defaultValue="new BNullWidget()", override=true)
@NiagaraAction(name="listSelChanged")
public class BOrdListFE
extends BWbFieldEditor {
    @Generated
    public static final Property content = BOrdListFE.newProperty((int)0, (BValue)new BNullWidget(), null);
    @Generated
    public static final Action listSelChanged = BOrdListFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOrdListFE.class);
    static Lexicon bajaLex = Lexicon.make((String)"baja");
    static Lexicon wbLex = Lexicon.make((String)"workbench");
    boolean multiLine = false;
    BTextField textField = new BTextField("", 50);
    BConstrainedPane listCons = new BConstrainedPane();
    BList list = new BList();
    Add add;
    Remove remove;

    @Generated
    public void listSelChanged() {
        this.invoke(listSelChanged, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOrdListFE() {
        this.list.setMultipleSelection(false);
        this.list.setController((ListController)new Controller(this));
        BGridPane buttons = new BGridPane(2);
        buttons.setHalign(BHalign.left);
        buttons.setValign(BValign.top);
        this.add = new Add(this);
        buttons.add("add", (BValue)BOrdListFE.newButton(this.add));
        this.remove = new Remove(this);
        buttons.add("remove", (BValue)BOrdListFE.newButton(this.remove));
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)this.list);
        edge.setRight((BWidget)new BBorderPane((BWidget)buttons, 0.0, 0.0, 0.0, 3.0));
        this.textField.computePreferredSize();
        double width = this.textField.getPreferredWidth();
        double height = this.list.getRenderer().getItemHeight() * 5.0;
        this.listCons.setContent((BWidget)edge);
        this.listCons.setMinHeight(height);
        this.listCons.setMaxHeight(height);
        this.listCons.setMinWidth(width);
    }

    public void doListSelChanged() {
        if (!this.isReadonly()) {
            int n = this.list.getSelectedIndex();
            this.remove.setEnabled(n != -1);
        }
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.list.getSelection().deselectAll();
        if (readonly) {
            this.list.setRenderer((ListRenderer)new ReadonlyListRenderer());
        }
        this.textField.setEditable(!readonly);
        this.add.setEnabled(!readonly);
        this.remove.setEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context context) {
        if (this.get("linkA") != null) {
            this.remove("linkA");
        }
        if (this.get("linkB") != null) {
            this.remove("linkB");
        }
        if (this.get("linkC") != null) {
            this.remove("linkC");
        }
        this.multiLine = this.getBooleanFacetValue(context, "multiLine", false);
        if (this.multiLine) {
            BOrdList ords = (BOrdList)value;
            this.list.removeAllItems();
            for (int i = 0; i < ords.size(); ++i) {
                this.list.addItem((Object)ords.get(i));
            }
            this.setContent((BWidget)this.listCons);
            this.linkTo("linkC", (BComponent)this.list, (Slot)BList.selectionModified, (Slot)listSelChanged);
        } else {
            try {
                this.textField.setText(value.asSimple().encodeToString());
            }
            catch (IOException e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            this.setContent((BWidget)this.textField);
            this.linkTo("linkA", (BComponent)this.textField, (Slot)BTextField.textModified, (Slot)setModified);
            this.linkTo("linkB", (BComponent)this.textField, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        }
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (this.multiLine) {
            BOrd[] ords = new BOrd[this.list.getItemCount()];
            for (int i = 0; i < this.list.getItemCount(); ++i) {
                ords[i] = (BOrd)this.list.getItem(i);
            }
            return BOrdList.make((BOrd[])ords);
        }
        String str = this.textField.getText();
        try {
            return value.asSimple().decodeFromString(str);
        }
        catch (IOException e) {
            Object[] args = new Object[]{str, value.getType()};
            String msg = UiLexicon.bajaui().getText("defaultSimplePlugin.error", args);
            throw new CannotSaveException(msg);
        }
    }

    private boolean getBooleanFacetValue(Context cx, String facetName, boolean def) {
        if (cx == null) {
            return def;
        }
        BBoolean value = (BBoolean)cx.getFacet(facetName);
        return value == null ? def : value.getBoolean();
    }

    private static BButton newButton(Command cmd) {
        BButton b = new BButton(cmd, true, true);
        b.setButtonStyle(BButtonStyle.toolBar);
        b.setHalign(BHalign.left);
        return b;
    }

    private BOrd editOrd(BOrd ord, Context cx) {
        BOrdFE fe = new BOrdFE();
        fe.loadValue((BObject)ord, cx);
        int r = BDialog.open((BWidget)this, (String)BOrdListFE.baja("ord"), (Object)((Object)fe), (int)3);
        if (r != 1) {
            return null;
        }
        try {
            return (BOrd)fe.saveValue();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    static String baja(String s) {
        return bajaLex.getText(s);
    }

    class Remove
    extends Command {
        Remove(BWidget owner) {
            super(owner, wbLex, "ordListFE.remove");
        }

        public CommandArtifact doInvoke() {
            int n = BOrdListFE.this.list.getSelectedIndex();
            if (n == -1) {
                throw new IllegalStateException();
            }
            BOrdListFE.this.list.removeItem(n);
            BOrdListFE.this.list.setSelectedIndex(-1);
            int len = BOrdListFE.this.list.getItemCount();
            if (len > 0) {
                BOrdListFE.this.list.setSelectedIndex(n == len ? n - 1 : n);
            }
            BOrdListFE.this.setModified();
            BOrdListFE.this.repaint();
            return null;
        }
    }

    class Add
    extends Command {
        Add(BWidget owner) {
            super(owner, wbLex, "ordListFE.add");
        }

        public CommandArtifact doInvoke() {
            BOrd ord = BOrdListFE.this.editOrd(BOrd.NULL, BOrdListFE.this.getCurrentContext());
            if (ord != null) {
                BOrdListFE.this.list.addItem((Object)ord);
                BOrdListFE.this.list.setSelectedIndex(BOrdListFE.this.list.getItemCount() - 1);
                BOrdListFE.this.setModified();
                BOrdListFE.this.repaint();
            }
            return null;
        }
    }

    static class ReadonlyListRenderer
    extends ListRenderer {
        public BBrush getBackground(ListRenderer.Item item) {
            BTextField disabledWidget = new BTextField();
            disabledWidget.setEnabled(false);
            return Theme.textEditor().getControlBackground((IStylable)disabledWidget);
        }
    }

    static class Controller
    extends ListController {
        BOrdListFE ordListFE;

        public Controller(BOrdListFE ordListFE) {
            this.ordListFE = ordListFE;
        }

        protected void itemDoubleClicked(BMouseEvent event, int index) {
            BOrd ord;
            if (!this.ordListFE.isReadonly() && (ord = this.ordListFE.editOrd((BOrd)this.ordListFE.list.getItem(index), null)) != null) {
                this.ordListFE.list.setItem(index, (Object)ord);
                this.ordListFE.setModified();
                this.ordListFE.repaint();
            }
        }

        public void keyPressed(BKeyEvent event) {
            Object payload;
            Object[] selectedItems;
            super.keyPressed(event);
            if (event.isControlDown() && event.getKeyCode() == 67 && (selectedItems = this.ordListFE.list.getSelectedItems()).length > 0 && (payload = selectedItems[0]) != null) {
                Clipboard.getDefault().setContents(TransferEnvelope.make((String)payload.toString()));
            }
        }
    }
}

