/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.workbench.fieldeditors.BFloatFE;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextController;
import javax.baja.units.BUnit;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"baja:Integer", "baja:Long"})})
public class BIntegerFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BIntegerFE.class);
    private int width = 14;
    private final BTextField field = new BTextField("", this.width);
    private final BLabel postlabel = new BLabel("");
    private final BLabel prelabel = new BLabel("");
    private String range = "";
    private Values values;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIntegerFE() {
        this.field.setController((TextController)new BFloatFE.Controller());
        BGridPane pane = new BGridPane(3);
        pane.add("prelabel", (BValue)this.prelabel);
        pane.add("field", (BValue)this.field);
        pane.add("postlabel", (BValue)this.postlabel);
        this.setContent((BWidget)pane);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.field.setEditable(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        this.values = value instanceof BInteger ? new IntValues(cx) : new LongValues(cx);
        this.range = "";
        this.width = 14;
        String postmeta = "";
        String premeta = "";
        BNumber min = null;
        BNumber max = null;
        if (cx != null) {
            BInteger widthFacet;
            BUnit u = (BUnit)cx.getFacet("units");
            if (u != null && !u.isNull()) {
                if (u.getIsPrefix()) {
                    premeta = u.getSymbol();
                } else {
                    postmeta = u.getSymbol();
                }
            }
            if ((widthFacet = (BInteger)cx.getFacet("fieldWidth")) != null) {
                this.width = widthFacet.getInt();
            }
            min = (BNumber)cx.getFacet("min");
            max = (BNumber)cx.getFacet("max");
        }
        if (this.width != 14) {
            this.field.setVisibleColumns(this.width);
        }
        if (this.values.radix != 10) {
            if (!postmeta.isEmpty()) {
                postmeta = postmeta + ' ';
            }
            postmeta = postmeta + "Radix=" + this.values.radix;
        }
        if (this.values.loadFacets(min, max)) {
            String minStr = min == null ? "min" : this.values.toString((BObject)min);
            String maxStr = max == null ? "max" : this.values.toString((BObject)max);
            this.range = '[' + minStr + " - " + maxStr + ']';
            if (!postmeta.isEmpty()) {
                postmeta = postmeta + ' ';
            }
            postmeta = postmeta + this.range;
        }
        String s = this.values.toString(value);
        this.field.setText(s);
        this.prelabel.setText(premeta);
        this.postlabel.setText(postmeta);
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String s = this.field.getText();
        BValue saved = this.values.fromString(s, this.range);
        this.field.setText(this.values.toString((BObject)saved));
        return saved;
    }

    static class LongValues
    extends Values {
        long min = Long.MIN_VALUE;
        long max = Long.MAX_VALUE;

        public LongValues(Context cx) {
            super(cx);
        }

        @Override
        boolean loadFacets(BNumber min, BNumber max) {
            if (min != null) {
                this.min = min.getLong();
            }
            if (max != null) {
                this.max = max.getLong();
            }
            return this.min != Long.MIN_VALUE || this.max != Long.MAX_VALUE;
        }

        @Override
        String toString(BObject x) {
            return this.toString(((BNumber)x).getLong());
        }

        String toString(long x) {
            if (x == Long.MIN_VALUE) {
                return "min";
            }
            if (x == Long.MAX_VALUE) {
                return "max";
            }
            if (x == 0L || this.radix != 10) {
                return Long.toString(x, this.radix);
            }
            return this.toStringFormat.format(x);
        }

        @Override
        BValue fromString(String s, String range) throws CannotSaveException {
            long x;
            try {
                if ("min".equals(s)) {
                    x = Long.MIN_VALUE;
                } else if ("max".equals(s)) {
                    x = Long.MAX_VALUE;
                } else if (this.radix != 10) {
                    x = Long.parseLong(s, this.radix);
                } else {
                    String stripped = s.startsWith("+") ? s.substring(1) : s;
                    ParsePosition pos = new ParsePosition(0);
                    x = this.fromStringFormat.parse(stripped, pos).longValue();
                    if (pos.getIndex() != stripped.length()) {
                        throw new CannotSaveException("Invalid format: " + s);
                    }
                }
            }
            catch (CannotSaveException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CannotSaveException("Invalid format: " + s);
            }
            if (x < this.min) {
                throw new CannotSaveException(this.toString(x) + " < " + this.toString(this.min) + ' ' + range);
            }
            if (x > this.max) {
                throw new CannotSaveException(this.toString(x) + " > " + this.toString(this.max) + ' ' + range);
            }
            return BLong.make((long)x);
        }
    }

    static class IntValues
    extends Values {
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;

        public IntValues(Context cx) {
            super(cx);
        }

        @Override
        boolean loadFacets(BNumber min, BNumber max) {
            if (min != null) {
                this.min = min.getInt();
            }
            if (max != null) {
                this.max = max.getInt();
            }
            return this.min != Integer.MIN_VALUE || this.max != Integer.MAX_VALUE;
        }

        @Override
        String toString(BObject x) {
            return this.toString(((BNumber)x).getInt());
        }

        String toString(int x) {
            if (x == Integer.MIN_VALUE) {
                return "min";
            }
            if (x == Integer.MAX_VALUE) {
                return "max";
            }
            if (x == 0 || this.radix != 10) {
                return Long.toString((long)x & 0xFFFFFFFFL, this.radix);
            }
            return this.toStringFormat.format(x);
        }

        @Override
        BValue fromString(String s, String range) throws CannotSaveException {
            int x;
            try {
                if ("min".equals(s)) {
                    x = Integer.MIN_VALUE;
                } else if ("max".equals(s)) {
                    x = Integer.MAX_VALUE;
                } else if (this.radix != 10) {
                    x = (int)Long.parseLong(s, this.radix);
                } else {
                    String stripped = s.startsWith("+") ? s.substring(1) : s;
                    ParsePosition pos = new ParsePosition(0);
                    x = this.fromStringFormat.parse(stripped, pos).intValue();
                    if (pos.getIndex() != stripped.length()) {
                        throw new CannotSaveException("Invalid format: " + s);
                    }
                }
            }
            catch (CannotSaveException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CannotSaveException("Invalid format: " + s);
            }
            if (x < this.min) {
                throw new CannotSaveException(this.toString(x) + " < " + this.toString(this.min) + ' ' + range);
            }
            if (x > this.max) {
                throw new CannotSaveException(this.toString(x) + " > " + this.toString(this.max) + ' ' + range);
            }
            return BInteger.make((int)x);
        }
    }

    static abstract class Values {
        final int radix;
        final boolean showSeparators;
        final boolean forceSign;
        final DecimalFormat toStringFormat;
        final DecimalFormat fromStringFormat;

        protected Values(Context cx) {
            BFacets facets = cx == null ? BFacets.DEFAULT : cx.getFacets();
            this.radix = facets.geti("radix", 10);
            this.showSeparators = facets.getb("showSeparators", false);
            this.forceSign = facets.getb("forceSign", false);
            String pattern = this.showSeparators ? "#,##0" : "#0";
            this.fromStringFormat = new DecimalFormat(pattern);
            pattern = this.forceSign ? '+' + pattern + ";-" + pattern : pattern;
            this.toStringFormat = new DecimalFormat(pattern);
        }

        abstract boolean loadFacets(BNumber var1, BNumber var2);

        abstract String toString(BObject var1);

        abstract BValue fromString(String var1, String var2) throws CannotSaveException;
    }
}

