/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.io.CryptoStoreId;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxSession;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BCertificateAliasFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateAliasFE.class);
    private static final Logger LOG = Logger.getLogger("workbench");
    private final BTextDropDown field = new BTextDropDown();
    private static final Version version = new Version("3.7");
    private final CryptoStoreId id;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCertificateAliasFE() {
        this(CryptoStoreId.USER_KEY_STORE);
    }

    public BCertificateAliasFE(CryptoStoreId id) {
        this.setContent((BWidget)this.field);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
        this.id = id;
    }

    public void started() {
        BObject currentVal = this.getCurrentValue();
        if (currentVal != null) {
            this.lockModifiedState();
            this.doLoadValue(currentVal, this.getCurrentContext());
            this.unlockModifiedState();
        }
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.field.getEditor().setEditable(!readonly);
        this.field.setDropDownEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject v, Context cx) {
        BString alias = (BString)v;
        this.field.setText(alias.getString());
        this.field.getList().removeAllItems();
        BString purposeId = (BString)cx.getFacet("purposeId");
        Object keyPurpose = purposeId == null ? KeyPurpose.SERVER_CERT : (purposeId.getString().isEmpty() ? null : KeyPurpose.valueOf((String)purposeId.getString()));
        try {
            BWbShell shell = this.getWbShell();
            if (shell == null) {
                return;
            }
            BOrd ord = shell.getActiveOrd();
            if (ord == null) {
                return;
            }
            BComponent service = (BComponent)ord.get();
            if (service == null) {
                return;
            }
            Version remoteVersion = (Version)service.fw(404, (Object)"web", null, null, null);
            if (remoteVersion.compareTo(version) < 0) {
                return;
            }
            BFoxSession session = (BFoxSession)service.getSession();
            BFoxChannel channel = session.getConnection().getChannels().get("crypto", Sys.getType((String)"platCrypto:CryptoChannel"));
            Type type = Sys.getType((String)"platCrypto:CryptoChannel");
            Class cls = type.getTypeClass();
            Method mthd = cls.getMethod("keyStoreGetCertificates", CryptoStoreId.class);
            Iterable certs = AccessController.doPrivileged(() -> (Iterable)mthd.invoke((Object)channel, this.id));
            for (IX509CertificateEntry entry : certs) {
                if (!BCertificateAliasFE.filterCert(entry, keyPurpose)) continue;
                this.field.getList().addItem((Object)entry.getAlias());
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "error loading alias fe", e);
        }
    }

    private static boolean filterCert(IX509CertificateEntry entry, KeyPurpose keyPurpose) {
        if (keyPurpose == null) {
            return true;
        }
        switch (keyPurpose) {
            case CLIENT_CERT: {
                return CertUtils.isClientCert((X509Certificate)entry.getCertificate(0).getCertificate());
            }
            case CA_CERT: {
                return CertUtils.isCACertificate((X509Certificate)entry.getCertificate(0).getCertificate());
            }
            case CODE_SIGNING_CERT: {
                return CertUtils.isCodeSigningCertificate((X509Certificate)entry.getCertificate(0).getCertificate());
            }
        }
        return CertUtils.isServerCertificate((X509Certificate)entry.getCertificate(0).getCertificate());
    }

    @Override
    protected BObject doSaveValue(BObject v, Context cx) {
        return BString.make((String)this.field.getText());
    }
}

