/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.commands;

import com.tridium.sys.transfer.CompToComp;
import com.tridium.workbench.transfer.NTransferContext;
import com.tridium.workbench.transfer.TransferUtil;
import javax.baja.gx.BImage;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.CompoundCommand;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.BWsAnnotation;

public class PasteSpecialCommand
extends Command {
    BComponent target;

    public PasteSpecialCommand(BTransferWidget owner, BComponent target) {
        super((BWidget)owner, UiLexicon.bajaui().module, "commands.pasteSpecial");
        this.target = target;
        this.setEnabled(owner.isPasteSpecialEnabled());
    }

    public CommandArtifact doInvoke() throws Exception {
        BTransferWidget owner = (BTransferWidget)this.getOwner();
        UiLexicon lex = UiLexicon.bajaui();
        BImage icon = BImage.make((String)"module://icons/x32/pasteSpecial.png");
        TransferEnvelope envelope = Clipboard.getDefault().getContents();
        if (envelope == null) {
            BDialog.error((BWidget)owner, (Object)lex.getText("command.paste.emptyClipboard"));
            return null;
        }
        if (!envelope.supports(TransferFormat.mark)) {
            BDialog.error((BWidget)owner, (Object)lex.getText("command.paste.unsupportedFormat"));
            return null;
        }
        Mark mark = (Mark)envelope.getData(TransferFormat.mark);
        if (!mark.areAllValuesComponents()) {
            BDialog.error((BWidget)owner, (Object)lex.getText("command.paste.unsupportedFormat"));
            return null;
        }
        if (mark.isPendingMove()) {
            BDialog.error((BWidget)owner, (Object)lex.getText("pasteSpecial.copyOnly"));
            return null;
        }
        for (int i = 0; i < mark.size(); ++i) {
            BComponent comp = (BComponent)mark.getValue(i);
            if (!this.containsTarget(comp, this.target)) continue;
            BDialog.error((BWidget)owner, (Object)lex.getText("pasteSpecial.selfPaste"));
            return null;
        }
        BTextField numCopiesField = new BTextField("1", 3);
        BGridPane numCopiesPane = new BGridPane(2);
        numCopiesPane.setColumnGap(14.0);
        numCopiesPane.add(null, (BValue)new BLabel(lex.getText("pasteSpecial.numCopies")));
        numCopiesPane.add(null, (BValue)numCopiesField);
        BCheckBox keepLinks = new BCheckBox(lex.getText("pasteSpecial.keepAllLinks"));
        BCheckBox keepRelations = new BCheckBox(lex.getText("pasteSpecial.keepAllRelations"));
        BGridPane prompt = new BGridPane(1);
        prompt.setRowGap(14.0);
        prompt.add(null, (BValue)numCopiesPane);
        prompt.add(null, (BValue)keepLinks);
        prompt.add(null, (BValue)keepRelations);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BWizardHeader(icon, this.getLabel()));
        pane.setCenter((BWidget)new BBorderPane((BWidget)prompt));
        int r = BDialog.open((BWidget)owner, (String)this.getLabel(), (Object)pane, (int)3);
        if (r != 1) {
            return null;
        }
        int numCopies = Integer.parseInt(numCopiesField.getText());
        if (numCopies < 1 || numCopies > 100) {
            throw new Exception("Invalid number of copies, 1-100 only");
        }
        TransferContext cx = owner.makeTransferContext(envelope);
        BComponent params = null;
        if (cx instanceof NTransferContext) {
            params = ((NTransferContext)cx).params;
        }
        if (params == null) {
            params = new BComponent();
        }
        params.add("promptForName", (BValue)BBoolean.FALSE);
        params.add("keepAllLinks", (BValue)BBoolean.make((boolean)keepLinks.isSelected()));
        params.add("keepAllRelations", (BValue)BBoolean.make((boolean)keepRelations.isSelected()));
        BWsAnnotation origin = (BWsAnnotation)params.get("origin");
        if (origin == null) {
            origin = CompToComp.computeOrigin((BObject[])mark.getValues(), (int)mark.size());
            origin = BWsAnnotation.make((int)(origin.p + 1), (int)(origin.q + 1));
            params.add("origin", (BValue)origin);
        }
        CommandArtifact[] arts = new CommandArtifact[numCopies];
        for (int i = 0; i < numCopies; ++i) {
            arts[i] = TransferUtil.insert((BWidget)owner, cx, (BObject)this.target, params);
            origin = BWsAnnotation.make((int)(origin.p + 1), (int)(origin.q + 1));
            params.set("origin", (BValue)origin);
        }
        return new CompoundCommand.Artifact(arts){

            public void redo() {
                throw new LocalizableRuntimeException("bajaui", "pasteSpecial.redoUnsupported");
            }
        };
    }

    private boolean containsTarget(BComponent comp, BComponent target) {
        if (comp == target) {
            return true;
        }
        SlotCursor c = comp.getProperties();
        while (c.nextComponent()) {
            if (!this.containsTarget((BComponent)c.get(), target)) continue;
            return true;
        }
        return false;
    }
}

