/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.commands;

import com.tridium.workbench.commands.LinkMarkCommand;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.commands.LinkCommand;

public abstract class LinkWithMarkCommand
extends Command {
    Array<BComponent> compArray = new Array(BComponent.class);
    public static int MAX_DISPLAY_BUFFER = 75;

    public LinkWithMarkCommand(BWidget owner, String key, BComponent component) {
        super(owner, UiLexicon.bajaui().module, key);
        if (LinkMarkCommand.markOrds == null) {
            this.setEnabled(false);
        }
        if (component != null) {
            this.compArray.add((Object)component);
        }
    }

    public String getLabel() {
        String base = super.getLabel();
        String[] displayNames = LinkMarkCommand.markDisplayNames;
        if (displayNames == null) {
            return base;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(base);
        for (int i = 0; i < displayNames.length; ++i) {
            if (i > 0) {
                buff.append(",");
            }
            buff.append(" \"");
            buff.append(displayNames[i]);
            buff.append("\"");
            if (buff.length() <= MAX_DISPLAY_BUFFER) continue;
            buff.append("...");
            break;
        }
        return buff.toString();
    }

    public CommandArtifact doInvoke() throws Exception {
        int i;
        BatchResolve resolve = new BatchResolve(LinkMarkCommand.markOrds);
        resolve.resolve(null);
        BComponent[] marks = resolve.getTargetComponents();
        BComponent[] comps = (BComponent[])this.compArray.trim();
        BComponentSpace space = marks[0].getComponentSpace();
        boolean err = false;
        for (i = 1; i < marks.length; ++i) {
            if (marks[i].getComponentSpace() == space) continue;
            err = true;
            break;
        }
        if (!err) {
            for (i = 0; i < comps.length; ++i) {
                if (comps[i].getComponentSpace() == space) continue;
                err = true;
                break;
            }
        }
        if (err) {
            String msg = UiLexicon.bajaui().getText("linking.interSpace.error");
            BDialog.error((BWidget)this.getShell(), null, (Object)msg);
            return null;
        }
        BComponent[] sources = this.isMarkToComponent() ? marks : comps;
        BComponent[] targets = this.isMarkToComponent() ? comps : marks;
        return new LinkCommand(this.getShell(), sources, null, targets, null).doInvoke();
    }

    protected void mergeCommands(LinkWithMarkCommand cmd1, LinkWithMarkCommand cmd2) {
        this.compArray = cmd2.compArray;
        this.compArray.addAll(cmd1.compArray);
    }

    abstract boolean isMarkToComponent();
}

