/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.celltable;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.celltable.CellController;
import com.tridium.workbench.celltable.CellEditorContainer;
import java.util.HashMap;
import java.util.Map;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.workbench.celleditor.BWbCellEditor;

@NiagaraType
@NiagaraTopic(name="modified", eventType="BWidgetEvent")
public abstract class BAbstractCellTable
extends BTable
implements CellEditorContainer {
    @Generated
    public static final Topic modified = BAbstractCellTable.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractCellTable.class);
    private CellController cellController;
    protected final String[] colNames;
    protected Map<BWbCellEditor, String> rowLinks = new HashMap<BWbCellEditor, String>();
    protected int stemCtr;
    private boolean isLabeled;
    private boolean dragging = false;
    private boolean cellsEnabled = true;

    @Generated
    public void fireModified(BWidgetEvent event) {
        this.fire(modified, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAbstractCellTable(String[] colNames, boolean isLabeled) {
        this.colNames = colNames;
        this.isLabeled = isLabeled;
        this.setStyleClasses("cell-table");
        this.setCellRenderer(new CellRenderer());
        this.setHeaderRenderer(new HeaderRenderer());
        this.setController(new Controller());
        this.setMultipleSelection(false);
        this.setGridBrush(Theme.widget().getControlShadow());
        this.setHscrollBarVisible(false);
        this.setVscrollBarVisible(false);
        this.setCellController(new CellController());
    }

    @Override
    public CellController getCellController() {
        return this.cellController;
    }

    @Override
    public void setCellController(CellController c) {
        this.installSupport(this.cellController, c);
        this.cellController = c;
    }

    private void installSupport(BTable.TableSupport old, BTable.TableSupport support) {
        if (support == null) {
            throw new NullPointerException();
        }
        if (old == support) {
            return;
        }
        if (support.getTable() != null) {
            throw new IllegalArgumentException("Already installed on another table");
        }
        if (old != null) {
            old.setTable(null);
        }
        support.setTable((BTable)this);
    }

    protected abstract double[] preferredCellWidths();

    protected final void checkEnabled(BWbCellEditor[] cells) {
        for (int i = 0; i < cells.length; ++i) {
            if (cells[i].isReadonly()) continue;
            cells[i].setReadonly(!this.cellsEnabled);
        }
    }

    public abstract void removeRow(int var1);

    public abstract void clearRows();

    public abstract int getRowCount();

    public abstract BWbCellEditor[] getRowCells(int var1);

    public void setCellsEnabled(boolean cellsEnabled) {
        this.cellsEnabled = cellsEnabled;
    }

    public static class Controller
    extends TableController {
        protected void resizeHotspotPressed(BMouseEvent event, int column) {
            this.table().dragging = true;
        }

        protected void resizeHotspotDragged(BMouseEvent event, int column) {
            BAbstractCellTable table = this.table();
            table.setColumnPosition(column, event.getX());
            table.preferredCellWidths()[column] = table.getCellWidth(column);
            table.relayout();
        }

        protected void resizeHotspotReleased(BMouseEvent event, int column) {
            BAbstractCellTable table = this.table();
            table.dragging = false;
            table.preferredCellWidths()[column] = table.getCellWidth(column);
            table.relayout();
        }

        protected BMenu makeOptionsMenu() {
            BMenu menu = super.makeOptionsMenu();
            menu.keep(new String[]{"resizeColumns"});
            return menu;
        }

        private BAbstractCellTable table() {
            return (BAbstractCellTable)this.getTable();
        }
    }

    public static class CellRenderer
    extends TableCellRenderer {
        public final double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return this.table().preferredCellWidths()[cell.column];
        }

        public final void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            if (this.table().isLabeled && cell.column == 0) {
                super.paintCell(g, cell);
            } else {
                this.paintCellBackground(g, cell);
            }
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (!this.getTable().isEnabled()) {
                return BBrush.makeSolid((BColor)BColor.gainsboro);
            }
            return null;
        }

        private BAbstractCellTable table() {
            return (BAbstractCellTable)this.getTable();
        }
    }

    public static class HeaderRenderer
    extends TableHeaderRenderer {
        public double getPreferredHeaderWidth(TableHeaderRenderer.Header header) {
            double d = super.getPreferredHeaderWidth(header);
            return Math.max(this.table().preferredCellWidths()[header.column], d);
        }

        private BAbstractCellTable table() {
            return (BAbstractCellTable)this.getTable();
        }
    }
}

