/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.cellmini;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListRenderer;

@NiagaraType
public class BMiniListDropDownDisplay
extends BWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BMiniListDropDownDisplay.class);
    private ListRenderer.Item item = new ListRenderer.Item();
    boolean isFocusTraversable = true;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BList getList() {
        BListDropDown parent = (BListDropDown)this.getParent();
        if (parent != null) {
            return parent.getList();
        }
        return null;
    }

    public void openDropDown() {
        BListDropDown parent = (BListDropDown)this.getParent();
        if (parent != null) {
            parent.openDropDown();
        }
    }

    public void computePreferredSize() {
        BList list = this.getList();
        if (list == null) {
            return;
        }
        list.computePreferredSize();
        this.setPreferredSize(list.getPreferredWidth() + 2.0, list.getRenderer().getItemHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        BListDropDown parent = (BListDropDown)this.getParent();
        BList list = this.getList();
        if (list == null) {
            return;
        }
        double w = this.getWidth();
        double h = this.getHeight();
        g.push();
        try {
            g.translate(-1.0, -2.0);
            if (parent.isDropDownOpen()) {
                if (this.item.value != null) {
                    this.paintItem(g, this.item);
                }
            } else {
                int index = list.getSelectedIndex();
                if (index != -1 && list.getItemCount() > 0) {
                    this.item.index = index;
                    this.item.icon = list.getModel().getItemIcon(index);
                    this.item.value = list.getModel().getItem(index);
                    this.item.width = (int)w - 2;
                    this.item.height = (int)h;
                    this.paintItem(g, this.item);
                }
            }
        }
        finally {
            g.pop();
        }
    }

    private void paintItem(Graphics g, ListRenderer.Item item) {
        BFont f = Theme.table().getCellFont();
        g.setFont(f);
        g.setBrush(Theme.table().getTextBrush());
        g.drawString(String.valueOf(item.value), 4.0, f.getAscent() + 2.0);
    }

    public boolean isFocusTraversable() {
        return this.isFocusTraversable;
    }

    public void setFocusTraversable(boolean isFocusTraversable) {
        this.isFocusTraversable = isFocusTraversable;
    }

    public void mousePressed(BMouseEvent event) {
        this.getParentWidget().mousePressed(event);
    }

    public void keyPressed(BKeyEvent event) {
        BListDropDown parent = (BListDropDown)this.getParent();
        if (event.getKeyCode() == 10) {
            parent.fireActionPerformed(new BWidgetEvent(2, (BWidget)parent));
        } else if (event.getKeyCode() == 40) {
            parent.openDropDown();
        }
    }
}

