/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.fox.sys.BFoxScheme;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.auth.CredentialsList;
import com.tridium.workbench.ord.BFoxSessionOrdFE;
import com.tridium.workbench.ord.BHostOrdFE;
import com.tridium.workbench.shell.BGeneralOptions;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BICredentials;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@Deprecated
@NiagaraActions(value={@NiagaraAction(name="addressModified"), @NiagaraAction(name="hostSchemeModified")})
public class BOpenPane
extends BEdgePane {
    @Generated
    public static final Action addressModified = BOpenPane.newAction((int)0, null);
    @Generated
    public static final Action hostSchemeModified = BOpenPane.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpenPane.class);
    public static final BImage logo = BImage.make((String)"module://icons/x32/connect.png");
    public static final BImage keys = BImage.make((String)"module://icons/x16/keys.png");
    protected BHostOrdFE host;
    protected BWbFieldEditor credentialsEditor;
    protected BCheckBox saveCredentials;
    protected AuthUtil.OpenHandler handler;
    BTextField port;
    boolean isFox;

    @Generated
    public void addressModified() {
        this.invoke(addressModified, null, null);
    }

    @Generated
    public void hostSchemeModified() {
        this.invoke(hostSchemeModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOpenPane() {
    }

    public BOpenPane(AuthUtil.OpenHandler handler) {
        this.handler = handler;
        this.buildContent();
    }

    protected void buildContent() {
        UiLexicon lex = UiLexicon.bajaui();
        BFont bold = Theme.widget().getBoldText();
        BLabel logoLabel = new BLabel(logo);
        logoLabel.setValign(BValign.top);
        this.isFox = "fox".equals(this.handler.sessionScheme);
        this.host = this.isFox ? new BFoxSessionOrdFE(true) : new BHostOrdFE();
        this.host.setAutoSaveHistory(false);
        BFacets facets = BFacets.make((String)"wbMenu", (BIDataValue)BString.make((String)"true"));
        BasicContext context = new BasicContext((Context)facets);
        if (this.handler.hostOrd != null) {
            BOrd ord = null;
            ord = this.isFox ? BOrd.make((String)this.handler.addressToOrd()) : this.handler.hostOrd;
            this.host.loadValue((BObject)ord, (Context)context);
            this.host.setReadonly(true);
        } else {
            this.host.loadValue((BObject)BOrd.NULL, (Context)context);
            this.host.doSetModified();
        }
        this.linkTo((BComponent)this.host, (Slot)BHostOrdFE.setModified, (Slot)addressModified);
        this.linkTo((BComponent)this.host, (Slot)BHostOrdFE.mruModified, (Slot)hostSchemeModified);
        this.linkTo((BComponent)this.host, (Slot)BHostOrdFE.dropDownModified, (Slot)hostSchemeModified);
        BHostOrdFE addr = null;
        if (this.isFox) {
            addr = this.host;
        } else {
            this.port = new BTextField("" + this.handler.port, 6);
            this.linkTo((BComponent)this.port, (Slot)BTextField.textModified, (Slot)addressModified);
            BGridPane addrInput = new BGridPane(2);
            addrInput.add(null, (BValue)new BLabel(UiLexicon.bajaui().getText("auth.host"), bold));
            addrInput.add(null, (BValue)this.host);
            addrInput.add(null, (BValue)new BLabel(UiLexicon.bajaui().getText("auth.port"), bold));
            addrInput.add(null, (BValue)this.port);
            addr = addrInput;
        }
        BObject cred = this.handler.credentials.asObject();
        this.credentialsEditor = BWbFieldEditor.makeFor(cred);
        this.credentialsEditor.loadValue(cred);
        BGridPane credInput = new BGridPane(1);
        credInput.setHalign(BHalign.left);
        credInput.add(null, (BValue)new BLabel(lex.getText("auth.credentials"), bold));
        credInput.add(null, (BValue)new BBorderPane((BWidget)this.credentialsEditor, 0.0, 0.0, 0.0, 20.0));
        BGeneralOptions gopt = BGeneralOptions.make();
        boolean allowCaching = gopt.getAllowUserCredentialCaching();
        if (!allowCaching) {
            AuthUtil.saveCredentials = false;
        }
        this.saveCredentials = new BCheckBox(lex.get("auth.saveCredentials", "Remember these credentials"), AuthUtil.saveCredentials);
        this.saveCredentials.setEnabled(allowCaching);
        BGridPane grid = new BGridPane(1);
        grid.setRowGap(10.0);
        grid.add(null, (BValue)addr);
        grid.add(null, (BValue)credInput);
        grid.add(null, (BValue)this.saveCredentials);
        this.setTop((BWidget)new BWizardHeader(logo, this.handler.title, this.handler.description));
        this.setCenter((BWidget)new BBorderPane((BWidget)grid, 6.0, 2.0, 2.0, 2.0));
        if (!this.isFox) {
            this.doHostSchemeModified();
        }
    }

    public void doAddressModified() {
        try {
            BICredentials cred;
            this.saveAddress();
            String realm = this.handler.toAuthenticationRealm();
            if (realm != null && (cred = CredentialsList.INSTANCE.lookup(realm)) != null && cred.getClass() == this.handler.credentials.getClass()) {
                this.credentialsEditor.loadValue((BObject)cred);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.credentialsEditor.loadValue((BObject)this.handler.credentials);
    }

    public void doHostSchemeModified() {
        if (!this.isFox) {
            this.port.setText("3011");
        }
    }

    public void saveAddress() throws CannotSaveException {
        if (!this.isFox) {
            try {
                this.handler.port = Integer.parseInt(this.port.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            BOrd ord = (BOrd)this.host.saveValue();
            if (ord.isNull() || !this.isFox) {
                this.handler.hostOrd = ord;
            } else if (this.isFox) {
                OrdQuery[] queries = ord.parse();
                this.handler.hostOrd = BOrd.make((OrdQuery)queries[0]);
                int foxPort = 1911;
                for (int i = 1; i < queries.length; ++i) {
                    if (!(queries[i] instanceof BFoxScheme.FoxQuery)) continue;
                    BFoxScheme.FoxQuery foxQuery = (BFoxScheme.FoxQuery)queries[i];
                    foxPort = foxQuery.getPort();
                    break;
                }
                this.handler.port = foxPort;
            }
        }
        catch (CannotSaveException cse) {
            throw cse;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

