/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.ord.BHostOrdFE;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BICredentials;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;

@NiagaraType
public abstract class BHostCnxHandler
extends BCnxHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BHostCnxHandler.class);
    protected BHostOrdFE ordFE;
    protected String sessionScheme;
    protected BOrd hostOrd;
    protected int port;
    protected int defaultPort;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHostCnxHandler(String sessionScheme, int defaultPort, BHostOrdFE ordFE, BICredentials defCred) {
        this(sessionScheme, defaultPort, ordFE, defCred, null, null);
    }

    public BHostCnxHandler(String sessionScheme, int defaultPort, BHostOrdFE ordFE, BICredentials defCred, Lexicon lex, String key) {
        super(defCred, lex, key);
        this.ordFE = ordFE;
        this.sessionScheme = sessionScheme;
        this.defaultPort = defaultPort;
        this.port = defaultPort;
    }

    @Override
    public BOrd toHyperlink() {
        return BOrd.make((String)this.addressToOrd());
    }

    @Override
    public String toAuthenticationRealm() {
        return this.addressToOrd();
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    public BOrd getHostOrd() {
        return this.hostOrd;
    }

    public void setHost(BHost host) {
        if (host == null) {
            return;
        }
        this.hostOrd = host.getAbsoluteOrd();
        BFacets facets = BFacets.make((String)"wbMenu", (BIDataValue)BString.make((String)"true"));
        BasicContext context = new BasicContext((Context)facets);
        this.ordFE.loadValue((BObject)this.hostOrd, (Context)context);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getSessionScheme() {
        return this.sessionScheme;
    }

    @Override
    public BWbPlugin getCnxEditor() {
        return this.ordFE;
    }

    protected String addressToOrd() {
        String ord = "";
        if (null != this.hostOrd) {
            ord = this.hostOrd.toString() + "|" + this.sessionScheme + ":";
            if (this.port != this.defaultPort) {
                ord = ord + this.port;
            }
        }
        return ord;
    }
}

