/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.auth.BCredentialsEditor;
import com.tridium.workbench.auth.BDeviceCnxType;
import com.tridium.workbench.auth.BHostCnxHandler;
import com.tridium.workbench.auth.BPlatformCnxType;
import com.tridium.workbench.auth.BStationCnxType;
import com.tridium.workbench.nav.BSessionAgent;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BICredentials;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="saveCnx"), @NiagaraAction(name="clearCnx")})
public abstract class BCnxHandler
extends BComponent
implements BIAgent {
    @Generated
    public static final Action saveCnx = BCnxHandler.newAction((int)0, null);
    @Generated
    public static final Action clearCnx = BCnxHandler.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCnxHandler.class);
    public static final String LEX_DESC_FIELD = ".description";
    public static final String LEX_TITLE_FIELD = ".title";
    public static final String LEX_ICON_FIELD = ".icon";
    public static final String LEX_LABEL = ".label";
    public static final String LEX_DISPLAY_NAME = ".displayName";
    private Lexicon lexicon;
    private String key;
    protected BICredentials credentials;
    protected BCredentialsEditor credFE;

    @Generated
    public void saveCnx() {
        this.invoke(saveCnx, null, null);
    }

    @Generated
    public void clearCnx() {
        this.invoke(clearCnx, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCnxHandler(BICredentials cred) {
        this.setCredentials(cred);
    }

    public BCnxHandler(BICredentials cred, Lexicon lex, String lexKey) {
        this(cred);
        this.key = lexKey;
        this.lexicon = lex;
    }

    public String getTitle() {
        if (null != this.lexicon && null != this.key) {
            return this.lexicon.getText(this.key + LEX_TITLE_FIELD);
        }
        return null;
    }

    public String getDescription() {
        if (null != this.lexicon && null != this.key) {
            return this.lexicon.getText(this.key + LEX_DESC_FIELD);
        }
        return null;
    }

    public BIcon getIcon() {
        String icon;
        if (null != this.lexicon && null != this.key && null != (icon = this.lexicon.get(this.key + LEX_ICON_FIELD))) {
            return BIcon.make((String)icon);
        }
        return null;
    }

    public String getLabel() {
        if (null != this.lexicon && null != this.key) {
            return this.lexicon.getText(this.key + LEX_LABEL);
        }
        return null;
    }

    public String toString(Context cx) {
        return this.getType().getModule().getLexicon().getText(this.key + LEX_DISPLAY_NAME);
    }

    public final BICredentials getCredentials() throws CannotSaveException, Exception {
        return (BICredentials)this.credFE.saveValue();
    }

    public void setCredentials(BICredentials credentials) {
        if (null == credentials) {
            throw new BajaRuntimeException("Cannot instantiate a BCnxHandler with NULL default credential type.");
        }
        this.credFE = (BCredentialsEditor)BWbFieldEditor.makeFor(credentials.asObject());
        this.credFE.loadValue(credentials.asObject());
        this.credentials = credentials;
    }

    public final BCredentialsEditor getCredentialsFE() {
        return this.credFE;
    }

    public abstract String toAuthenticationRealm();

    public abstract BOrd toHyperlink();

    public abstract BWbPlugin getCnxEditor();

    public abstract boolean isSecure();

    public abstract void doSaveCnx();

    public abstract void doClearCnx();

    public static Command[] getCnxCommands(BWidget owner, BHost host) {
        LinkedList<Command> commands = new LinkedList<Command>();
        TypeInfo[] cnxTypes = new TypeInfo[]{BPlatformCnxType.TYPE.getTypeInfo(), BStationCnxType.TYPE.getTypeInfo(), BDeviceCnxType.TYPE.getTypeInfo()};
        for (int i = 0; i < cnxTypes.length; ++i) {
            BCnxHandler[] handlers = BCnxHandler.getHandlersOnType(cnxTypes[i], host);
            if (handlers.length <= 0) continue;
            CnxCommand cmd = new CnxCommand(owner, cnxTypes[i].getTypeName(), handlers);
            commands.add(cmd);
        }
        BSessionAgent.OpenCommand[] openCommands = BCnxHandler.listOpenCommands(owner, host);
        commands.addAll(Arrays.asList(openCommands));
        return commands.toArray(new Command[0]);
    }

    public static BCnxHandler[] getHandlersOnType(TypeInfo info, BHost host) {
        AgentList agents = Sys.getRegistry().getAgents(info);
        AgentList filter = agents.filter((AgentFilter)new Filter());
        BCnxHandler[] handlers = new BCnxHandler[filter.size()];
        for (int i = 0; i < filter.size(); ++i) {
            AgentInfo agentInfo = filter.get(i);
            BCnxHandler handler = (BCnxHandler)agentInfo.getInstance();
            if (handler instanceof BHostCnxHandler) {
                ((BHostCnxHandler)handler).setHost(host);
            }
            handlers[i] = handler;
        }
        return BCnxHandler.getPreferredHandlerOrder(handlers);
    }

    private static BSessionAgent.OpenCommand[] listOpenCommands(BWidget owner, BHost host) {
        BNiagaraWbShell shell = (BNiagaraWbShell)owner.getShell();
        ArrayList<BSessionAgent.OpenCommand> list = new ArrayList<BSessionAgent.OpenCommand>();
        BSessionAgent[] agents = BCnxHandler.listSessionAgents();
        for (int i = 0; i < agents.length; ++i) {
            try {
                BOrd ord;
                BSessionAgent.OpenCommand cmd = agents[i].getOpenCommand(owner, host);
                if (cmd == null || !shell.profile.canHyperlink(ord = BOrd.make((String)("local:|" + cmd.sessionScheme + ":")))) continue;
                list.add(cmd);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list.toArray(new BSessionAgent.OpenCommand[0]);
    }

    private static BSessionAgent[] listSessionAgents() {
        TypeInfo[] types = Sys.getRegistry().getTypes(BSessionAgent.TYPE.getTypeInfo());
        ArrayList<BSessionAgent> list = new ArrayList<BSessionAgent>();
        for (int i = 0; i < types.length; ++i) {
            try {
                Type t = types[i].getTypeSpec().getResolvedType();
                if (t.isAbstract()) continue;
                list.add((BSessionAgent)t.getInstance());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list.toArray(new BSessionAgent[0]);
    }

    private static BCnxHandler[] getPreferredHandlerOrder(BCnxHandler[] handlers) {
        LinkedList<BCnxHandler> secureHandlers = new LinkedList<BCnxHandler>();
        LinkedList<BCnxHandler> nonSecureHandlers = new LinkedList<BCnxHandler>();
        for (int i = 0; i < handlers.length; ++i) {
            if (handlers[i].isSecure()) {
                secureHandlers.add(handlers[i]);
                continue;
            }
            nonSecureHandlers.add(handlers[i]);
        }
        BGeneralOptions options = BGeneralOptions.make();
        if (options.getIsDefaultConnectionTypeSsl()) {
            secureHandlers.addAll(nonSecureHandlers);
        } else {
            secureHandlers.addAll(0, nonSecureHandlers);
        }
        return secureHandlers.toArray(new BCnxHandler[0]);
    }

    private static class Filter
    extends AgentFilter {
        private Filter() {
        }

        public boolean include(AgentInfo agent) {
            boolean isAbstract = agent.getAgentType().isAbstract();
            boolean isHandler = agent.getAgentType().is(TYPE.getTypeInfo());
            return !isAbstract && isHandler;
        }
    }

    public static class CnxCommand
    extends Command {
        private BCnxHandler[] handlers;

        public CnxCommand(BWidget owner, String key, BCnxHandler[] handlers) {
            super(owner, TYPE.getModule().getLexicon(), key);
            this.handlers = handlers;
        }

        public CommandArtifact doInvoke() throws Exception {
            this.handlers = BCnxHandler.getPreferredHandlerOrder(this.handlers);
            AuthUtil.connect(this.getOwner(), this.handlers);
            return null;
        }
    }
}

