/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.history.ui.chart.HistoryItem;
import com.tridium.history.ui.chart.HistoryListModel;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.BBrushSwatch;
import com.tridium.workbench.colorchooser.BColorChooser;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="updateChartType", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4)
public class BHistoryList
extends BTransferWidget {
    @Generated
    public static final Action updateChartType = BHistoryList.newAction((int)4, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryList.class);
    static BImage iconLine = BHistoryList.img("line.png");
    static BImage iconArea = BHistoryList.img("area.png");
    static BImage iconBar = BHistoryList.img("bar.png");
    static BImage iconStackBar = BHistoryList.img("bar.png");
    static BImage iconDisLine = BHistoryList.img("discreteLine.png");
    static BImage iconDisArea = BHistoryList.img("discreteArea.png");
    static BImage iconPie = BHistoryList.img("pie.png");
    static BModule module = Sys.getModuleForClass(BHistoryList.class);
    static Lexicon lex = Lexicon.make((String)"history");
    static String lexEmpty = lex.getText("chartBuilder.noSelections");
    private HistoryListModel model;

    @Generated
    public void updateChartType(BWidgetEvent parameter) {
        this.invoke(updateChartType, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistoryList() {
        this(new HistoryListModel());
    }

    public BHistoryList(HistoryListModel model) {
        this.setModel(model);
    }

    public HistoryListModel getModel() {
        return this.model;
    }

    public void setModel(HistoryListModel model) {
        if (this.model != null) {
            this.model.setOwner(null);
        }
        this.model = model;
        this.model.setOwner(this);
        this.modelChanged();
    }

    public void modelChanged() {
        this.rebuild();
    }

    public TransferEnvelope getTransferData() {
        return null;
    }

    public CommandArtifact drop(TransferContext cx) {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        BIHistory[] histories = new BIHistory[mark.size()];
        for (int i = 0; i < histories.length; ++i) {
            histories[i] = (BIHistory)mark.getValue(i);
        }
        this.model.add(histories);
        return null;
    }

    public CommandArtifact insertTransferData(TransferContext cx) {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        BIHistory[] histories = new BIHistory[mark.size()];
        for (int i = 0; i < histories.length; ++i) {
            histories[i] = (BIHistory)mark.getValue(i);
        }
        this.model.add(histories);
        return null;
    }

    public CommandArtifact removeTransferData(TransferContext cx) {
        return null;
    }

    public int dragOver(TransferContext cx) {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        int valCount = mark.size();
        for (int i = 0; i < valCount; ++i) {
            if (!(mark.getValue(i) instanceof BIHistory)) {
                return 0;
            }
            BIHistory history = (BIHistory)mark.getValue(i);
            BTypeSpec recTypeSpec = history.getRecordType();
            Type type = recTypeSpec.getResolvedType();
            if (type.is(BTrendRecord.TYPE)) continue;
            return 0;
        }
        return 16;
    }

    public void computePreferredSize() {
        double pw = 0.0;
        double ph = 0.0;
        if (this.model.size() == 0) {
            BFont font = Theme.widget().getTextFont();
            pw = font.width(lexEmpty) + 10.0;
            ph = font.getHeight() + 10.0;
        } else {
            BWidget w = (BWidget)this.get("content");
            w.computePreferredSize();
            pw = w.getPreferredWidth();
            ph = w.getPreferredHeight() + 15.0;
        }
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] layout) {
        if (this.model.size() == 0) {
            return;
        }
        BWidget w = (BWidget)this.get("content");
        w.computePreferredSize();
        w.setBounds(0.0, 0.0, this.getWidth(), w.getPreferredHeight());
    }

    public void paint(Graphics g) {
        if (this.model.size() == 0) {
            BFont font = Theme.widget().getTextFont();
            double w = this.getWidth();
            double h = this.getHeight();
            double x = (w - font.width(lexEmpty)) / 2.0;
            double y = (h - font.getAscent()) / 2.0;
            g.setFont(font);
            g.setBrush(BColor.black);
            g.drawString(lexEmpty, x, y + font.getAscent());
        } else {
            super.paint(g);
        }
    }

    private void rebuild() {
        int i;
        if (this.model.size() == 0) {
            this.removeAll();
            this.add("content", (BValue)new BNullWidget());
            return;
        }
        BGridPane grid = new BGridPane(4);
        grid.setColumnAlign(BHalign.fill);
        grid.setStretchColumn(3);
        grid.setColumnGap(10.0);
        ArrayList<BLink> links = new ArrayList<BLink>();
        for (i = 0; i < this.model.size(); ++i) {
            HistoryItem item = this.model.get(i);
            BBrushSwatch swatch = new BBrushSwatch(item.getBrush());
            swatch.setPreferredSize(16.0, 16.0);
            swatch.setController((BBrushSwatch.Controller)new SwatchController());
            BListDropDown list = this.makeChartList(item.getChartType());
            links.add(new BLink((BComponent)list, (Slot)BDropDown.valueModified, (Slot)updateChartType));
            BGridPane cmds = new BGridPane(3);
            cmds.setHalign(BHalign.right);
            cmds.setColumnGap(0.0);
            cmds.add(null, (BValue)this.makeButton(new MoveUp((BWidget)this, item)));
            cmds.add(null, (BValue)this.makeButton(new MoveDown((BWidget)this, item)));
            cmds.add(null, (BValue)this.makeButton(new Delete((BWidget)this, item)));
            grid.add("swatch_" + i, (BValue)swatch);
            grid.add(null, (BValue)new BLabel(item.toString(), BHalign.left));
            grid.add("list_" + i, (BValue)list);
            grid.add(null, (BValue)cmds);
        }
        this.removeAll();
        this.add("content", (BValue)new BBorderPane((BWidget)grid, BInsets.make((double)5.0)));
        for (i = 0; i < links.size(); ++i) {
            this.add(null, (BValue)links.get(i));
        }
    }

    private BListDropDown makeChartList(BTypeSpec current) {
        BListDropDown list = new BListDropDown();
        BList z = list.getList();
        z.setModel((javax.baja.ui.list.ListModel)new ListModel());
        z.addItem((Object)new Item(HistoryItem.LineChart, lex.getText("chartBuilder.chartType.line"), iconLine));
        z.addItem((Object)new Item(HistoryItem.AreaChart, lex.getText("chartBuilder.chartType.area"), iconArea));
        z.addItem((Object)new Item(HistoryItem.BarChart, lex.getText("chartBuilder.chartType.bar"), iconBar));
        z.addItem((Object)new Item(HistoryItem.StackedBarChart, lex.getText("chartBuilder.chartType.stackedBar"), iconStackBar));
        z.addItem((Object)new Item(HistoryItem.DiscreteLineChart, lex.getText("chartBuilder.chartType.discreteLine"), iconDisLine));
        z.addItem((Object)new Item(HistoryItem.DiscreteAreaChart, lex.getText("chartBuilder.chartType.discreteArea"), iconDisArea));
        z.addItem((Object)new Item(HistoryItem.PieChart, lex.getText("chartBuilder.chartType.pie"), iconPie));
        int sel = 0;
        if (current.equals((Object)HistoryItem.LineChart)) {
            sel = 0;
        } else if (current.equals((Object)HistoryItem.AreaChart)) {
            sel = 1;
        } else if (current.equals((Object)HistoryItem.BarChart)) {
            sel = 2;
        } else if (current.equals((Object)HistoryItem.StackedBarChart)) {
            sel = 3;
        } else if (current.equals((Object)HistoryItem.DiscreteLineChart)) {
            sel = 4;
        } else if (current.equals((Object)HistoryItem.DiscreteAreaChart)) {
            sel = 5;
        } else if (current.equals((Object)HistoryItem.PieChart)) {
            sel = 6;
        }
        list.getList().setSelectedIndex(sel);
        return list;
    }

    private BButton makeButton(Command c) {
        BButton b = new BButton(c, false, true);
        b.setBackground(Theme.widget().getWindowBackground());
        b.setButtonStyle(BButtonStyle.toolBar);
        return b;
    }

    public void doUpdateChartType(BWidgetEvent event) {
        BListDropDown list = (BListDropDown)event.getWidget();
        Item item = (Item)((Object)list.getList().getSelectedItem());
        BTypeSpec spec = item.spec;
        int i = this.findIndex(list.getName());
        this.model.get(i).setChartType(spec);
    }

    private int findIndex(String s) {
        int i = s.indexOf("_");
        return Integer.parseInt(s.substring(i + 1));
    }

    static BImage img(String s) {
        return BImage.make((String)("module://icons/x16/charts/" + s));
    }

    class Delete
    extends Command {
        private HistoryItem item;

        public Delete(BWidget owner, HistoryItem item) {
            super(owner, module, "chartBuilder.command.delete");
            this.item = item;
        }

        public CommandArtifact doInvoke() {
            BHistoryList.this.model.remove(this.item);
            return null;
        }
    }

    class MoveDown
    extends Command {
        private HistoryItem item;

        public MoveDown(BWidget owner, HistoryItem item) {
            super(owner, module, "chartBuilder.command.moveDown");
            this.item = item;
        }

        public CommandArtifact doInvoke() {
            BHistoryList.this.model.moveDown(this.item);
            return null;
        }
    }

    class MoveUp
    extends Command {
        private HistoryItem item;

        public MoveUp(BWidget owner, HistoryItem item) {
            super(owner, module, "chartBuilder.command.moveUp");
            this.item = item;
        }

        public CommandArtifact doInvoke() {
            BHistoryList.this.model.moveUp(this.item);
            return null;
        }
    }

    class Item
    extends DefaultListModel.Item {
        BTypeSpec spec;
        String label;

        public Item(BTypeSpec spec, String label, BImage icon) {
            super(icon, (Object)label);
            this.label = label;
            this.spec = spec;
        }

        public String toString() {
            return this.label;
        }
    }

    class ListModel
    extends DefaultListModel {
        ListModel() {
        }

        public BImage getItemIcon(int index) {
            DefaultListModel.Item item = (DefaultListModel.Item)this.getItem(index);
            return item.icon;
        }
    }

    private class SwatchController
    extends BBrushSwatch.Controller {
        private SwatchController() {
        }

        public void mousePressed(BMouseEvent event) {
        }

        public void mouseReleased(BMouseEvent event) {
            BColor c = BColor.red;
            BBrush b = this.swatch.getBrush();
            if (b.getPaint() instanceof BBrush.Solid) {
                c = ((BBrush.Solid)b.getPaint()).getColor();
            }
            if ((c = BColorChooser.openInDialog((BWidget)this.swatch, (BColor)c)) != null) {
                BBrush brush = c.toBrush();
                this.swatch.setBrush(brush);
                this.swatch.repaint();
                int i = BHistoryList.this.findIndex(this.swatch.getName());
                BHistoryList.this.model.get(i).setBrush(brush);
            }
        }

        public void mouseEntered(BMouseEvent event) {
            BWidget widget = event.getWidget();
            widget.setMouseCursor(MouseCursor.dropper);
        }

        public void mouseExited(BMouseEvent event) {
            BWidget widget = event.getWidget();
            widget.setMouseCursor(MouseCursor.normal);
        }
    }
}

