/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.history.ui.BConfigDisplay;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"history:IHistory", "history:HistoryExt"}, requiredPermissions="r")})
public class BHistorySummaryView
extends BWbView {
    @Generated
    public static final Type TYPE = Sys.loadType(BHistorySummaryView.class);
    private static final Lexicon LEX = Lexicon.make((String)"history");
    private static final Lexicon NIAGARA_LEX = Lexicon.make((String)"niagaraDriver");
    private static final String LOCAL_SUFFIX = ' ' + LEX.get("localSuffix", '(' + (BHistorySummaryView.NIAGARA_LEX.module != null ? NIAGARA_LEX.get("historyExportManager.local", "Local") : "Local") + ')');
    private static final String RECORD_COUNT = LEX.get("localRecordCount", LEX.getText("recordCount") + LOCAL_SUFFIX);
    private static final String FIRST_TIMESTAMP = LEX.get("firstLocalTimestamp", LEX.getText("firstTimestamp") + LOCAL_SUFFIX);
    private static final String LAST_TIMESTAMP = LEX.get("lastLocalTimestamp", LEX.getText("lastTimestamp") + LOCAL_SUFFIX);
    private static final String STATUS = LEX.getText("status");
    private static final String CONFIGURATION = LEX.getText("configuration");
    private final BConfigDisplay cfg;
    private final BWbFieldEditor firstTs;
    private final BWbFieldEditor lastTs;
    private final BWbFieldEditor recCount;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistorySummaryView() {
        BEdgePane outer = new BEdgePane();
        BGridPane statusPane = new BGridPane(2);
        statusPane.setHalign(BHalign.left);
        statusPane.setValign(BValign.top);
        statusPane.setColumnAlign(BHalign.left);
        statusPane.setRowAlign(BValign.top);
        statusPane.setColumnGap(15.0);
        statusPane.add(null, (BValue)new BLabel(RECORD_COUNT));
        this.recCount = BWbFieldEditor.makeFor((BObject)BInteger.make((int)0));
        this.recCount.setReadonly(true);
        statusPane.add("recCount", (BValue)this.recCount);
        statusPane.add(null, (BValue)new BLabel(FIRST_TIMESTAMP));
        this.firstTs = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT);
        this.firstTs.setReadonly(true);
        statusPane.add("firstTs", (BValue)this.firstTs);
        statusPane.add(null, (BValue)new BLabel(LAST_TIMESTAMP));
        this.lastTs = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT);
        this.lastTs.setReadonly(true);
        statusPane.add("lastTs", (BValue)this.lastTs);
        outer.setTop((BWidget)new BBorderPane((BWidget)statusPane, STATUS));
        BEdgePane inner = new BEdgePane();
        this.cfg = new BConfigDisplay();
        inner.setTop((BWidget)new BBorderPane((BWidget)this.cfg, CONFIGURATION));
        outer.setCenter((BWidget)inner);
        this.setContent((BWidget)outer);
    }

    protected void doLoadValue(BObject value, Context context) {
        BIHistory history = this.getHistory(value);
        if (history == null) {
            return;
        }
        BHistoryConfig config = history.getConfig();
        BasicContext tzContext = new BasicContext(context, BFacets.make((String)"TimeZone", (BIDataValue)config.getTimeZone(), (String)"showSeconds", (BIDataValue)BBoolean.TRUE));
        BHistorySpace space = (BHistorySpace)history.getSpace();
        try (HistorySpaceConnection conn = space.getConnection(context);){
            BHistorySummary summary = conn.getSummary(history);
            this.recCount.loadValue((BObject)BInteger.make((int)summary.getRecordCount()), context);
            this.firstTs.loadValue((BObject)summary.getFirstTimestamp(), (Context)tzContext);
            this.lastTs.loadValue((BObject)summary.getLastTimestamp(), (Context)tzContext);
        }
        this.cfg.loadValue((BObject)config);
        this.relayout();
    }

    protected BIHistory getHistory(BObject o) {
        if (o instanceof BIHistory) {
            return (BIHistory)o;
        }
        if (o instanceof BHistoryExt) {
            BHistoryExt ext = (BHistoryExt)o;
            ext.lease(1);
            BHistoryConfig cfg = ext.getHistoryConfig();
            BHistoryId id = cfg.getId();
            BOrd base = ext.getAbsoluteOrd();
            BOrd ord = BOrd.make((BOrd)base, (String)("history: " + id));
            return (BIHistory)ord.resolve().get();
        }
        return null;
    }
}

