/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BHistory;
import com.tridium.history.ui.BOutlierParams;
import com.tridium.history.ui.BOutlierParamsFE;
import com.tridium.history.ui.BTrendRecordEditor;
import com.tridium.history.ui.HistoryEditorTableModel;
import com.tridium.workbench.bql.filter.BFilterSetDialog;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import com.tridium.workbench.util.CollectionTableModel;
import java.util.HashMap;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.bql.BIBqlFilter;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BITrendHistoryAgent;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"history:IHistory"}, requiredPermissions="W")})
@NiagaraProperties(value={@NiagaraProperty(name="showTimeRangeEditor", type="boolean", defaultValue="true"), @NiagaraProperty(name="defaultTimeRange", type="BDynamicTimeRange", defaultValue="BDynamicTimeRange.DEFAULT")})
@NiagaraActions(value={@NiagaraAction(name="query", flags=16), @NiagaraAction(name="updateCommandStates")})
public class BHistoryEditor
extends BWbView
implements BITrendHistoryAgent {
    @Generated
    public static final Property showTimeRangeEditor = BHistoryEditor.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property defaultTimeRange = BHistoryEditor.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    @Generated
    public static final Action query = BHistoryEditor.newAction((int)16, null);
    @Generated
    public static final Action updateCommandStates = BHistoryEditor.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryEditor.class);
    private static BOutlierParams options;
    private static Lexicon lex;
    private final String lexRecords = lex.getText("records");
    private static HashMap<String, State> states;
    private BIHistory history;
    private Context tzContext;
    private boolean useBql;
    private BDynamicTimeRangeFE timeRangeEd;
    private BTitlePane tablePane;
    private BTable table;
    private int lastRowCount = 0;
    private boolean sizedToFit = false;
    private Command filterCmd;
    private BFilterSet filterSet;
    private Command outliersCmd;
    private BOutlierParams outlierParams;
    private Command editCmd;
    private Command selectOutliersCmd;
    private Command hideCmd;
    private Command unhideCmd;

    @Generated
    public boolean getShowTimeRangeEditor() {
        return this.getBoolean(showTimeRangeEditor);
    }

    @Generated
    public void setShowTimeRangeEditor(boolean v) {
        this.setBoolean(showTimeRangeEditor, v, null);
    }

    @Generated
    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    @Generated
    public void setDefaultTimeRange(BDynamicTimeRange v) {
        this.set(defaultTimeRange, (BValue)v, null);
    }

    @Generated
    public void query() {
        this.invoke(query, null, null);
    }

    @Generated
    public void updateCommandStates() {
        this.invoke(updateCommandStates, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistoryEditor() {
        this.initCommands();
        BEdgePane main = new BEdgePane();
        this.timeRangeEd = new BDynamicTimeRangeFE();
        this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY);
        this.timeRangeEd.setVisible(this.getShowTimeRangeEditor());
        main.setTop((BWidget)this.timeRangeEd);
        this.table = new BTable();
        this.table.setModel((TableModel)new HistoryEditorTableModel(null));
        this.table.setController((TableController)new Controller());
        this.table.setMultipleSelection(true);
        this.tablePane = BTitlePane.makePane((String)"", (BTable)this.table, (String)this.lexRecords);
        main.setCenter((BWidget)this.tablePane);
        BGridPane buttons = new BGridPane(2);
        buttons.setUniformColumnWidth(true);
        buttons.setColumnAlign(BHalign.fill);
        buttons.setRowAlign(BValign.fill);
        buttons.add(null, (BValue)new BButton(this.editCmd));
        buttons.add(null, (BValue)new BButton(this.selectOutliersCmd));
        main.setBottom((BWidget)new BBorderPane((BWidget)buttons, 2.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)main);
        this.linkTo("modLink", (BComponent)this.timeRangeEd, (Slot)BWbFieldEditor.setModified, (Slot)query);
        this.linkTo("tableSelection", (BComponent)this.table, (Slot)BTable.selectionModified, (Slot)updateCommandStates);
        this.outlierParams = BHistoryEditor.getDefaultParams();
        ((HistoryEditorTableModel)this.table.getModel()).setOutlierParams(this.outlierParams);
    }

    public BToolBar getViewToolBar() {
        BToolBar tb = new BToolBar();
        tb.add("hide", this.hideCmd);
        tb.add("unhide", this.unhideCmd);
        tb.add(null, (BValue)new BSeparator());
        tb.add("filter", this.filterCmd);
        tb.add("outliers", this.outliersCmd);
        return tb;
    }

    public BMenu[] getViewMenus() {
        BMenu menu = new BMenu(lex.getText("historyEditor"));
        menu.add("hide", this.hideCmd);
        menu.add("unhide", this.unhideCmd);
        menu.add(null, (BValue)new BSeparator());
        menu.add("filter", this.filterCmd);
        menu.add("outliers", this.outliersCmd);
        menu.add("selectOutliers", this.selectOutliersCmd);
        return new BMenu[]{menu};
    }

    private void initCommands() {
        this.filterCmd = new Command((BWidget)this, BHistoryEditor.lex.module, "command.filter"){

            public CommandArtifact doInvoke() {
                BHistoryEditor.this.configFilters();
                return null;
            }
        };
        this.outliersCmd = new Command((BWidget)this, BHistoryEditor.lex.module, "historyEditor.configOutliers"){

            public CommandArtifact doInvoke() {
                BHistoryEditor.this.configOutliers();
                return null;
            }
        };
        this.editCmd = new EditCommand();
        this.selectOutliersCmd = new Command((BWidget)this, BHistoryEditor.lex.module, "historyEditor.selectOutliers"){

            public CommandArtifact doInvoke() {
                BHistoryEditor.this.selectOutliers();
                return null;
            }
        };
        this.hideCmd = new Command((BWidget)this, BHistoryEditor.lex.module, "historyEditor.hide"){

            public CommandArtifact doInvoke() {
                BHistoryEditor.this.setRecordsHidden(true);
                return null;
            }
        };
        this.unhideCmd = new Command((BWidget)this, BHistoryEditor.lex.module, "historyEditor.unhide"){

            public CommandArtifact doInvoke() {
                BHistoryEditor.this.setRecordsHidden(false);
                return null;
            }
        };
        this.editCmd.setEnabled(false);
        this.hideCmd.setEnabled(false);
        this.unhideCmd.setEnabled(false);
    }

    /*
     * Unable to fully structure code
     */
    public void doLoadValue(BObject value, Context context) throws Exception {
        this.history = this.getHistory(value);
        this.tzContext = new BasicContext(context, BFacets.make((String)"TimeZone", (BIDataValue)this.history.getConfig().getTimeZone()));
        this.tablePane.setTitle(this.history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
        valueFacets = BFacets.NULL;
        try {
            valueFacets = (BFacets)this.history.getConfig().get("valueFacets");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        space = (BHistorySpace)this.history.getSpace();
        this.useBql = true;
        try {
            BOrd.make((BOrd)space.getAbsoluteOrd(), (String)"bql:").resolve();
        }
        catch (Exception e) {
            this.useBql = false;
        }
        defRange = this.getDefaultTimeRange();
        if (defRange == BDynamicTimeRange.DEFAULT) {
            conn = space.getConnection(context);
            var7_9 = null;
            try {
                this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.make((BAbsTime)conn.getFirstTimestamp(this.history), (BAbsTime)BAbsTime.NULL), this.tzContext);
                recordCount = conn.getRecordCount(this.history);
                firstTs = conn.getFirstTimestamp(this.history);
                lastTs = conn.getLastTimestamp(this.history);
                if (recordCount <= 500) ** GOTO lbl50
                now = Clock.time();
                if (now.dateEquals(lastTs)) {
                    this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY, this.tzContext);
                }
                range = BDynamicTimeRange.make((BAbsTime)lastTs.timeOfDay(0, 0, 0, 0), (BAbsTime)BAbsTime.NULL);
                this.timeRangeEd.loadValue((BObject)range, this.tzContext);
            }
            catch (Throwable var8_12) {
                var7_9 = var8_12;
                throw var8_12;
            }
            finally {
                if (conn != null) {
                    if (var7_9 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable var8_11) {
                            var7_9.addSuppressed(var8_11);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        } else {
            this.timeRangeEd.loadValue((BObject)defRange, this.tzContext);
        }
lbl50:
        // 4 sources

        rec = (BTrendRecord)this.history.getConfig().makeRecord();
        this.outliersCmd.setEnabled(rec.getValueProperty().getType().is(BINumeric.TYPE));
        this.restoreState(this.toKey());
        this.query();
    }

    public BObject doSaveValue(BObject value, Context context) throws Exception {
        BIHistory h = (BIHistory)value;
        HistoryEditorTableModel model = (HistoryEditorTableModel)this.table.getModel();
        int recCount = model.getRowCount();
        BHistorySpace space = (BHistorySpace)this.history.getSpace();
        try (HistorySpaceConnection conn = space.getConnection(context);){
            for (int i = 0; i < recCount; ++i) {
                if (!model.isModified(i)) continue;
                conn.update(this.history, (BHistoryRecord)model.getRecord(i));
            }
        }
        model.clearModified();
        return value;
    }

    public void changed(Property p, Context cx) {
        if (p == showTimeRangeEditor) {
            this.timeRangeEd.setVisible(this.getShowTimeRangeEditor());
        }
    }

    private void editRecords() {
        int[] selections = this.table.getSelection().getRows();
        if (selections.length == 0) {
            return;
        }
        BTrendRecord rec = null;
        boolean hidden = false;
        BSimple value = null;
        String editTitle = null;
        BIRandomAccessTable itable = ((CollectionTableModel)this.table.getModel()).getBITable();
        BFacets valueFacets = itable.getColumns().get("value").getFacets();
        if (selections.length == 1) {
            rec = ((HistoryEditorTableModel)this.table.getModel()).getRecord(selections[0]);
            editTitle = lex.getText("historyEditor.editRecord");
        } else {
            rec = (BTrendRecord)this.history.getConfig().makeRecord();
            editTitle = lex.getText("historyEditor.editRecords");
        }
        hidden = rec.getTrendFlags().getBit(4);
        value = (BSimple)rec.get(rec.getValueProperty());
        BTrendRecordEditor editor = new BTrendRecordEditor(hidden, value, valueFacets);
        int rc = BDialog.open((BWidget)this, (String)editTitle, (Object)new BBorderPane((BWidget)editor), (int)3);
        if (rc == 2) {
            return;
        }
        boolean modified = false;
        try {
            HistoryEditorTableModel model = (HistoryEditorTableModel)this.table.getModel();
            modified = model.modifyRecords(selections, editor.getHidden(), editor.getValue());
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)lex.getText("historyEditor.editError.title"), (Object)lex.getText("historyEditor.editError.msg"), (Throwable)e);
            return;
        }
        if (modified) {
            this.setModified();
        }
    }

    private void setRecordsHidden(boolean hidden) {
        int[] selections = this.table.getSelection().getRows();
        if (selections.length == 0) {
            return;
        }
        HistoryEditorTableModel model = (HistoryEditorTableModel)this.table.getModel();
        if (model.modifyRecords(selections, BBoolean.make((boolean)hidden), null)) {
            this.setModified();
        }
    }

    private void updateTitle() {
        BIHistory history = this.getHistory(this.getCurrentValue());
        if (history == null) {
            this.tablePane.setTitle("");
            return;
        }
        String newTitle = history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX);
        if (this.filterSet != null && this.filterSet.anyActive()) {
            newTitle = newTitle + "*";
        }
        if (this.outlierParams.getEnabled()) {
            newTitle = newTitle + " " + lex.getText("historyEditor.withOutliers");
        }
        this.tablePane.setTitle(newTitle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doQuery() {
        BWidgetShell shell;
        if (this.isModified()) {
            int buttons;
            String msg;
            String title = lex.getText("confirmSubmit.title");
            int result = BDialog.confirm((BWidget)this, (String)title, (Object)(msg = lex.getText("confirmSubmit")), (int)(buttons = 14));
            if (result == 4) {
                try {
                    this.saveValue(null);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            } else if (result == 2) {
                return;
            }
        }
        if ((shell = this.getShell()) != null) {
            shell.enterBusy();
        }
        this.table.getSelection().deselectAll();
        BIHistory history = this.getHistory(this.getCurrentValue());
        BHistorySpace historySpace = (BHistorySpace)history.getSpace();
        BHistoryId id = history.getId();
        BITable result = null;
        BDynamicTimeRange timeRange = null;
        try {
            try {
                timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (String)lex.getText("timerange.error"), (Object)lex.getText("timerange.checkRange"), (Throwable)e);
                throw new BajaRuntimeException((Throwable)e);
            }
            BOrd historyOrd = history.getOrdInSession();
            BOrd historyQuery = BOrd.make((String)(historyOrd.toString() + "?" + timeRange.toOrdParams()));
            if (this.useBql) {
                String filterQual;
                StringBuilder ordText = new StringBuilder(64);
                ordText.append(historyQuery.toString()).append('|');
                ordText.append("bql:select *");
                StringBuilder predicate = new StringBuilder(64);
                if (this.filterSet != null && (filterQual = this.filterSet.getPredicate()) != null && filterQual.length() > 0) {
                    if (predicate.length() != 0) {
                        predicate.append(" and ");
                    }
                    predicate.append(filterQual);
                }
                if (predicate.length() != 0) {
                    ordText.append(" where ").append(predicate.toString());
                }
                BOrd ord = BOrd.make((BOrd)history.getAbsoluteOrd(), (BOrd)BOrd.make((String)ordText.toString())).normalize();
                result = (BITable)ord.resolve(null, HistoryQuery.makeExcludeArchiveDataContext(null)).get();
            } else {
                BOrd ord = BOrd.make((BOrd)history.getAbsoluteOrd(), (BOrd)historyQuery).normalize();
                result = (BITable)ord.resolve(null, HistoryQuery.makeExcludeArchiveDataContext(null)).get();
            }
            ((HistoryEditorTableModel)this.table.getModel()).setCollection((BITable<? extends BIObject>)result);
            try {
                this.saveValue(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clearModified();
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
        this.updateTitle();
        this.tablePane.tableModified();
    }

    public void configOutliers() {
        if (this.outlierParams == null) {
            this.outlierParams = BHistoryEditor.getDefaultParams();
        }
        BOutlierParamsFE editor = new BOutlierParamsFE();
        editor.loadValue((BObject)this.outlierParams, this.tzContext);
        int rc = BDialog.open((BWidget)this, (String)lex.getText("historyEditor.configOutliers.label"), (Object)((Object)editor), (int)3);
        if (rc == 2) {
            return;
        }
        if (!editor.isModified()) {
            return;
        }
        try {
            this.outlierParams = (BOutlierParams)editor.saveValue();
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)lex.getText("historyEditor.configOutliers.error.title"), (Object)lex.getText("historyEditor.configOutliers.error.msg"), (Throwable)e);
            return;
        }
        ((HistoryEditorTableModel)this.table.getModel()).setOutlierParams(this.outlierParams);
        this.updateTitle();
        this.updateCommandStates();
        this.table.repaint();
    }

    public void selectOutliers() {
        ((HistoryEditorTableModel)this.table.getModel()).selectOutliers();
    }

    public static BOutlierParams getDefaultParams() {
        if (options == null) {
            options = (BOutlierParams)BOptions.load((Type)BOutlierParams.TYPE);
        }
        return options;
    }

    protected BIHistory getHistory(BObject o) {
        if (o instanceof BIHistory) {
            return (BIHistory)o;
        }
        if (o instanceof BHistoryExt) {
            BHistoryExt ext = (BHistoryExt)o;
            ext.lease(1);
            BHistoryConfig cfg = ext.getHistoryConfig();
            BHistoryId id = cfg.getId();
            BOrd base = ext.getAbsoluteOrd();
            BOrd ord = BOrd.make((BOrd)base, (String)("history: " + id));
            return (BIHistory)ord.resolve(null, HistoryQuery.makeExcludeArchiveDataContext(null)).get();
        }
        return null;
    }

    public void configFilters() {
        if (this.table == null) {
            return;
        }
        if (this.filterSet == null) {
            BIRandomAccessTable itable = ((CollectionTableModel)this.table.getModel()).getBITable();
            this.filterSet = this.buildFilterSet((BIRandomAccessTable<? extends BIObject>)itable);
        }
        BFilterSetDialog dialog = new BFilterSetDialog((BWidget)this, this.filterSet);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        if (dialog.isCancelled()) {
            return;
        }
        if (!dialog.isModified()) {
            return;
        }
        this.filterSet = dialog.getResult();
        this.query();
    }

    private BFilterSet buildFilterSet(BIRandomAccessTable<? extends BIObject> table) {
        ColumnList columns = table.getColumns();
        int colCount = columns.size();
        BFilterSet set = new BFilterSet();
        for (int i = 0; i < colCount; ++i) {
            Type colType = null;
            BFacets colFacets = null;
            try {
                AgentList agents;
                BObject proto;
                String typeSpec;
                Column col = columns.get(i);
                colFacets = col.getFacets();
                if (colFacets != null && (typeSpec = colFacets.gets("origType", null)) != null) {
                    colType = BTypeSpec.make((String)typeSpec).getResolvedType();
                }
                if (colType == null) {
                    colType = col.getType();
                }
                if ((proto = colType.getInstance()) instanceof BEnum && colFacets != null && colFacets.getFacet("range") != null) {
                    proto = BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)colFacets.getFacet("range")));
                }
                if ((agents = proto.getAgents().filter(AgentFilter.is((Type)BIBqlFilter.TYPE))).size() == 0) continue;
                BIBqlFilter filter = (BIBqlFilter)agents.getDefault().getInstance();
                filter.init(proto);
                BFilterEntry entry = new BFilterEntry(false, col.getDisplayName(this.getCurrentContext()), filter);
                set.add(col.getName(), (BValue)entry, 0, colFacets, null);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            set.remove("timestamp");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return set;
    }

    public void doUpdateCommandStates() {
        boolean empty = this.table.getSelection().isEmpty();
        this.editCmd.setEnabled(!empty);
        this.hideCmd.setEnabled(!empty);
        this.unhideCmd.setEnabled(!empty);
        this.selectOutliersCmd.setEnabled(this.outlierParams.getEnabled());
    }

    private String toKey() {
        BWbShell shell = this.getWbShell();
        if (shell == null) {
            return null;
        }
        OrdTarget ordTarget = shell.getActiveOrdTarget();
        if (ordTarget == null) {
            return null;
        }
        return "" + ordTarget.getOrdWithoutViewQuery();
    }

    public void activated() {
        this.restoreState(this.toKey());
    }

    public void deactivated() {
        this.saveState(this.toKey());
    }

    private void saveState(String key) {
        try {
            State state = new State();
            state.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
            state.filterSet = this.filterSet == null ? null : (BFilterSet)this.filterSet.newCopy(true);
            state.outlierParams = this.outlierParams == null ? null : (BOutlierParams)this.outlierParams.newCopy(true);
            states.put(key, state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void restoreState(String key) {
        if (key == null) {
            return;
        }
        State state = states.get(key);
        if (state == null) {
            return;
        }
        this.timeRangeEd.loadValue((BObject)state.timeRange, this.tzContext);
        this.filterSet = state.filterSet;
        this.outlierParams = state.outlierParams;
        ((HistoryEditorTableModel)this.table.getModel()).setOutlierParams(this.outlierParams);
    }

    static {
        lex = Lexicon.make((String)"history");
        states = new HashMap();
    }

    private class State {
        BDynamicTimeRange timeRange;
        BFilterSet filterSet;
        BOutlierParams outlierParams;

        private State() {
        }
    }

    private class EditCommand
    extends Command {
        public EditCommand() {
            super((BWidget)BHistoryEditor.this, lex.module, "historyEditor.editRecords");
        }

        public CommandArtifact doInvoke() {
            BHistoryEditor.this.editRecords();
            return null;
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellPopup(BMouseEvent event, int x, int y) {
            BMenu menu = new BMenu();
            menu.add("hide", BHistoryEditor.this.hideCmd);
            menu.add("unhide", BHistoryEditor.this.unhideCmd);
            menu.add(null, (BValue)new BSeparator());
            menu.add("edit", BHistoryEditor.this.editCmd);
            menu.add("selectOutliers", BHistoryEditor.this.selectOutliersCmd);
            menu.open((BWidget)BHistoryEditor.this.table, event.getX(), event.getY());
        }

        protected void cellDoubleClicked(BMouseEvent event, int x, int y) {
            BHistoryEditor.this.editRecords();
        }

        protected void handleEnter(BKeyEvent event) {
            BHistoryEditor.this.editRecords();
        }
    }
}

