/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.history.BHistoryMirror;
import com.tridium.ui.UiEnv;
import com.tridium.workbench.nav.BNavContainerView;
import java.util.Comparator;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryQuery;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"driver:HistoryDeviceExt"}, requiredPermissions="r")})
public class BDeviceHistoriesView
extends BNavContainerView
implements NavListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BDeviceHistoriesView.class);
    private static Lexicon lex = Lexicon.make((String)"history");
    private static final Comparator<BIHistory> histNameComparator = new HistoryNameComparator();
    private static final BTypeSpec DEVICE_TYPE = BTypeSpec.make((String)"driver:Device");
    String historyDeviceName;
    BHistorySpace space;
    Work work = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BWidget content;
        this.space = BDeviceHistoriesView.getHistorySpace(value);
        super.doLoadValue(value, cx);
        if (this.space != null) {
            this.space.fw(9903, (Object)this, null, null, null);
        }
        if ((content = this.getContent()) instanceof BTitlePane) {
            if (this.historyDeviceName == null) {
                ((BTitlePane)content).setTitle(lex.getText("deviceHistoriesView.title.unknown"));
            } else {
                ((BTitlePane)content).setTitle(lex.getText("deviceHistoriesView.title", new Object[]{this.historyDeviceName}));
            }
        }
    }

    public void deactivated() {
        if (this.space != null) {
            this.space.fw(9903, (Object)this, (Object)BBoolean.TRUE, null, null);
        }
    }

    public void stopped() {
        if (this.space != null) {
            this.space.fw(9903, (Object)this, (Object)BBoolean.TRUE, null, null);
        }
    }

    protected BTable makeNavTable(BINavNode container) {
        this.historyDeviceName = BDeviceHistoriesView.getHistoryDeviceName((BValue)container, this.space);
        BINavNode[] children = null;
        if (this.historyDeviceName != null && this.space != null && this.space.deviceExists(this.historyDeviceName)) {
            BHistoryDevice dev = this.space.getDevice(this.historyDeviceName);
            Object[] histories = this.space.listHistories(dev);
            SortUtil.sort((Object[])histories, (Object[])histories, histNameComparator);
            int len = histories.length;
            children = new BINavNode[len];
            for (int i = 0; i < len; ++i) {
                children[i] = new BHistoryMirror((BIHistory)histories[i], container, true);
            }
        } else {
            children = new BINavNode[]{};
        }
        this.rows = new BNavContainerView.Row[children.length];
        for (int i = 0; i < children.length; ++i) {
            this.rows[i] = new BNavContainerView.Row(children[i]);
        }
        return new BTable((TableModel)new BNavContainerView.Model((BNavContainerView)this), (TableController)new BNavContainerView.Controller((BNavContainerView)this));
    }

    static String getHistoryDeviceName(BValue val, BHistorySpace space) {
        Type deviceType = DEVICE_TYPE.getResolvedType();
        String devName = null;
        if (val instanceof BComplex) {
            BValue slotVal;
            for (BComplex parent = (BComplex)val; parent != null; parent = parent.getParent()) {
                if (!parent.getType().is(deviceType)) continue;
                devName = parent.getName();
                break;
            }
            if ((devName == null || space != null && !space.deviceExists(devName)) && (slotVal = ((BComplex)val).get("historyDeviceName")) instanceof BString && !slotVal.equals((Object)BString.DEFAULT)) {
                devName = slotVal.toString();
            }
        }
        return devName;
    }

    static BHistorySpace getHistorySpace(BObject val) {
        try {
            BOrd ord = BOrd.make((String)"history:");
            return (BHistorySpace)ord.get(val);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void navEvent(NavEvent event) {
        BOrd parentOrd = event.getParentOrd();
        OrdQuery[] list = parentOrd.parse();
        OrdQuery leaf = list[list.length - 1];
        if (!(leaf instanceof HistoryQuery)) {
            return;
        }
        HistoryQuery query = (HistoryQuery)leaf;
        if (!query.isDeviceQuery()) {
            return;
        }
        String devName = query.getDeviceName();
        if (this.historyDeviceName != null && !this.historyDeviceName.equals(devName)) {
            return;
        }
        if (this.work == null) {
            this.work = new Work(this);
        }
        UiEnv.get().invokeLater((Runnable)this.work);
    }

    private static class HistoryNameComparator
    implements Comparator<BIHistory> {
        private HistoryNameComparator() {
        }

        @Override
        public int compare(BIHistory h1, BIHistory h2) {
            return h1.getNavDisplayName(null).compareTo(h2.getNavDisplayName(null));
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof HistoryNameComparator;
        }
    }

    static class Work
    implements Runnable {
        BDeviceHistoriesView view;

        public Work(BDeviceHistoriesView view) {
            this.view = view;
        }

        @Override
        public void run() {
            try {
                this.view.makeNavTable((BINavNode)this.view.getCurrentValue());
                this.view.relayout();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

